/*******************************************************************************
*																										 *
*   CDTEST2: Second half of the pair, virtually identical to the first.        *
*																										 *
*   9/9/93 by Mark Gamber                                                      * 
*																										 *
*******************************************************************************/

#include "windows.h"
#include "memory.h"

// -----------------------------------------------------------------------------

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );

// -----------------------------------------------------------------------------

HINSTANCE hInst;

// -----------------------------------------------------------------------------

int CALLBACK WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd, int nShow )
{
	hInst = hInstance;
	DialogBox( hInstance, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
	return( FALSE );
}


BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
		{
			char szWinName[ 32 ];
			HWND hOther;

			LoadString( hInst, 100, szWinName, 32 );	      //  Title of other half
			hOther = FindWindow( (LPSTR)0, szWinName );	     //  Locate other half
			if( ! hOther )									      //  If window not found...
			{
				LoadString( hInst, 101, szWinName, 32 );
				WinExec( szWinName, SW_SHOW );		    //  Attempt to start program
				Sleep( 500 );									            //  Wait a bit...
				LoadString( hInst, 100, szWinName, 32 );	    //  Now try the window
				hOther = FindWindow( (LPSTR)0, szWinName );
				if( ! hOther )
				{											  //  If still not there, forget it
					EndDialog( hDlg, FALSE );
					return( FALSE );
				}
			}
			SendMessage( GetDlgItem( hDlg, 102 ), EM_LIMITTEXT, 127, 0 );
			return( TRUE );
		}

		case WM_COPYDATA:
		{
			COPYDATASTRUCT *cds;
			char str[ 128 ];

		   cds = (COPYDATASTRUCT *)lParam;
			if( cds->dwData == 1 )
			{
				SetDlgItemText( hDlg, 103, "" );
				return( TRUE );
			}
			if( cds->dwData == 0 )
			{
				memcpy( str, cds->lpData, cds->cbData );
				str[ cds->cbData ] = '\0';
				SetDlgItemText( hDlg, 103, str );
				return( TRUE );
			}
			return( FALSE );
		}

		case WM_COMMAND:
		{
			if( wParam == IDCANCEL )
			{
				EndDialog( hDlg, TRUE );
				return( TRUE );
			}
			if( wParam == 100 )		                 //  Copy from here to there...
			{
				char szWinName[ 32 ];
				char szText[ 128 ];
				LONG lResult;
				HWND hOther;
            COPYDATASTRUCT cds;

				if( ! GetDlgItemText( hDlg, 102, szText, 128 ) )
					break;

				LoadString( hInst, 100, szWinName, 32 );
				hOther = FindWindow( (LPSTR)0, szWinName );
				if( ! hOther )
					break;

				cds.dwData = 0;
				cds.lpData = (LPSTR)szText;
				cds.cbData = lstrlen( szText );
				lResult = SendMessage( hOther, WM_COPYDATA, (WPARAM)hDlg,
											  (LPARAM)(COPYDATASTRUCT *)&cds );
				break;
			}
			if( wParam == 101 )
			{
				char szWinName[ 32 ];
				char szText[ 128 ];
				LONG lResult;
				HWND hOther;
            COPYDATASTRUCT cds;

				LoadString( hInst, 100, szWinName, 32 );
				hOther = FindWindow( (LPSTR)0, szWinName );
				if( ! hOther )
					break;

				cds.dwData = 1;
				cds.lpData = (LPSTR)0;
				cds.cbData = 0;
				lResult = SendMessage( hOther, WM_COPYDATA, (WPARAM)hDlg,
											  (LPARAM)(COPYDATASTRUCT *)&cds );
				break;
			}
			break;
		}
	}
	return( FALSE );
}


