//****************************************************************************
//      File:  APPDLG.C                                                    
//                                                                         
//   Purpose:  
//                                                                         
// Functions:  
//             
//                                                                         
// Development Team:
//
//       Greg Keyser
//
// Written by Microsoft Product Support Services, Windows Developer Support
// Copyright (c) 1992 Microsoft Corporation. All rights reserved.
//****************************************************************************

#include "windows.h"
#include "cpl.h"
#include "commdlg.h"
#include "colordlg.h"
#include "dlgs.h"
#define IN_INIT
#include "global.h"
#undef IN_INIT

//****************************************************************************
// Function: InitializeStruct
//
// Purpose:  To initialize a structure for the current common dialog.    
//           This routine is called just before the common dialogs       
//           API is called.                                              
//
// Parameters:
//    wCommDlgType == Indicates the type of common dialog we need to initialize
//    lpStruct     == Long pointer to memory block for the structure
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL InitializeStruct(WORD wCommDlgType, LPSTR lpStruct)
{

   LPCOLORSCHUNK       lpColorsChunk;
   WORD                wCtr;
   HDC                 hDC;
   
   switch (wCommDlgType)
      {
      case IDC_COLORS:

         lpColorsChunk = (LPCOLORSCHUNK)lpStruct;

         hDC = GetDC(ghWnd);
         lpColorsChunk->dwCustClrs[0]=GetBkColor(hDC);
         ReleaseDC(ghWnd, hDC);
 
         for (wCtr=1; wCtr<=15; wCtr++)
            lpColorsChunk->dwCustClrs[wCtr]= lpColorsChunk->dwCustClrs[0];

         lpColorsChunk->chsclr.lStructSize    = sizeof(CHOOSECOLOR);  
         lpColorsChunk->chsclr.hwndOwner      = ghWnd;
         lpColorsChunk->chsclr.hInstance      = ghInst;
         lpColorsChunk->chsclr.rgbResult      = (DWORD)(lpColorsChunk->dwColor);
         lpColorsChunk->chsclr.lpCustColors   = (LPDWORD)(lpColorsChunk->dwCustClrs);
         lpColorsChunk->chsclr.Flags          = CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN | CC_ENABLETEMPLATE;
         lpColorsChunk->chsclr.lCustData      = 0L;
	      lpColorsChunk->chsclr.lpfnHook       = (FARHOOK)ColorHook;
         lpColorsChunk->chsclr.lpTemplateName = (LPSTR)"ChooseColor";
         break;

      default:

         break;

      }

   return;

}


//****************************************************************************
// Function: AllocAndLockMem
//
// Purpose: To allocate and lock a chunk of memory for the CD structure
//
// Parameters:
//    *hChunk == Pointer to handle of memory that will be allocated
//    wSize   == Size of memory block to allocate
//
// Returns : LPSTR to block of memory allocated
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
LPSTR FAR PASCAL AllocAndLockMem(HANDLE FAR *hChunk, WORD wSize)
{
   LPSTR lpChunk;

   *hChunk = GlobalAlloc(GMEM_FIXED, wSize);

   if (*hChunk)
      {
         lpChunk = GlobalLock(*hChunk);
         if (!lpChunk)
            {
               GlobalFree(*hChunk);
               ReportError(IDC_LOCKFAIL);
               lpChunk=NULL;
            }
      }
   else
      {
         ReportError(IDC_ALLOCFAIL);
         lpChunk=NULL;
      }
   return(lpChunk);
}

//****************************************************************************
// Function: LaunchApplet
//
// Purpose:  Controls the processing to allocate memory for the dialog,  
//           initialize the structure that will be passed to the         
//           ChooseColor() API, call ChooseColor() and finally process   
//           the return value.
//
// Parameters: None
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL LaunchApplet(void)
{
   WORD  wSize;
   DWORD dwError;

   wSize=sizeof(COLORSCHUNK);

   if (!(glpColorsChunk=(LPCOLORSCHUNK)AllocAndLockMem(&ghColorsChunk, wSize)))
      return;

   InitializeStruct(IDC_COLORS, (LPSTR)glpColorsChunk);

   if (ChooseColor( &(glpColorsChunk->chsclr) ))
      {
         SaveToWinIni();
      }
   else
      {
         dwError=CommDlgExtendedError();

         if (dwError == 0)  //the user hit CANCEL
            {
               if (gbSystemColorHasChanged)
                  SetSysColors(NUMCOLORSSUPPORTED, (LPINT)&giSysColorArea,
                               (COLORREF FAR*)&gdwOldSysColors);
            }
         else
            ProcessCDError(dwError);
      }

   return;
}


//****************************************************************************
// Function: GetRGBValues
//
// Purpose:  This routine will grab the RGB values from the edit controls
//           in the common dialog.                                       
//
// Parameters: 
//      hDlg    == Handle to the ChooseColor dialog
//     *wRed    == Pointer to value for Red
//     *wGreen  == Pointer to value for Green
//     *wBlue   == Pointer to value for Blue
//
//
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL GetRGBValues(HWND hDlg, WORD FAR *wRed, WORD FAR *wGreen,
                             WORD FAR *wBlue)
{
   *wRed  =GetDlgItemInt(hDlg, COLOR_RED, NULL, FALSE);
   *wGreen=GetDlgItemInt(hDlg, COLOR_GREEN, NULL, FALSE);
   *wBlue =GetDlgItemInt(hDlg, COLOR_BLUE, NULL, FALSE);
   return;
}   


//****************************************************************************
// Function: LoadMyString(WORD)
//
// Purpose:  This routine will load a string.  Reports error on failure. 
//
//
// Parameters: 
//     szString == Buffer to contain the loaded string
//    wStringID == ID value of string to be loaded
//
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL LoadMyString(LPSTR szString, WORD wStringID)
{
   if (!LoadString(ghInst, wStringID, szString, MAXSTRINGDESCLEN))
      {
         ReportError(IDC_LOADSTRINGFAIL);
         return;
      }
   
   return;
}

//****************************************************************************
// Function: ColorHook(HWND, unsigned, WORD, LONG)
//
// Purpose:  This routine hooks all the messages being sent to the dialog.
//           This is the heart of the application.
//
//
// Parameters: 
//         hDlg == Handle to the dialog window        
//      message == Current message
//       wParam == Varies, depending on message
//       lParam == Varies, depending on message
//
//
// Returns : TRUE, indicating message has been processed and COMMDLG.DLL
//           should provide no further processing.  FALSE to indicate that
//           COMMDLG.DLL should provide default processing for this message.
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
BOOL FAR PASCAL ColorHook(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
  static BOOL    bDragging=FALSE;
  static HCURSOR hPaintCanCursor;    //Cursor used when dragging a color
  static HWND    hWndSpecialIcon;    //Icon wnd representing active border, 
                                     //disabled text, menu highlight and
                                     //highlighted text.
         WORD    wRed; 
         WORD    wGreen;
         WORD    wBlue;
         LONG    lHitTestArea;
         HWND    hCurrentWnd, hChild;
         int     iSysArea=COLOR_ACTIVEBORDER;
  static int     iLastSysArea=0;
         DWORD   dwColor;
         char    szClassName[64];               //Class name of window cursor is over
         char    szAreaDesc[MAXSTRINGDESCLEN];  //Description of area cursor is over
         BOOL    bUpdate=TRUE;

  switch (message)
    {
       case WM_INITDIALOG:
      
          hPaintCanCursor=LoadCursor(ghInst, "PaintCan");
          ShowWindow(GetDlgItem(hDlg, COLOR_MIX), SW_HIDE);
          LoadMyString(szAreaDesc, IDS_NOTHING);
          SetDlgItemText(hDlg, stc2, (LPSTR)szAreaDesc);
          LoadMyString(szAreaDesc, IDS_SYSTEMCOLORDROPPER);
          SetWindowText(hDlg, szAreaDesc);
          hWndSpecialIcon=GetDlgItem(hDlg, stc10);
          gbSystemColorHasChanged=FALSE;

//The following line IS necessary....

          SendMessage(hWndSpecialIcon, STM_SETICON, 
                      LoadIcon(ghInst, "SpecialArea"), 0L);

          return  (TRUE);

       case WM_LBUTTONDOWN:

//If we're over the Rainbow control.....

          if (GetDlgItem(hDlg, COLOR_RAINBOW)==ChildWindowFromPoint(hDlg, MAKEPOINT(lParam)))
             break;

//..or the Lumoniscity control, don't capture the mouse.

          if (GetDlgItem(hDlg, COLOR_LUMSCROLL)==ChildWindowFromPoint(hDlg, MAKEPOINT(lParam)))
             break;

//If we're over a color, capture the mouse, otherwise ignore this message

          if (GetDlgItem(hDlg, COLOR_BOX1)==
                     ChildWindowFromPoint(hDlg,MAKEPOINT(lParam)) ||
              GetDlgItem(hDlg, COLOR_CUSTOM1)==
                     ChildWindowFromPoint(hDlg, MAKEPOINT(lParam)))
          {
             bDragging=TRUE;
             SetCapture(hDlg);
             SetCursor(hPaintCanCursor);
//             do
//             {
//                MSG Msg;
//
//                while (PeekMessage(&Msg, NULL, NULL, NULL, PM_REMOVE))
//                   DispatchMessage(&Msg);
//             }
//             while (GetAsyncKeyState(VK_LBUTTON) & 0x8000);
          }
          break;
       
       case WM_CANCELMODE:

//WM_CANCELMODE means that a dialog or some other modal process has started.
//We must make sure that we release capture at this point.

          if (bDragging)
          {
             ReleaseCapture();
             bDragging=FALSE;
             return(TRUE);
          }
          break;

       case WM_MOUSEMOVE:

          if (bDragging)
          {
             ClientToScreen(hDlg, (LPPOINT)&lParam);
             hCurrentWnd=WindowFromPoint(MAKEPOINT(lParam));

//This code determines if we are over a child window...

             for (;;)
             {
                ScreenToClient(hCurrentWnd, (LPPOINT)&lParam);
                hChild=ChildWindowFromPoint(hCurrentWnd, MAKEPOINT(lParam));
                ClientToScreen(hCurrentWnd, (LPPOINT)&lParam);
                if (hChild && hChild != hCurrentWnd)
                   hCurrentWnd=hChild;
                else
                   break;
             }

             GetClassName(hCurrentWnd, szClassName, sizeof(szClassName));

//Let Windows tell us where the cursor is...

             lHitTestArea=DefWindowProc(hCurrentWnd, WM_NCHITTEST, 0, lParam);

//
             iSysArea=GetUpdateArea(hCurrentWnd, &bUpdate, lHitTestArea,
                                    szClassName, szAreaDesc, lParam,
                                    hWndSpecialIcon);

             if (iSysArea != iLastSysArea)
             {
                iLastSysArea=iSysArea;
                SetDlgItemText(hDlg, stc2, szAreaDesc);
             }
          }
          break;

       case WM_LBUTTONUP:

          if (bDragging)  
          {
             bUpdate=TRUE;

             ClientToScreen(hDlg, (LPPOINT)&lParam);
             hCurrentWnd=WindowFromPoint(MAKEPOINT(lParam));

             for (;;)
             {
                ScreenToClient(hCurrentWnd, (LPPOINT)&lParam);
                hChild=ChildWindowFromPoint(hCurrentWnd, MAKEPOINT(lParam));
                ClientToScreen(hCurrentWnd, (LPPOINT)&lParam);
                if (hChild && hChild != hCurrentWnd)
                   hCurrentWnd=hChild;
                else
                   break;
             }

             GetClassName(hCurrentWnd, szClassName, sizeof(szClassName));
             lHitTestArea=DefWindowProc(hCurrentWnd, WM_NCHITTEST, 0, lParam);

             iSysArea=GetUpdateArea(hCurrentWnd, &bUpdate, lHitTestArea,
                                    szClassName, szAreaDesc, lParam,
                                    hWndSpecialIcon);

             if (bUpdate)
             {
                GetRGBValues(hDlg, &wRed, &wGreen, &wBlue);
                dwColor=RGB(wRed, wGreen, wBlue);
                gbSystemColorHasChanged=TRUE;

                SetSysColors(1, (LPINT)&iSysArea, (COLORREF FAR*)&dwColor);
             }  

             SetCursor(LoadCursor(NULL, IDC_ARROW));
             ReleaseCapture();
             bDragging=FALSE;
             SetDlgItemText(hDlg, stc2, "Nothing");
          }

          break;

       case WM_COMMAND:

          switch(wParam)
          {
             case pshHelp:

                DialogBox(ghInst,             // current instance
                          AboutBoxName,       // resource to use 
                          hDlg,               // parent handle   
                          AboutDlg);          // About() instance address
                break;

             default:
                break;
          }

          break;

       default:
          break;            
    }  

  return  (FALSE);
}

//****************************************************************************
// Function: ProcessOverMenu(LPSTR, int *)
//
// Purpose:  This routine handles the processing to determine what portion
//           of a menu we are over.  ie., Menu text or menu background
//
//
// Parameters: 
//   szAreaDesc == Buffer that will contain description of area we are over
//    *iSysArea == Identifier indicating type of area we are over
//          *pt == Point structure indicating location of cursor
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL ProcessOverMenu(LPSTR szAreaDesc, int FAR *iSysArea,
                                POINT FAR *pt)
{
   HDC   hDC;
   DWORD dwPixelColor, dwTextColor;

   hDC=GetDC(NULL);
   dwPixelColor=GetPixel(hDC, pt->x, pt->y);
   dwTextColor=GetSysColor(COLOR_MENUTEXT);
   ReleaseDC(NULL, hDC);

   if (dwTextColor==dwPixelColor)
   {
      LoadMyString(szAreaDesc, IDS_COLOR_MENUTEXT);
      *iSysArea=COLOR_MENUTEXT;
   }
   else
   {
      LoadMyString(szAreaDesc, IDS_COLOR_MENU);
      *iSysArea=COLOR_MENU;
   }
   return;
}

//****************************************************************************
// Function: ProcessOverCaption(LPSTR, int FAR *, POINT FAR *, HWND FAR *)
//
// Purpose:  This routine handles the processing to determine what portion
//           of a caption we are over.
//
//
// Parameters: 
//   szAreaDesc == Buffer that will contain description of area we are over
//    *iSysArea == Identifier indicating type of area we are over
//          *pt == Point structure indicating location of cursor
// *hCurrentWnd == Handle to window that the cursor is currently over
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL ProcessOverCaption(LPSTR szAreaDesc, int FAR *iSysArea,
                                   POINT FAR *pt, HWND FAR *hCurrentWnd)
{
   HDC   hDC;
   DWORD dwPixelColor, dwTextColor;

   hDC=GetDC(NULL);
   dwPixelColor=GetPixel(hDC, pt->x, pt->y);
   ReleaseDC(NULL, hDC);

   if (*hCurrentWnd==GetActiveWindow())
      {
         dwTextColor=GetSysColor(COLOR_CAPTIONTEXT);
         if (dwTextColor==dwPixelColor)
         {
            LoadMyString(szAreaDesc, IDS_COLOR_CAPTIONTEXT);
            *iSysArea=COLOR_CAPTIONTEXT;
         }
         else
         {
            LoadMyString(szAreaDesc, IDS_COLOR_ACTIVECAPTION);
            *iSysArea=COLOR_ACTIVECAPTION;
         }
      }
   else
      {
         dwTextColor=GetSysColor(COLOR_INACTIVECAPTIONTEXT);
         if (dwTextColor==dwPixelColor)
         {
            LoadMyString(szAreaDesc, IDS_COLOR_INACTIVECAPTIONTEXT);
            *iSysArea=COLOR_INACTIVECAPTIONTEXT;
         }
         else
         {
            LoadMyString(szAreaDesc, IDS_COLOR_INACTIVECAPTION);
            *iSysArea=COLOR_INACTIVECAPTION;
         }
      }
   return;
}

//****************************************************************************
// Function: ProcessOverButton(LPSTR, int FAR *, POINT FAR *, HWND FAR *)
//
// Purpose:  This routine handles the processing to determine what portion
//           of a button we are over.
//
//
// Parameters: 
//   szAreaDesc == Buffer that will contain description of area we are over
//    *iSysArea == Identifier indicating type of area we are over
//          *pt == Point structure indicating location of cursor
// *hCurrentWnd == Handle to window that the cursor is currently over
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL ProcessOverButton(LPSTR szAreaDesc, int FAR *iSysArea,
                                  POINT FAR *pt, HWND FAR *hCurrentWnd)
{
   RECT r;
   HDC  hDC;
   DWORD dwPixelColor, dwTextColor;

   GetWindowRect(*hCurrentWnd, &r);

//If we're over the left or top side, then set button highlight...

   if ( ((r.top+4) > pt->y) || ((r.left+4) > pt->x) )
      {
         LoadMyString(szAreaDesc, IDS_COLOR_BTNHIGHLIGHT);
         *iSysArea=COLOR_BTNHIGHLIGHT;
      }

//otherwise, check for button shadow...

   else
      if ( ((r.bottom-4) < pt->y) || ((r.right-4) < pt->x) )
         {
            LoadMyString(szAreaDesc, IDS_COLOR_BTNSHADOW);
            *iSysArea=COLOR_BTNSHADOW;
         }

//otherwise, we're over the button.  Check to see if we are over button text

   else
      {
         ScreenToClient(*hCurrentWnd, pt);
         hDC=GetDC(*hCurrentWnd);
         dwPixelColor=GetPixel(hDC, pt->x, pt->y);
         ReleaseDC(*hCurrentWnd, hDC);
         dwTextColor=GetSysColor(COLOR_BTNTEXT);

         if (dwPixelColor==dwTextColor)
            {
               LoadMyString(szAreaDesc, IDS_COLOR_BTNTEXT);
               *iSysArea=COLOR_BTNTEXT;
            }
         else
            {
               LoadMyString(szAreaDesc, IDS_COLOR_BTNFACE);
               *iSysArea=COLOR_BTNFACE;
            }
      }  
   return;
}


//****************************************************************************
// Function: ProcessOverStatic(LPSTR, int FAR *, POINT FAR *,
//                             HWND FAR *, HWND FAR *, BOOL FAR *)
//
// Purpose:  This routine handles the processing to determine if the static
//           window we are over contains any text.
//
//
// Parameters: 
//   szAreaDesc == Buffer that will contain description of area we are over
//    *iSysArea == Identifier indicating type of area we are over
//          *pt == Point structure indicating location of cursor
// *hCurrentWnd == Handle to window that the cursor is currently over
// *hWndSpecialIcon == Handle to SpecialIcon window contained in the dlg
//     *bUpdate == Boolean indicating whether or not to update the status
//                 window in the dialog
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
void FAR PASCAL ProcessOverStatic(LPSTR szAreaDesc, int FAR *iSysArea,
                                  POINT FAR *pt, HWND FAR *hCurrentWnd,
                                  HWND FAR *hWndSpecialIcon,
                                  BOOL FAR *bUpdate)
{
   RECT r;
   char szText[128];

   if (*hCurrentWnd == *hWndSpecialIcon)  //are we over the special icon?
   {
      GetWindowRect(*hWndSpecialIcon, &r);
      if (pt->y < r.top+10)                 //Active border area
      {
         LoadMyString(szAreaDesc, IDS_COLOR_ACTIVEBORDER);
         *iSysArea=COLOR_ACTIVEBORDER;
      }
      else
         if (pt->y < r.top+20)              //Disabled text area
         {
            LoadMyString(szAreaDesc, IDS_COLOR_GRAYTEXT);
            *iSysArea=COLOR_GRAYTEXT;
         }
      else                                 //Highlight/text area
         {
            if (pt->x < r.left+16)          //Highlight area
            {
               LoadMyString(szAreaDesc, IDS_COLOR_HIGHLIGHT);
               *iSysArea=COLOR_HIGHLIGHT;
            }
            else                           //Highlight text area
            {
               LoadMyString(szAreaDesc, IDS_COLOR_HIGHLIGHTTEXT);
               *iSysArea=COLOR_HIGHLIGHTTEXT;
            }
         }
   }  
   else
      if (SendMessage(*hCurrentWnd, WM_GETTEXT, (WORD)sizeof(szText),
                      (LONG)(LPSTR)szText))
      {
         LoadMyString(szAreaDesc, IDS_COLOR_WINDOWTEXT);
         *iSysArea=COLOR_WINDOWTEXT;
      }
      else  //were over some random static window, so don't update
      {
         LoadMyString(szAreaDesc, IDS_NOTHING);
         *bUpdate=FALSE;
      }
   return;
}

//****************************************************************************
// Function: GetUpdateArea(HWND, BOOL FAR *, LONG, LPSTR, LPSTR, LONG,
//                         HWND)    
//
// Purpose:  This routine is passed, among other things, the hit test  
//           area that the cursor is currently over.  Given this info, 
//           we probe further to determine the exact system area that  
//           will be updated if the user were to drop the color.  For  
//           example, lHitTestArea may be something like HT_MENU.  This
//           routine will determine if the cursor is over menu text or 
//           just a random menu area.                                  
//
// Parameters: 
// *hCurrentWnd == Handle to window that the cursor is currently over
//     *bUpdate == Boolean indicating whether or not to update the status
//                 window in the dialog
// lHitTestArea == Long defining the area the cursor is currently over
//  szClassName == Class name of the window the cursor is currently over
//   szAreaDesc == Buffer that will contain description of area we are over
//       lParam == Point of the cursor
// *hWndSpecialIcon == Handle to SpecialIcon window contained in the dlg
//
// Returns : Nothing
//
// Comments:
//
// History:  Date       Author        Reason
//           2/19/92    gregk         Created
//****************************************************************************
int FAR PASCAL GetUpdateArea(HWND hCurrentWnd, BOOL FAR *bUpdate, LONG lHitTestArea,
                             LPSTR szClassName, LPSTR szAreaDesc, LONG lParam,
                             HWND hWndSpecialIcon)
{
   int   iSysArea=0;
   POINT pt;

   pt=MAKEPOINT(lParam);

   if (lHitTestArea!=HTCLIENT)  //Check system area's first
      {
         switch (lHitTestArea)
         {
            case HTMENU:
               ProcessOverMenu(szAreaDesc, &iSysArea, &pt);
               break;

            case HTCAPTION:
               ProcessOverCaption(szAreaDesc, &iSysArea, &pt, &hCurrentWnd);
               break;

            case HTBORDER:
               LoadMyString(szAreaDesc, IDS_COLOR_WINDOWFRAME);
               iSysArea=COLOR_WINDOWFRAME;
               break;

            case HTBOTTOMLEFT:  
            case HTBOTTOMRIGHT:
            case HTBOTTOM:
            case HTTOPLEFT:
            case HTTOPRIGHT:
            case HTTOP:
            case HTLEFT:
            case HTRIGHT:
    
               LoadMyString(szAreaDesc, IDS_COLOR_INACTIVEBORDER);
               iSysArea=COLOR_INACTIVEBORDER;
               break;  
           
            case HTHSCROLL:
            case HTVSCROLL:
               LoadMyString(szAreaDesc, IDS_COLOR_SCROLLBAR);
               iSysArea=COLOR_SCROLLBAR;
               break;

            case HTTRANSPARENT:
            case HTERROR:
            case HTNOWHERE:
            case HTSIZE:
            case HTREDUCE:
            case HTZOOM:
            default:
               lstrcpy(szAreaDesc, "Nothing");
               iSysArea=-1;
               *bUpdate=FALSE;
               break;
         }
      }
   else  //were in someone elses client area, probe a little further
      {
         if (!lstrcmp(szClassName, "Button"))  //there equal
            {
               ProcessOverButton(szAreaDesc, &iSysArea, &pt, &hCurrentWnd);
            }  
         else
            if (!lstrcmp(szClassName, "Static"))    //there equal
            {
               ProcessOverStatic(szAreaDesc, &iSysArea, &pt, &hCurrentWnd, 
                                 &hWndSpecialIcon, bUpdate);
            }
         else
            if (!lstrcmp(szClassName, "#32770"))  //Dialog class
            {
               LoadMyString(szAreaDesc, IDS_COLOR_WINDOW);
               iSysArea=COLOR_WINDOW;
            }
         else
            if (!lstrcmp(szClassName, "#32769"))  //Desktop window
            {
               LoadMyString(szAreaDesc, IDS_COLOR_BACKGROUND);
               iSysArea=COLOR_BACKGROUND;
            }
         else
            if (!lstrcmp(szClassName, "MDIClient"))  //MDI client window
            {
               LoadMyString(szAreaDesc, IDS_COLOR_APPWORKSPACE);
               iSysArea=COLOR_APPWORKSPACE;
            }
         else
            {
               LoadMyString(szAreaDesc, IDS_NOTHING);
               iSysArea=-1;
               *bUpdate=FALSE;
            }
      }  

   return(iSysArea);
}

//****************************************************************************
// Function: AboutDlg
//
// Purpose: Called by DoCommands() when want About dialog box.
//
// Parameters:
//    hDlg    == Handle to _this_ window.
//    message == Message to process.
//    wParam  == WORD parameter -- depends on message
//    lParam  == LONG parameter -- depends on message
//
// Returns: Depends on message.
//
// Comments:
//
// History:  Date       Author        Reason
//           1/27/92                  Created
//****************************************************************************

BOOL FAR PASCAL AboutDlg (HWND hDlg,
                          unsigned message,
                          WORD wParam,
                          LONG lParam)
{
   switch (message)
   {
      case WM_INITDIALOG:
         return (TRUE);

      case WM_COMMAND:
         if ((wParam == IDOK) ||       // "OK" box selected?        
             (wParam == IDCANCEL))     // System menu close command?
         {
            EndDialog(hDlg, TRUE);     // Exits the dialog box 
            return (TRUE);
         }
         break;
   }

   return (FALSE); // Didn't process a message
}
