#ifndef CONTROLPAD_H
#define CONTROLPAD_H

#include "exec/types.h"

#define ControlPadName     "controlpad.library"

// controlpad bits
#define CPB_UP       0x00              // 1 = pressed
#define CPB_DOWN     0x01
#define CPB_LEFT     0x02
#define CPB_RIGHT    0x03
#define CPB_A        0x04
#define CPB_B        0x05
#define CPB_C        0x06
#define CPB_START    0x07
#define CPB_X        0x08              // (future)
#define CPB_Y        0x09              // (future)
#define CPB_Z        0x0A              // (future)
#define CPB_MODE     0x0B              // (future)
#define CPB_3BUTTON  0x0C              // Controller has 3 buttons
#define CPB_6BUTTON  0x0D              // Controller has 6 buttons (future)
#define CPB_INUSE    0x0E              // Controller allocated
#define CPB_ERROR    0x0F              // Controller Read Error (up+down or left+right)

//controlpad flags
#define CPF_UP       (1L << CPB_UP     )
#define CPF_DOWN     (1L << CPB_DOWN   )
#define CPF_LEFT     (1L << CPB_LEFT   )
#define CPF_RIGHT    (1L << CPB_RIGHT  )
#define CPF_A        (1L << CPB_A      )
#define CPF_B        (1L << CPB_B      )
#define CPF_C        (1L << CPB_C      )
#define CPF_START    (1L << CPB_START  )
#define CPF_X        (1L << CPB_X      )
#define CPF_Y        (1L << CPB_Y      )
#define CPF_Z        (1L << CPB_Z      )
#define CPF_MODE     (1L << CPB_MODE   )
#define CPF_3BUTTON  (1L << CPB_3BUTTON)
#define CPF_6BUTTON  (1L << CPB_6BUTTON)
#define CPF_INUSE    (1L << CPB_INUSE  )
#define CPF_ERROR    (1L << CPB_ERROR  )

// unit flags
#define CPU_NONE        0x00
#define CPU_MOUSEPORT   0x01
#define CPU_JOYPORT     0x02
#define CPU_BOTHPORTS   (CPU_MOUSEPORT|CPU_JOYPORT)

typedef void *CPHANDLE;

extern struct Library *ControlPadBase;

CPHANDLE __saveds __asm cpAlloc   (register __d0 UBYTE unit);
CPHANDLE __saveds __asm cpReAlloc (register __a0 CPHANDLE cph, register __d0 UBYTE unit);
CPHANDLE __saveds __asm cpLock    (register __a0 CPHANDLE cph, register __d0 UBYTE unit);
UBYTE    __saveds __asm cpUnLock  (register __a0 CPHANDLE cph, register __d0 UBYTE unit);
void     __saveds __asm cpFree    (register __a0 CPHANDLE cph);
UWORD    __saveds __asm cpGet     (register __a0 CPHANDLE cph, register __d0 UBYTE unit);
UBYTE    __saveds __asm cpTest    (void);
CPHANDLE __saveds __asm cpDisable (void);
void     __saveds __asm cpEnable  (register __a0 CPHANDLE cph);
void     __saveds __asm cpShowLogo(register __d0 int time);
UBYTE    __saveds __asm cpUnit    (register __a0 CPHANDLE cph);

/* "ControlPad.library"*/
#pragma libcall ControlPadBase cpAlloc 1e 001
#pragma libcall ControlPadBase cpReAlloc 24 0802
#pragma libcall ControlPadBase cpLock 2a 0802
#pragma libcall ControlPadBase cpUnLock 30 0802
#pragma libcall ControlPadBase cpFree 36 801
#pragma libcall ControlPadBase cpGet 3c 0802
#pragma libcall ControlPadBase cpTest 42 0
/*pragma libcall ControlPadBase cpDisable 48 0 */  //private
/*pragma libcall ControlPadBase cpEnable 4e 801 */ //private
#pragma libcall ControlPadBase cpShowLogo 54 001
#pragma libcall ControlPadBase cpUnit 5a 801

#endif // CONTROLPAD_H
