/*
 * cradle.c - Turbo C version of Jack Crenshaw's compiler cradle.
 *
 */
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <string.h>
#include <stdarg.h>

#define TAB	9
#define IsAlpha(c) isalpha ((c))
#define IsDigit(c) isdigit ((c))
#define UpCase(c)  toupper ((c))
#define IsAddop(c) (c) == '+' || (c) == '-'
#define IsMulop(c) (c) == '*' || (c) == '/'
#define IsAlNum(c) isalnum ((c))
#define IsWhite(c) (c) == ' ' || (c) == TAB

char Look;	/* lookahead character */

/*
 * Read New Character From Input Stream
 */
void GetChar (void) {
    Look = getchar ();
}

/*
 * Report an Error
 */
void Error (char *fmt, ...) {
    va_list (args);

    printf ("\n\007Error: ");
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
    printf ("\n");
}

/*
 * Report Error and Halt
 */
void Abort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    Error (fmt, args);
    va_end (args);
    exit (1);
}

/*
 * Report What Was Expected
 */
void Expected (char *fmt, ...) {
    va_list args;
    char f[81];

    va_start (args, fmt);
    strcpy (f, fmt);
    Abort (strcat (f, " Expected"), args);
    va_end (args);
}

/*
 * Match a Specific Input Character
 */
void Match (char x) {
    char s[4];

    if (Look == x)
        GetChar ();
    else {
        sprintf (s, "'%c'", x);
        Expected (s);
    }
}

/*
 * skip over leading white space
 */
void SkipWhite (void) {
    while (IsWhite (Look))
	GetChar ();
}

/*
 * Get an Identifier
 */
char GetName (void) {
    char c;

    if (! IsAlpha (Look))
        Expected ("Name");
    c = UpCase (Look);
    GetChar ();
    return (c);
}

/*
 * Get a Number
 */
char GetNum (void) {
    char c;
    if (! IsDigit (Look))
        Expected ("Integer");
    c = Look;
    GetChar ();
    return (c);
}

/*
 * Output a String with Tab
 */
void Emit (char *fmt, ...) {
    va_list args;

    printf ("%c", TAB);
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
}

/*
 * Initialize
 */
void Init (void) {
    GetChar ();
}

/*
 * Main Program
 */
void main (void)
{
    Init ();
}
