@echo off
cls

set dst_path=\compceph

rem     command-line parameter testing

rem     did the user enter two drive letters?
rem             if so we will use them, else we must abort
if "%1p" == "p" goto USAGE
if "%2p" == "p" goto USAGE
set src_drv=%1
set dst_drv=%2

rem     if the two drive letters are the same, we must abort
if %dst_drv% == %src_drv% goto ERROR_1

rem     if the user is trying to install to a floppy drive, we must abort
if "%2" == "a:" goto ERROR_2
if "%2" == "b:" goto ERROR_2
if "%2" == "A:" goto ERROR_2
if "%2" == "B:" goto ERROR_2

rem     if a drive letter is missing a colon, we must abort
if "%1" == "a" goto ERROR_4
if "%1" == "b" goto ERROR_4
if "%1" == "A" goto ERROR_4
if "%1" == "B" goto ERROR_4
if "%2" == "c" goto ERROR_4
if "%2" == "C" goto ERROR_4
if "%2" == "d" goto ERROR_4
if "%2" == "D" goto ERROR_4
if "%2" == "e" goto ERROR_4
if "%2" == "E" goto ERROR_4
if "%2" == "f" goto ERROR_4
if "%2" == "F" goto ERROR_4

rem     if the source drive letter is wrong, we must abort
if not exist %1\install.bat goto USAGE

rem     display credits
echo    ͻ
echo                                                                            
echo        Compu-Ceph (tm) version 1.2 and demonstration                       
echo                                                                            
echo        Copyright 1987-1994 ALGORITHM, Inc. and Christopher D. Watkins      
echo                                                                            
echo        ALL RIGHTS RESERVED                                                 
echo                                                                            
echo        Cephalometric Analysis Program with Image Processing                
echo                                                                            
echo        Marketed by Dualtek, Inc.                                           
echo                                                                            
echo    ͼ
pause

cls
	echo Ŀ
	echo  INSTALLATION PATHS:                                  
	echo 
	echo           Source drive is %1
	echo      Destination drive is %2
	echo  Destination directory is %2%dst_path%
	echo Ŀ
	echo  Press any key, if you are ready to continue with the 
	echo  installation, otherwise press Ctrl-Break to cancel   
	echo 
pause

	echo Ŀ
	echo  Installing... 
	echo 
%dst_drv%
cd \

rem     make the destination directory, and if there is a problem, we must abort
md %dst_path%
if not exist %dst_drv%%dst_path%\prn goto ERROR_3

rem     if we could make the main directory, we assume that we can make the remainder
md %dst_path%\7114

rem     if install exists where we think it does, we can continue, else we must abort.
if not exist %src_drv%\install.bat goto ERROR_5

rem     copy over all of the files into their directories
cd %dst_path%
copy %src_drv%\lha.exe %dst_path%
copy %src_drv%\lharc.lzh %dst_path%
copy %src_drv%\compceph.lzh %dst_path%
copy %src_drv%\7114.lzh %dst_path%\7114

cls
rem     expanding compressed files.
cd %dst_path%
%dst_path%\lha x compceph
cd %dst_path%\7114
%dst_path%\lha x 7114

cd %dst_path%
	echo Ŀ
	echo  Installation complete.  Running Demonstration.  
	echo 

win compceph

goto END


:ERROR_1
	echo Ŀ
	echo  Source and Destination drives are the same. 
	echo 
goto END


:ERROR_2
	echo Ŀ
	echo  Cannot install to drives a: or b: 
	echo 
goto END


:ERROR_3
%src_drv%
	echo Ŀ
	echo  Could not create the destination directory. 
	echo 
goto END


:ERROR_4
	echo Ŀ
	echo  Invalid drive specifier.  Be sure to include the colon. 
	echo 
goto END


:ERROR_5
	echo Ŀ
	echo  There seems to be an error with the        
	echo  installation Source drive.  Please correct 
	echo  the problem and then run install again     
	echo 
goto END


:USAGE
	echo Ŀ
	echo            Batch file for installation of Compu-Ceph            
	echo Ĵ
	echo        USAGE:   install source_drive destination_drive          
	echo        EXAMPLE: install a: c:                                   
	echo Ĵ
	echo  Copyright 1987-1994 Algorithm, Inc. and Christopher D. Watkins 
	echo 
goto END


:END
