// ************************************************************************* //
// Begin COMMON mod, functions that are common amoung many Asylum releases   //
// If you get a duplicate function error, then you have it installed twice   //
// remove your oldest duplicated functions.                                  //
// ************************************************************************* //
// These are the non-overlayed functions to help out on speed

#include "vars.h"
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <conio.h>



// Will search the batch queue for the file specified by fn and return where it
// is in the batch queue
int find_batch_queue(char *fn)
{
  int i;

  for (i=0; i<numbatch; i++) {
    if (strcmp(fn,batch[i].filename)==0)
//      if (batch[i].sending)
        return(i);
  }

  return(-1);
}


// Removes a file off the batch queue specified by fn
void remove_batch(char *fn)
{
  int x;
  
  x = find_batch_queue(fn);
  if(x > -1)
    delbatch(x);
}

// Clears the screen
void CLS(void)
{
  if (okansi()) 
  {
    outchr(12);
    outstr("\x1b[2J");
  } 
  else 
  {  
    outchr(12);
  }
}

/* positions cursor at y=row,x=column then erase to end of line */
void CEOL_XY( unsigned x, unsigned y )
{
  char s[20];
  sprintf(s,"\033[%u;%uH\033[K",(y),(x));
  outstr(s);
}


/* cursor up or down x-number of lines */
void CURSORUP( int x )
{
  char s[81];
  sprintf(s, "\033[%uA",(x));
  outstr(s);
}
void CURSORDOWN( int x )
{
  char s[81];
  sprintf(s, "\033[%uB",(x));
  outstr(s);
}

/* cursor forward (right) or backward (left) y-number of spaces */
void CURSORRIGHT(int x)
{
  char s[81];
  sprintf(s, "\033[%uC",(x));
  outstr(s);
}
void CURSORLEFT(int x)
{
  char s[81];
  sprintf(s, "\033[%uD",(x));
  outstr(s);
}


/* positions cursor at y=row,x=col and print char z (using ASCII code) */
void CHAR_XY( int x, int y, int z )
{
  char s[81];
  sprintf(s,"\033[%u;%uH%c",(y),(x),(z));
  outstr(s);
}

/* on row y, center (and outstr) the string (in double quotes) */
void XCTRPRINTF(int y, char *str )
{
  char s[200];
  sprintf(s,"\033[%u;%uH%s",(y),((80-(strlen(str)-1))/2),str);
  outstr(s);
}



/* at position y,x outstr the string str (in double quotes) */
void PRINTF_XY( int x, int y, char *str )
{
  char s[200];
  sprintf(s,"\033[%u;%uH%s",(y),(x),str);
  outstr(s);
}

void BEEP(void)
{
  outstr("\007");
}

// Clears to end of line
void EOL(void)
{
  outstr("\033[K");
}

void SAVCURS(void)
{
  outstr("\033[s");
}

void RECALLCURS(void)
{
  outstr("\033[u");
}
// Used for making all strings in a list the same length
char *pad_string(char *string, int length)
{
  int x;

  // Turncate string if needed
  string[length]=0;
  x=strlen(string);

  while(x<length && !hangup)
  {
    string[x]=' ';
    ++x;
  }
  
  string[x]=0;
  return(string);
}


// Like pad_string, but lets you specify what the pad character is
char *pad_string_bg(char *string, int length, int bg)
{
  int x;

  // Turncate string if needed
  string[length]=0;
  x=strlen(string);

  while(x<length && !hangup)
  {
    string[x]=bg;
    ++x;
  }
  
  string[x]=0;
  return(string);
}

// Just like pad_string_bg, but lets you justify it left, right, or center
char *justify_string(char *string, int length, int bg, int type)
{
  int x;

  if(type==JUSTIFY_LEFT) // Left Justify
  {

    // Turncate string if needed
    string[length]=0;
    x=strlen(string);

    while(x<length && !hangup)
    {
      string[x]=bg;
      ++x;
    }

    string[x]=0;
    return(string);
  }
  else if(type==JUSTIFY_RIGHT) // Right Justify
  {
    int pos=0;

    string[length]=0;
    x=strlen(string);

    if(x>=length)
      return(string);

    memmove(string+length-x, string, x);

    while(pos<length-x)
    {
      string[pos]=bg;
      ++pos;
    }

    string[length]=0;
    return(string);
  }
  else if(type==JUSTIFY_CENTER) // Center Justify
  {
    int pos=0;

    string[length]=0;
    x=strlen(string);

    if(x>=length)
      return(string);

    memmove(string+((length-x)/2), string, x);

    while(pos<((length-x)/2))
    {
      string[pos]=bg;
      ++pos;
    }

    pos=x+((length-x)/2);
    while(pos<length)
    {
      string[pos]=bg;
      ++pos;
    }

    string[length]=0;
    return(string);
  }
  else
  {
    sysoplog("Illegal type called to function Justify_String");
    return(string);
  }
}
// This will count how many items you have in a list, but the list is defined
// as a regualr char string, therefore you must define how wide and how many
// coloumns you have.  The list must end in a 0 for this function to find the
// end of it...
int pd_amount_in_list(char *list, int rows, int cols)
{
  int x=0;
  while(list[x*(cols)] && !hangup)
  {
    ++x;
    if(x>=rows)
      return(rows);
  }
  return(x);
}

// This will find the 'longest' string in a list, but the list is defined
// as a regular char string, therefore you must define how wide the list is
// and how many are in the list
int largest_in_list(char *list, int rows, int cols)
{
  int x=0,y=0,z=0;

  while(list[x*(cols)] && x<rows && !hangup)
  {
    y=strlen(list+(x*cols));
    if(y>z)
      z=y;
    ++x;
  }
  return(z);
}

// This will find the 'longest' string in a list of strings
int widest_in_list(char *list[], int amount)
{
  int x=0,y=0,z=0;

  while(x<amount && !hangup)
  {
    y=wwiv_strlen(list[x]);
    if(y>z)
      z=y;
    ++x;
  }
  return(z);
}

// This will return the lenght of the string that will show up on screen
// it wont count wwiv color codes
int wwiv_strlen(char *s)
{
  int x=0;
  int y=0;

  while(s[x] && !hangup)
  {
    if(s[x]=='')
    {
      ++x; // get past color
    }
    else
      ++y;
    ++x;
  }
  return(y);
}

// This will count a list, the list must end in 0 for the end to be found
int count_list(char *list[])
{
  int x = 0;
  while(list[x] && !hangup)
    ++x;
  return(x);
}

// Search list for string in 'search', amount_in_list defines the size of list
int search_list(char **list, char *search, int amount_in_list)
{
  int x=0;
  
  while(x<amount_in_list)
  {
    if(!strcmp(list[x], search))
      return(x);
    ++x;
  }
  return(-1);
}

// Search list for string in 'search', amount_in_list defines the size of list
// Ignore case
int search_list_i(char **list, char *search, int amount_in_list)
{
  int x=0;
  
  while(x<amount_in_list)
  {
    if(!stricmp(list[x], search))
      return(x);
    ++x;
  }
  return(-1);
}
void outstr_color(char *s)
{
  int i=0;

  checkhangup();
  if (!hangup)
    while (s[i])
      outchr_color(s[i++]);
}

void outchr_color(char c)
{
  int i, i1, col, attrib;
  static char pipe_color[5];
  char color[50];


  if(change_color==3)
  {
    change_color=0;

    pipe_color[1]=c;
    pipe_color[2]=0;


    if(isdigit(pipe_color[0]) || pipe_color[0]==' ')
    {
      char num[5];
      if(isdigit(pipe_color[1]) || (pipe_color[1]==' ' && pipe_color[0]!=' '))
      {
        if(pipe_color[0]!='b' || pipe_color[0]=='B')
        {
          col=atoi(pipe_color);

          if(col<16)
          {
            attrib=col;
            buildfor(attrib, color);
          }
          else // For background colors 16-23)
          {
            col-=16;
            attrib=col;
            buildback(attrib, color);
          }

          outstr(color);
          return;
        }
        else if(pipe_color[0]=='b' || pipe_color[0]=='B')
        {
          num[0]=pipe_color[1];
          num[1]=0;

          col=(atoi(num));
          attrib=col;
          buildback(attrib, color);
          outstr(color);
          return;
        }
        else
        {
          outchr('|');
          outchr(pipe_color[0]);
          outchr(pipe_color[1]);
          return;
        }
      }
      else
      {
        outchr('|');
        outchr(pipe_color[0]);
        outchr(pipe_color[1]);
        return;
      }
    }
    else
    {
      outchr('|');
      outchr(pipe_color[0]);
      outchr(pipe_color[1]);
      return;
    }
  }


  if(change_color==2)
  {
    pipe_color[0]=c;
    ++change_color;
    return;
  }

  if (change_color==1)
  {
    change_color = 0;
    if ((c >= '0') && (c <= '9'))
      ansic(c - '0');
    return;
  }

  if (c == 3)
  {
    change_color = 1;
    return;
  }

  if(c=='|')
  {
    change_color = 2;
    return;
  }

  if ((c == 10) && endofline[0]) {
    if (!in_extern)
      outstr(endofline);
    endofline[0] = 0;
  }

  if (global_handle) {
    if (echo)
      global_char(c);
  }

#ifndef OPT_NEW_CHATSOUND
  if (chatcall && !x_only && !(syscfg.sysconfig & sysconfig_no_beep))
    setbeep(1);
#endif

  if (outcom && !x_only && (c != 9)) {
    if (!(!okansi() && (ansiptr || c==27)))
      outcomch(echo ? c : 'X');
  }
  if (ansiptr) {
    ansistr[ansiptr++] = c;
    ansistr[ansiptr]   = 0;
    if ((((c < '0') || (c > '9')) && (c!='[') && (c!=';')) ||
        (ansistr[1] != '[') || (ansiptr>75))
      execute_ansi();
  } else if (c == 27) {
    ansistr[0] = 27;
    ansiptr = 1;
    ansistr[ansiptr]=0;
  } else {
    if (c == 9) {
      i1 = WHEREX();
      for (i = i1; i< (((i1 / 8) + 1) * 8); i++)
        outchr(32);
    } else if (echo || lecho) {
      out1ch(c);
      if (c == 10) {
        ++lines_listed;

        if (lines_listed >= screenlinest - 3)
        {
          if(!in_extern)
          {
            if ((tagging) && !(thisuser.sysstatus & sysstatus_no_tag))
            {
              if(num_listed!=0)
                tag_files();
              lines_listed = 0;
            }
          }
        }
        if (lines_listed >= screenlinest - 1)
        {
          if (sysstatus_pause_on_page & thisuser.sysstatus)
            if (!x_only)
              pausescr();
          lines_listed = 0;
        }
      }
    } else
      out1ch('X');
  }
  if (chatcall)
    setbeep(0);
}




// Calls the above colorize_text to print out '|colors'
// This call and sprintf_color are only meant for formats that when expanded
// Will be less that 512 characters, this is fine for most cases, but not
// Something like an extended description
void npr_color(char *fmt, ...)
{
  va_list ap;
  char s[512];

  va_start(ap, fmt);
  vsprintf(s, fmt, ap);
  va_end(ap);

  outstr_color(s);

}
// This will 'strip' all white spaces from the front and end of a string
// Will turn '     This is me   ' -=> 'This is me'
// 4.23 has a trimstr which will 'trim' the left part of the string
char * strip_string(char *string)
{
  int x=0, y;
  while(isspace(string[x]) && string[x] && !hangup)
    ++x;
    
  y=strlen(string);
  memmove(string, string+x, y-x+1);
  string[y-x+1]=0;
  
  y=strlen(string);
  --y;
  
  while(isspace(string[y]) && y >= 0 && !hangup)
    --y;
    
  string[y+1]=0;
  
  
  return(string);
}

// Fixes one of wwiv's 'aligned' files ie... "FILE    .ARJ" -> "FILE.ARJ"
char *unalign(char *filename)
{
  char *temp, *exttemp;

  temp=strstr(filename, " ");
  if(temp)
  {
    temp[0]=0;
    ++temp;

    exttemp=strstr(temp, ".");
    if(exttemp)
      strcat(filename, exttemp);
  }
  return(filename);
}

// Build forground color for pipe code colors
void buildfor(unsigned char attr, char *s)
{
  int bold=0, fore=0;
  int curfore=0;
  int needsc=0;
  char *semicolon=";";

  if(curfore!=curfore) // Until I get this part working
    curfore=curfore;

  s[0]=0;


  fore=attr;
  if(fore > 7)
  {
    bold=1;
    fore-=8;
  }
  curfore=curatr & 15;


  if(okansi() /* && curfore!=attr */)
  {

    if(curfore > 7)
      curfore-=8;

    switch(fore)
    {
      case 1:
        fore=4;
        break;
      case 3:
        fore=6;
        break;
      case 4:
        fore=1;
        break;
      case 6:
        fore=3;
        break;
    }


    if(okansi())
    {
      strcpy(s, "[");

      if(bold)
      {
        if(needsc)
          strcat(s, semicolon);

        needsc=1;
        strcat(s, "1");
      }
      else
      {
        if(needsc)
          strcat(s, semicolon);

        needsc=1;
        strcat(s, "0");
      }

/*      if(curfore != attr) */
      {
        char color[10];

        if(needsc)
          strcat(s, semicolon);

        needsc=1;

        sprintf(color, "3%d", fore);
        strcat(s, color);
      }

      if(needsc)
        strcat(s, "m");
    }

    curatr&=240;
    curatr+=fore;
  }
}

// Build pipe code back ground color
void buildback(unsigned char attr, char *s)
{
  int back=0;
  int curback=0;
  int needsc=0;

  char *semicolon=";";


  back=attr;

  switch(back)
  {
    case 1:
      back=4;
      break;
    case 3:
      back=6;
      break;
    case 4:
      back=1;
      break;
    case 6:
      back=3;
      break;
  }



  curback=curatr & 112;

  if(curback!=curback) // Until I get it working
    curback=curback;

  s[0]=0;

  if(okansi() /* && back != curback */)
  {
    char color[10];

    strcpy(s, "[");


    if(needsc)
      strcat(s, semicolon);

    needsc=1;

    sprintf(color, "4%d", back);
    strcat(s, color);


    if(needsc)
      strcat(s, "m");
  }

  curatr&=143;  // Veldar fix
  curatr+=(back<<4);
}
void repeat_char(unsigned char x, int amount)
{
  int cur=0;

  while(cur<amount && !hangup)
  {
    outchr(x);
    ++cur;
  }
}
char *strstr_nocase(char *s1, char *s2)
{
  int len=strlen(s2), pos=0;

  while(s1[pos])
  {
    if(strncmpi(s1+pos, s2, len)==0)
      return(s1+pos);

    ++pos;
  }
  return NULL;
}

void statusbar(statusbarrec *sb)
{
  float pos;
  int maj_pos, min_pos;
  int total_fractions=(sb->width-1)*sb->amount_per_square;


  if(sb->current_item==0) // Initialize
  {
    int x=0;

    ansic(sb->surround_color);
    outchr(sb->side_char1);

    setc(sb->box_color);
    while(x<sb->width)
    {
      outchr(sb->empty_space);
      ++x;
    }

    ansic(sb->surround_color);
    outchr(sb->side_char2);

    if(okansi())
      CURSORLEFT(sb->width);
    else
    {
      x=0;
      while(x<sb->width+1)
      {
        outchr('\b');
        ++x;
      }
    }

    sb->last_maj_pos=0;
    sb->last_min_pos=0;

    return;
  }

  pos=((float)sb->current_item/sb->total_items);
  pos=pos * total_fractions;

  maj_pos=pos/sb->amount_per_square;
  min_pos=pos-(maj_pos*sb->amount_per_square);

  if(min_pos==0)
    min_pos=sb->amount_per_square-1;
  else
    --min_pos;

  if(maj_pos==sb->last_maj_pos)
  {
    if(min_pos==sb->last_min_pos)
      return;

    setc(sb->box_color);
    outchr('\b');
    outchr(sb->square_list[min_pos]);

    sb->last_min_pos=min_pos;

    return;
  }

  setc(sb->box_color);
  outchr('\b');
  outchr(sb->square_list[sb->amount_per_square-1]);
  sb->last_min_pos=min_pos;

  ++sb->last_maj_pos;
  while(sb->last_maj_pos < maj_pos)
  {
    ++sb->last_maj_pos;
    outchr(sb->square_list[sb->amount_per_square-1]);
  }
  outchr(sb->square_list[min_pos]);

  sb->last_maj_pos=maj_pos;

  return;
}

void strip_heart_colors(char *text)
{
  int pos=0;
  int len=strlen(text);

  while(pos<len && text[pos] != 26 && !hangup)
  {
    if(text[pos]==3)
    {
      memmove(text+pos, text+pos+2, len-pos);
      --len;
      --len;
    }
    else
      ++pos;
  }
}

