/* *********************************************************************** */
/* Asylum COMMON - by Michael Deweese Copyright 1994                       */
/*                                                                         */
/* You may use this code in WWIV as installed under the COMMON.MOD file    */
/* You may not use this code in your own programs without the consent of   */
/* Michael Deweese.                                                        */
/* You can call these functions from your own WWIV modifications, but may  */
/* not rip these out and include them in your mod.  In other words, to     */
/* access these functions, the user using your modification must have      */
/* mod installed                                                           */
/*                                                                         */
/* Again, feel free to make mods requiring COMMON to be installed, just    */
/* as I do, but I really don't want these function ripped apart and        */
/* and included in individual mods, and it would make it impossible for me */
/* to maintain them.                                                       */




  ModTitle: Asylum Common v2.1 for 4.23              Last Update July 6, 1994
  Mods that use this mod will be referred to as a 'Common Mod'

  Difficulty: Typical Asylum Mod...that is, a piece of cake.

  Files affected: MAKEFILE, VARDEC.H, VARS.H

  A tool box of functions that the Asylum group (and any one else who wants to)
  use in the modifications for WWIV.

  Current mods requiring this mod: Pulldown Menus, Listfile Plus Q/Nscan
                                   Config Plus and our QWK modification

  BY: Asylum Group-  Zu Digital, 1@8421, and Sam, 1@4051
  Credits: No one



Fixes and updates:
  2.1 added high level ini

  Added giveup_timeslice in get_kb_event

  Fixed the fact that the insert and delete were not recognized by my Telemate
  on the remote side.

  Delete would show a little house (ascii 127) and insert just didn't do
  anything.



+ Add
- Subtract
* Change
= Existing
@# See number

    
  I will not be responsible for any problems that arise because of this or any
  other of my mods.  If you have something to lose, make a way to recover it.
  If you don't know how to do this properly, then don't install this.
  If you can't install this mod without any problems, then don't try.
  
  Now,... this mod works as far as I have tested, as has many other people.
  

***Note  (Pertains to people upgrading from an older version of common)
  I removed the register_common mod stuff, the stuff that goes at the begining
  of bbs.c in main(), you will need to remove all that code that pertains to
  it once this is installed to get it to compile.  Reason is, it never
  developed into anything useful, and just took away precious memory, I modified
  it slightly so that when you 'show_common_mods', it will just print a file,
  forget which, but that way, you can just add the mods you put in, into some
  .MSG or ANS and it will be printed out.


***** If you are upgrading from version 1.anything or do the following to
***** upgrade

Step 4A
     4B
     4E

     Copy COMMON.C AND COMMON2.C, COMMON.H into your dir

     Rebuild your FCNS.H file (MAKE FCNS or get declarations from step 5)

     Done!

***** End of upgrade



Step A)
  Place the included files in your compling directory, should include COMMON.C,
  COMMON2.C and COMMON.H.
  

Step 1) VARDEC.H
  Going to make a way to turn off certain Asylum mods, and don't want to change
  your userrec for every mod.

  This will take only 8 bits from your user rec (1 BYTE).

  NOTE: If you already modified your userrec at this same spot, put this before
  your previous mod so that all memory will point to the correct spot.  And that
  goes for future mods at this spot, if you add another variable, add it before
  the declarations.

=     char
=       res_float[32];  /* reserved for real values */
=
=     char
/*********  Be sure to decrement this by 1, ie 100 to 99
*       res_gp[99];    /* reserved for whatever */
=

+     unsigned char use_internal_tag : 1;
+     unsigned char use_menusys : 1;
+
+     unsigned char use_three : 1;
+     unsigned char use_four : 1;
+     unsigned char use_five : 1;
+     unsigned char use_six : 1;
+     unsigned char use_seven : 1;
+     unsigned char use_eight : 1;

} userrec;


  
  
Step 2) VARS.H
  Have vars.h include common.h into your bbs as well as a simple define
  
= #include <dos.h>
= #include <alloc.h>
= #include <time.h>
                       /***********  Read !!!!!!!!! ***********/
+ #include "common.h"  /*********** important, make sure this is before fcns.h ***********/
= #include "fcns.h"    /*********** Did you read ^^^^^??????????? *********/




Step 3) BBS.C
  Put in a check to give us an error if we mess up on the userrec

= void main(int argc, char *argv[])
= {
=   char s[81],ch,frc[81], rf[30],*ss;
=   int i,i1,num_min=0;
=   unsigned int ui=0, us=0;
=   double dt;
=   unsigned short c_s,c_o;
=   int this_usernum=0;
=
+ #if sizeof(userrec) != 1024
+ #error Userrec is not 1024
+ #endif


Step 4)
  MAKEFILE.  This is only for the Borland make, if you don't use it, then you
  will have to modify your makefile yourself, being that I don't use it, and
  do not know the syntax.
  
  A) Search for BBS_NRM and add our non-overlaid part of common

= BBS_NRM = \
=        msgbase.obj  msgbase1.obj share.obj    strings.obj  \
*        utility.obj  xfer.obj     common2.obj
                                  ^^^^^^^^^^^ add this

  B) Down a little add our other part

= BBS_O_NRM = \
=        $(OBJ)\msgbase1.obj $(OBJ)\share.obj    $(OBJ)\strings.obj  \
*        $(OBJ)\utility.obj  $(OBJ)\xfer.obj     $(OBJ)\common2.obj
                                                 ^^^^^^^^^^^^^^^^^^ add this


  C) Search for BBS_OVL and add the common.obj to the end of it, to add
     our overlaid part
  
=       sysopf.obj   tedit.obj    uedit.obj    voteedit.obj \
*       xferovl.obj  xfertmp.obj  xinit.obj    common.obj
                                               ^^^^^^^^^^ added part
  D) Go down a little to BBS_O_OVL
  
=        $(OBJ)\voteedit.obj $(OBJ)\xferovl.obj  $(OBJ)\xfertmp.obj  \
*        $(OBJ)\xinit.obj $(OBJ)\common.obj
                          ^^^^^^^^^^^^^^^^^ added part

  E) Down a little to the NON-OVERLAID PART

= share.obj   : share.c
=   $(TCC_NRM)
= utility.obj : utility.c
=   $(TCC_NRM)
= xfer.obj    : xfer.c
=   $(TCC_NRM)
+ common2.obj : common2.c
+   $(TCC_NRM)



  F) And now... down a ways... (IN THE OVERLAID PART)

xfertmp.obj : xfertmp.c
  $(TCC_OVL)
xinit.obj   : xinit.c
  $(TCC_OVL)
+ common.obj : common.c
+  $(TCC_OVL)


Step 5)
    FCNS.H
    
    Either update your fcns.h by typing make fcns or by manually inserting
    the following defenitions:
    
    These must go in between the #ifndef _FCNS_H_ and the final #endif

/* File: common2.c */

int find_batch_queue(char *fn);
void remove_batch(char *fn);
void CLS(void);
void CEOL_XY( unsigned x, unsigned y );
void CURSORUP( int x );
void CURSORDOWN( int x );
void CURSORRIGHT(int x);
void CURSORLEFT(int x);
void CHAR_XY( int x, int y, int z );
void XCTRPRINTF(int y, char *str );
void PRINTF_XY( int x, int y, char *str );
void BEEP(void);
void EOL(void);
void SAVCURS(void);
void RECALLCURS(void);
char *pad_string(char *string, int length);
char *pad_string_bg(char *string, int length, int bg);
char *justify_string(char *string, int length, int bg, int type);
int pd_amount_in_list(char *list, int rows, int cols);
int largest_in_list(char *list, int rows, int cols);
int widest_in_list(char *list[], int amount);
int wwiv_strlen(char *s);
int count_list(char *list[]);
int search_list(char **list, char *search, int amount_in_list);
int search_list_i(char **list, char *search, int amount_in_list);
void outstr_color(char *s);
void outchr_color(char c);
void npr_color(char *fmt, ...);
char * strip_string(char *string);
char *unalign(char *filename);
void buildfor(unsigned char attr, char *s);
void buildback(unsigned char attr, char *s);
void repeat_char(unsigned char x, int amount);
char *strstr_nocase(char *s1, char *s2);
void statusbar(statusbarrec *sb);
void strip_heart_colors(char *text);

/* File: common.c */

unsigned char pd_getkey(void);
char pd_inkey(void);
unsigned side_menu(int *menu_pos, int redraw, char *menu_items[], int xpos, int ypos, struct side_menu_colors *smc);
int new_control_break(void);
unsigned get_kb_event(void);
char onek_ncr(char *s);
int do_sysop_command(unsigned command);
void colorize_text(char *buffer);
void sprintf_color(char *buffer, char *fmt, ...);
void show_common_mods(void);
int copyfile(char *src, char *dst, int stats);
int movefile(char *src, char *dst, int stats);
char **alloc_2d(int row, int col, unsigned size);
void free_2d(char **pa);
varimenurec * addvarimenu(varimenurec *current, varimenurec *newitem);
void varimenuforward(varimenurec *menu, varimenuinfo *info);
void varimenubackward(varimenurec *menu, varimenuinfo *info);
void varimenuleft(varimenurec *menu, varimenuinfo *info);
void varimenuup(varimenurec *menu, varimenuinfo *info);
void varimenuright(varimenurec *menu, varimenuinfo *info);
void varimenudown(varimenurec *menu, varimenuinfo *info);
void varimenu(varimenurec *menu, varimenuinfo *info);
varimenurec * getvarimenurec(varimenurec *menu, int which);
void redrawvarimenu(int redraw, varimenurec *menu, varimenuinfo *info);
void killvarimenu(varimenurec *menu);
void kill_inputrec(inputeditrec *input);
void kill_showtextrec(showtextrec *text);
void kill_radiobutton(radiobuttonrec *radio);
void kill_checkbox(checkboxrec *check);
int varimenu_findhotkey(varimenurec *menu, varimenuinfo *info);
void fillvarimenurec(varimenurec *menu, void *rec, int type, unsigned hotkey, int returnvalue, int active);
void build_inputrec(inputeditrec *input, int maxlen, int xpos, int ypos, int width, int insert, int char_case);
void build_radiobuttonrec(radiobuttonrec *radio, int xpos, int ypos, int amount, int pos, int rc, int fc);
void build_checkboxrec(checkboxrec *check, int xpos, int ypos, int amount, int pos, unsigned bi, int rc, int fc);
void radio_button(radiobuttonrec *radio, varimenuinfo *info);
void check_box(checkboxrec *check, varimenuinfo *info);
void input_edit(inputeditrec *input, varimenuinfo *info);
int ok_char_inputedit(inputeditrec *input, varimenuinfo *info);
void add_char_inputedit(inputeditrec *input, varimenuinfo *info);
void redrawinputedit(int type, inputeditrec *input, varimenuinfo *info, int mode);
void delete_inputedit(inputeditrec *input, varimenuinfo *info);
void redrawradiobutton(int redraw, radiobuttonrec *radio, varimenuinfo *info, int mode);
void redrawcheckbox(int redraw, checkboxrec *check, varimenuinfo *info, int mode);
void redrawshowtext(int redraw, showtextrec *text, varimenuinfo *info, int mode);
void showtext(showtextrec *text, varimenuinfo *info);
void build_showtextrec(showtextrec *text, int xpos, int ypos, int width, char *t, int justify, int bg);
void test_vm(void);
void wait_sec_or_hit(double seconds);
void wait_sec(double seconds);
long filesize(FILE *stream);
int fset_rec(FILE *stream, unsigned rec, unsigned rec_size);
int set_rec(int filenum, unsigned rec, unsigned rec_size);
int check_bitfield(unsigned bitfield, char *which);
void test_check_bitfield(void);
int check_arc(char *filename);
int match_archiver(char *filename);
long file_daten(char *filename);
int input_common(char *dst, int max_size, char *dft);
void build_inputpicrec(inputpicrec *input, int xpos, int ypos, int width, int insert, char *picture);
void kill_inputpic(inputpicrec *input);
void input_picture(inputpicrec *input, varimenuinfo *info);
int ok_char_inputpic(inputpicrec *input, varimenuinfo *info);
char ** read_picture(char *picture);
void redrawinputpic(int type, inputpicrec *input, varimenuinfo *info, int mode);
int get_ini_value(char *fname, char *area, char *indent, char *value, int max_value);
int put_ini_value(char *fname, char *area, char *indent, char *value);
void free_ini_info(ini_inforec *ini_info);
int write_ini_file(ini_inforec *ini_info);
char *open_ini_file(char *fname, ini_inforec *ini_info);
char * increase_ini_allocation(ini_inforec *ini_info);
int set_ini_value(ini_inforec *ini_info, char *area, char *indent, char *value);
int read_ini_value(ini_inforec *ini_info, char *area, char *indent, char *value, int max_value);
char * get_ini_line(char *buff, int max_len, long *pos, char *ini);
void break_up_ini(char *buff, char *w1, char *w2);
long find_ini_area(char *ini, char *area);

