// ************************************************************************* //
// Begin COMMON mod, functions that are common among many Asylum releases    //
// If you get a duplicate function error, then you have it installed twice   //
// remove your oldest duplicated functions.                                  //
// ************************************************************************* //

/* *********************************************************************** */
/* Asylum COMMON - by Michael Deweese Copyright 1994                       */
/*                                                                         */
/* You may use this code in WWIV as installed under the COMMON.MOD file    */
/* You may not use this code in your own programs without the consent of   */
/* Michael Deweese.                                                        */
/* You can call these functions from your own WWIV modifications, but may  */
/* not rip these out and include them in your mod.  In other words, to     */
/* access these functions, the user using your modification must have      */
/* mod installed                                                           */
/*                                                                         */
/* Again, feel free to make mods requiring COMMON to be installed, just    */
/* as I do, but I really don't want these function ripped apart and        */
/* and included in individual mods, and it would make it impossible for me */
/* to maintain them.                                                       */


#include "vars.h"
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <conio.h>

// Makes the side menu to look fancy, show the hot char in a different color
// and will make sure the cursor is in a nice place, may be a little slower
// for 2400 bps callers
#define FANCY_LIST


int numlock=NOTNUMBERS;

unsigned char pd_getkey(void)
{
  unsigned char ch;
  int beepyet;
  long dd,tv,tv1;

  tleft(1);
  
  beepyet = 0;
  timelastchar1=timer1();

  if (so())
    tv=10920L;
  else
    tv=3276L;

  tv1=tv/2;

  lines_listed = 0;
  do
  {
    while (empty() && !hangup)
    {
      dd = timer1();
      if ((dd<timelastchar1) && ((dd+1000)>timelastchar1))
        timelastchar1=dd;
      if (labs(dd - timelastchar1) > 65536L)
        timelastchar1 -= 1572480L;
      if (((dd - timelastchar1) > tv1) && (!beepyet))
      {
        beepyet = 1;
        outchr(7);
      }
      if (labs(dd - timelastchar1) > tv)
      {
        nl();
        outstr("2Log off due to inactivity...Call back later when you are there.");
        nl();
        hangup = 1;
      }
      checkhangup();
    }
    ch = pd_inkey();
  } while (!ch && !in_extern && !hangup);
  if (checkit && (ch > 127)) {
    checkit = 0;
    ch = ch & (andwith = 0x7F);
  }
  return(ch);
}


char pd_inkey(void)
{
  char ch=0;
  
  tleft(1);

  if (x_only)
    return(0);

  if (charbufferpointer) {
    if (!charbuffer[charbufferpointer])
      charbufferpointer = charbuffer[0] = 0;
    else
      return(charbuffer[charbufferpointer++]);
  }
  if (kbhitb() || (in_extern == 2)) {
    ch = getchd1();
    lastcon = 1;
    if (!ch) {
      if (in_extern)
        in_extern = 2;
      else {
        ch = getchd1();
        skey(ch);
        ch = (((ch == 68) || (ch==103)) ? 2 : 0);
      }
    } else if (in_extern)
      in_extern = 1;
    timelastchar1=timer1();
  } else if (incom && comhit()) {
    ch = (get1c() & andwith);
    lastcon = 0;
  }
  return(ch);
}

unsigned side_menu(int *menu_pos, int redraw, char *menu_items[], int xpos, int ypos, struct side_menu_colors *smc)
{
  static int positions[20], amount=1;
  int x;
  unsigned event;

  tleft(1);
  
  if(redraw)
  {
    amount=1;
    positions[0]=xpos;
    while(menu_items[amount] && menu_items[amount][0] && !hangup )
    {
      positions[amount]=positions[amount-1]+strlen(menu_items[amount-1])+2;
      ++amount;
    }
    
    x=0;
    setc(smc->normal_menu_item);

    while(menu_items[x] && menu_items[x][0] && !hangup)
    {
      GOTO_XY(positions[x], ypos);
      
      if(*menu_pos==x)
      {
#ifdef FANCY_LIST
        setc(smc->current_highlight);
        outchr(menu_items[x][0]);
        setc(smc->current_menu_item);
        outstr(menu_items[x]+1);
#else        
        setc(smc->current_menu_item);
        outstr(menu_items[x]);
        setc(smc->nomal_menu_item); // This #else only resets colors because fancy will take care of it self... just leave me here...
#endif
      }
      else
#ifdef FANCY_LIST        
      {
        setc(smc->normal_highlight);
        outchr(menu_items[x][0]);
        setc(smc->normal_menu_item);
        outstr(menu_items[x]+1);
      }
#else      
        outstr(menu_items[x]);
#endif        
        
      ++x;
    }
  }
  
  
  
  setc(smc->normal_menu_item);

  while(!hangup)
  {
    event=get_kb_event();

       /* help       special command    help         extended key */
    if(event==CO || event == SPACE || event == '?' || event==EXECUTE || event==GET_OUT || event == HELP || event == HOTKEY)
      return event;
    
      
    if(event<128)
    {
      int x=0;
      while(menu_items[x] && menu_items[x][0] && !hangup)
      {
        if(event==toupper(menu_items[x][0]) || event==tolower(menu_items[x][0]))
        {
          GOTO_XY(positions[*menu_pos], ypos);
#ifdef FANCY_LIST
          setc(smc->normal_highlight);
          outchr(menu_items[*menu_pos][0]);
          setc(smc->normal_menu_item);
#endif
          outstr(menu_items[*menu_pos]+1);

          *menu_pos=x;
          
#ifdef FANCY_LIST
          setc(smc->current_highlight);
          GOTO_XY(positions[*menu_pos], ypos);
          outchr(menu_items[*menu_pos][0]);
          setc(smc->current_menu_item);
          outstr(menu_items[*menu_pos]+1);
#else      
          setc(smc->current_menu_item);
          GOTO_XY(positions[*menu_pos], ypos);
          outstr(menu_items[*menu_pos]);
          setc(smc->normal_menu_item);
#endif                    
          
#ifndef FANCY_LIST          
          // Don't waist time putting the cursor in a nice pos at slow speeds
          if(modem_speed>2400 || !using_modem)
#endif            
            GOTO_XY(positions[*menu_pos], ypos);
          
          return(EXECUTE);
        }
        ++x;
      }
    }
    else
    {
      switch(event)
      {
        case COMMAND_LEFT:
          GOTO_XY(positions[*menu_pos], ypos);
#ifdef FANCY_LIST        
            setc(smc->normal_highlight);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->normal_menu_item);
            outstr(menu_items[*menu_pos]+1);
#else      
          outstr(menu_items[*menu_pos]);
#endif
          if(!*menu_pos)
            *menu_pos=amount-1;
          else
            --*menu_pos;
            
#ifdef FANCY_LIST        
            setc(smc->current_highlight);
            GOTO_XY(positions[*menu_pos], ypos);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->current_menu_item);
            outstr(menu_items[*menu_pos]+1);
#else      
          setc(smc->current_menu_item);
          GOTO_XY(positions[*menu_pos], ypos);
          outstr(menu_items[*menu_pos]);
          setc(smc->normal_menu_item);
#endif                    
          
#ifndef FANCY_LIST          
          // Don't waist time putting the cursor in a nice pos at slow speeds
          if(modem_speed>2400 || !using_modem)
#endif            
            GOTO_XY(positions[*menu_pos], ypos);

          
          break;
          
        case COMMAND_RIGHT:
          GOTO_XY(positions[*menu_pos], ypos);
#ifdef FANCY_LIST        
            setc(smc->normal_highlight);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->normal_menu_item);
            outstr(menu_items[*menu_pos]+1);
#else      
          outstr(menu_items[*menu_pos]);
#endif          
          if(*menu_pos==amount-1)
            *menu_pos=0;
          else
            ++*menu_pos;
            
#ifdef FANCY_LIST        
            setc(smc->current_highlight);
            GOTO_XY(positions[*menu_pos], ypos);
            outchr(menu_items[*menu_pos][0]);
            setc(smc->current_menu_item);
            outstr(menu_items[*menu_pos]+1);
#else      
          setc(smc->current_menu_item);
          GOTO_XY(positions[*menu_pos], ypos);
          outstr(menu_items[*menu_pos]);
          setc(smc->normal_menu_item);
#endif          
            
#ifndef FANCY_LIST          
          // Don't waste time putting the cursor in a nice pos at slow speeds
          if(modem_speed>2400 || !using_modem)
#endif            
            GOTO_XY(positions[*menu_pos], ypos);

          
          break;
          
        default:
          return(event);
          
      }
    }
  } // While !hangup   
  return(0);      
}          

// Set up a new control break handler so that my getch's won't break out of the bbs
int new_control_break(void)
{
  sysoplog("Control Break pressed.  Program NOT aborting");
  return 1;
}

unsigned get_kb_event(void)
{
  time_t time1, time2;
  unsigned key;

  ctrlbrk(new_control_break); // Disable control break
  
  tleft(1);
  time(&time1);
  

  
  do{
    time(&time2);
    if(difftime(time2,time1) > 180 ) // greater than 3 minutes
    {
      hangup=1;
      return 0;
    }
    if(hangup)
      return 0;

    if(comhit() || kbhit())
    {
      if(!incom || kbhit())   // Check for local keys
      {
        key=getch();

        if(key==127)
          return(COMMAND_DELETE);
        if(key==22)
          return(COMMAND_INSERT);


        if(key==13 || key==12)
        {
          return(EXECUTE);
        }
        

        if(!key)
        {
          if(kbhit())
          {
            key=getch();
            return(key<<4);
          }
        }
        else 
        {
          if(numlock==NOTNUMBERS)
          {
            switch(key)
            {
              case '8':
                return(COMMAND_UP);
              case '4':
                return(COMMAND_LEFT);
              case '2':
                return(COMMAND_DOWN);
              case '6':
                return(COMMAND_RIGHT);
              case '0':
                return(COMMAND_INSERT);
              case '.':
                return(COMMAND_DELETE);
              case '9':
                return(COMMAND_PAGEUP);
              case '3':
                return(COMMAND_PAGEDN);
              case '7':
                return(COMMAND_HOME);
              case '1':
                return(COMMAND_END);
            }
          } 
          switch(key)
          {
            case TAB:
              return(TAB); 
            case ESC:
              return(GET_OUT);
            default:
            {
              return(key);
            }
          }
        }
      }
      else if(comhit())
      {
        key=pd_getkey();

        if(key==127)
          return(COMMAND_DELETE);
        if(key==22)
          return(COMMAND_INSERT);



        if(key==13 || key==12)
        {
          return(EXECUTE);
        }
        
        else if(key==ESC)
        {
          time_t time1;
          time_t time2;

          time(&time1);
          time(&time2);

          do
          {
            time(&time2);

            if(comhit())
            {
              key=pd_getkey();
              if(key==OB||key==O)
              {
                key=pd_getkey();

                // Check for a second set of brackets
                if(key==OB||key==O)
                  key=pd_getkey();

                switch(key)
                {
                  case A_UP:
                    return(COMMAND_UP);
                  case A_LEFT:
                    return(COMMAND_LEFT);
                  case A_DOWN:
                    return(COMMAND_DOWN);
                  case A_RIGHT:
                    return(COMMAND_RIGHT);
                  case A_INSERT:
                   return(COMMAND_INSERT);
                  case A_DELETE:
                   return(COMMAND_DELETE);
                  case A_HOME:
                    return(COMMAND_HOME);
                  case A_END:
                    return(COMMAND_END);

                  default:
                   return(key);
                }
              }
              else
                return(GET_OUT);
            }
          } while(difftime(time2,time1) < 1 && !hangup);

          if(difftime(time2,time1) >= 1)  // if no keys followed ESC
            return(GET_OUT);
        }
        else
        {

          if(!key)
          {
            if(kbhit())
            {
              key=getch();
              return(key<<4);
            }
          }


          if(numlock==NOTNUMBERS)
          {
            switch(key)
            {
              case '8':
                return(COMMAND_UP);
              case '4':
                return(COMMAND_LEFT);
              case '2':
                return(COMMAND_DOWN);
              case '6':
                return(COMMAND_RIGHT);
              case '0':
                return(COMMAND_INSERT);
              case '.':
                return(COMMAND_DELETE);
              case '9':
                return(COMMAND_PAGEUP);
              case '3':
                return(COMMAND_PAGEDN);
              case '7':
                return(COMMAND_HOME);
              case '1':
                return(COMMAND_END);
            }
          }  
          switch(key)
          {
            default:
              return(key);
          }
        }
      }
      time(&time1);  // reset timer
    }
    else
      giveup_timeslice();
    
  }while(!hangup);
  return 0; // must have hung up
}



// Like onek but does not put cursor down a line
// One key, no carriage return
char onek_ncr(char *s)
{
  char ch;

  while (!strchr(s, ch = upcase(getkey())) && !hangup)
    ;
  if (hangup)
    ch = s[0];
  outchr(ch);
  return (ch);
}


int do_sysop_command(unsigned command)
{
  unsigned x;
  int needredraw=0;

  switch(command)
  {
    // Commands that cause screen to need to be redrawn go here
    case COMMAND_F1:
    case COMMAND_CF1:
    case COMMAND_CF9:
    case COMMAND_F10:
    case COMMAND_CF10:
      needredraw=1;
      x=command>>4;
      break;

    // Commands that don't change the screen around
    case COMMAND_SF1:
    case COMMAND_F2:
    case COMMAND_SF2:
    case COMMAND_CF2:
    case COMMAND_F3:
    case COMMAND_SF3:
    case COMMAND_CF3:
    case COMMAND_F4:
    case COMMAND_SF4:
    case COMMAND_CF4:
    case COMMAND_F5:
    case COMMAND_SF5:
    case COMMAND_CF5:
    case COMMAND_F6:
    case COMMAND_SF6:
    case COMMAND_CF6:
    case COMMAND_F7:
    case COMMAND_SF7:
    case COMMAND_CF7:
    case COMMAND_F8:
    case COMMAND_SF8:
    case COMMAND_CF8:
    case COMMAND_F9:
    case COMMAND_SF9:
    case COMMAND_SF10:
      needredraw=0;
      x=command>>4;
      break;
      
    default:
      x=0;
      break;
  }
      
  if(x)
  {
    if(needredraw)
      CLS();

    skey(x);

    if(needredraw)
      CLS();
  }
  
  return(needredraw);
}




// All the different functions that output strings to the screen and com
// buffer, all of these need to be modifed to get the following color in
// These don't count functions like npr and prt, since they end up calling
// outstr to do the string printing... wonder if Wayne thinks he needs any
// more functions to print string... hmmm....
// outstr  OutString (COM.C)
// pla     Print Line with Abort (BBSUTL.C)
// plal    Print Line with Abort and Limit how much can be printed hmm npr... (BBSUTL.C)
// osan    OutString with Abort and Next (MSGBASE.C)
// plan    Print Line with Abort and Next (MSGBASE.C)

// Oh, colors are...
// |00 - |15 regular dos foreground colors
// |16 - |23 OR |b0- |b7 for regular dos background colors
// There MUST be two numbers following the pipe, ie |01 NOT |1
void colorize_text(char *buffer)
{
  int pos=0, fmt_pos=0;
  int attrib, col;
  char num[3];
  char *formated;
  char color[50];
  unsigned long x;


  x=strlen(buffer);
  x=(x)+100;

  formated=(char *)malloca(x);
  if(!formated)
  {
    sysoplog("No mem to color text");
    return;
  }
  formated[0]=0;


  while(buffer[fmt_pos] && pos < x)
  {
    if(buffer[fmt_pos]=='|')
    {
      if(isdigit(buffer[fmt_pos+1]) || buffer[fmt_pos+1]==' ')
      {
        if(isdigit(buffer[fmt_pos+2]) || (buffer[fmt_pos+2]==' ' && buffer[fmt_pos+1]!=' '))
        {

          if(buffer[fmt_pos+1]!='b' || buffer[fmt_pos+1]=='B')
          {
            strncpy(num, buffer+fmt_pos+1, 2);
            num[2]=0;
            col=atoi(num);

            if(col<16)
            {
              attrib=col;
              buildfor(attrib, color);
            }
            else // For background colors 16-23)
            {
              col-=16;
              attrib=col;
              buildback(attrib, color);
            }

            fmt_pos+=3;
            strcat(formated, color);
            pos+=strlen(color);
          }
          else if(buffer[fmt_pos+1]=='b' || buffer[fmt_pos+1]=='B')
          {
            strncpy(num, buffer+fmt_pos+2, 1);
            num[1]=0;

            col=(atoi(num));
            attrib=col;
            buildback(attrib, color);

            fmt_pos+=3;
            strcat(formated, color);
            pos+=strlen(color);
          }
          else
          {
            formated[pos]=buffer[fmt_pos];
            formated[pos+1]=0;
            ++pos;
            ++fmt_pos;
          }
        }
        else
        {
          formated[pos]=buffer[fmt_pos];
          formated[pos+1]=0;
          ++pos;
          ++fmt_pos;
        }
      }
      else
      {
        formated[pos]=buffer[fmt_pos];
        formated[pos+1]=0;
        ++pos;
        ++fmt_pos;
      }
    }
    else
    {
      formated[pos]=buffer[fmt_pos];
      formated[pos+1]=0;
      ++pos;
      ++fmt_pos;
    }
  }
  formated[pos]=0;
  strcpy(buffer, formated);
  free(formated);
}

// Calls the above colorize_text to print out '|colors'
// This call and npr_color are only meant for formats that when expanded
// Will be less than 512 characters, this is fine for most cases, but not
// something like an extended description
void sprintf_color(char *buffer, char *fmt, ...)
{
  va_list ap;

  va_start(ap, fmt);
  vsprintf(buffer, fmt, ap);
  va_end(ap);

  colorize_text(buffer);
}



void show_common_mods(void)
{
  existprint("COMMON.LST");
}


int replacefile(char *src, char *dst, int stats)
{
  if(exist(dst))
    unlink(dst);

  return(copyfile(src, dst, stats));
}


int copyfile(char *src, char *dst, int stats)
{
  char source[201], dest[201];
  char *cbuff;
  int origfile, destfile;
  int amount;

  char sys[201];


  strcpy(source, src);
  strcpy(dest, dst);

  strupr(source);
  strupr(dest);


  if(stats)
  {
    sprintf(sys, "8Copying File: 9%s - ", source);
    outstr(sys);
  }


  if(exist(dest))
    return 1;

  origfile=sh_open1(source,O_RDONLY | O_BINARY);

  sprintf(sys, "Copy Error: %s -> %s", source, dest);
  if(origfile==-1)
  {
    nl();
    ansic(3);
    pl(sys);
    sysoplog(sys);

    return 0;
  }
  destfile=sh_open1(dest,O_RDWR | O_BINARY | O_CREAT | O_TRUNC);
  if(destfile==-1)
  {
    ansic(3);
    pl(sys);
    sysoplog(sys);

    sh_close(origfile);
    return 0;
  }

  else  /* copy file */
  {
    if((cbuff=(char *)malloca(25000))==NULL)
    {
      sysoplog("Could not allocate memory to copy file");
      sh_close(origfile);
      sh_close(destfile);
      return 0;
    }
    else  // If this does not get executed, it was a failure
    {
      statusbarrec sb;
      long fl;

      fl=filelength(origfile);

      if(stats)
      {
        sb.width=20;
        sb.amount_per_square=4;
        sb.square_list[0]='';
        sb.square_list[1]='';
        sb.square_list[2]='';
        sb.square_list[3]='';
        sb.empty_space='-';
        sb.side_char1='[';
        sb.side_char2=']';
        sb.surround_color=WHITE;
        sb.box_color=LIGHTBLUE;
        sb.total_items=fl;
        sb.current_item=0;

        statusbar(&sb);
      }

      amount=sh_read(origfile, (void *)cbuff, 25000);

      if(stats)
      {
        sb.current_item+=amount;
        statusbar(&sb);
      }

      while(amount>0)
      {
        sh_write(destfile,(void *)cbuff,amount);

        amount=sh_read(origfile,(void *)cbuff,25000);


        if(stats)
        {
          if(amount)
          {
            sb.current_item+=amount;
            statusbar(&sb);
          }
        }
      }

      sh_close(origfile);
      sh_close(destfile);
      farfree(cbuff);

      if(stats)
      {
        nl();
        ansic(0);
      }
    }
  }
  return(2);
}

// Just like copyfile, except if the files are on the same drive, it will
// rename them (which is very fast) instead of copying them, also, after
// a copy, it will remove the source file (since it was 'moved')
int movefile(char *src, char *dst, int stats)
{
  char source[201], dest[201];
  char *cbuff;
  int origfile, destfile;
  int x;


  strcpy(source, src);
  strcpy(dest, dst);

  strupr(source);
  strupr(dest);


  if ((strcmp(source,dest)!=0) && (exist(source)))
  {
    int which_way=0;
    if ((source[1]!=':') && (dest[1]!=':'))
      which_way=1;
    if ((source[1]==':') && (dest[1]==':') && (source[0]==dest[0]))
      which_way=1;

    if (which_way)
    {
      rename(source, dest);
      return 2;
    }
  }

  x = copyfile(src, dst, stats);
  unlink(src);

  return x;
}


char **alloc_2d(int row, int col, unsigned size)
{
   int i;
   char **prow, *pdata;

   pdata = (char *) calloc(row * col, size);
   if (pdata == (char *) NULL) {
      sysoplog("No heap space for data\n");
      pl("Memory Error!");
      hangup=1;
      return(NULL);
   }
   prow  = (char **) malloc(row * sizeof (char *));
   if (prow == (char **) NULL) {
      sysoplog("No heap space for row pointers\n");
      pl("Memory Error!");
      hangup=1;
      free(pdata);
      return(NULL);
   }

   for (i = 0; i < row; i++) {
     prow[i] = pdata;             /* store pointers to rows */
     pdata += size * col;         /* move to next row */
   }
   return prow;                   /* pointer to 2D array */
}

void free_2d(char **pa)
{
   free(*pa);                    /* free the data */
   free(pa);                     /* free pointer to row pointers */
}



varimenurec * addvarimenu(varimenurec *current, varimenurec *newitem)
{
  varimenurec *temp;
  int cur, amount;

  if(current==NULL)
  {
    current=(varimenurec *) malloc(sizeof(varimenurec));
    memmove((void *)current, (void *)newitem, sizeof(varimenurec));

    current->next=NULL;
    current->amount=1;

    return(current);
  }


  amount=current->amount;
  cur=0;
  temp=current;

  while(cur<amount-1)
  {
    temp=temp->next;
    ++cur;
  }

  temp->next=(varimenurec *) malloc(sizeof(varimenurec));
  temp=temp->next;

  memmove((void *)temp, (void *)newitem, sizeof(varimenurec));
  temp->next=NULL;

  ++current->amount;
  return(current);
}

void varimenuforward(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int done=0, cur=0, amount=menu->amount;

  info->last=info->pos;

  while(!done)
  {
    if(info->pos)
    {
      --info->pos;
      temp=getvarimenurec(menu, info->pos);
      if(temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    else
    {
      info->pos=amount-1;

      temp=getvarimenurec(menu, info->pos);
      if(temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }

    ++cur;

    if(cur==amount)
      done=1;
  }
}

void varimenubackward(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int done=0, cur=0, amount=menu->amount;

  info->last=info->pos;

  while(!done)
  {
    if(info->pos<amount-1)
    {
      ++info->pos;

      temp=getvarimenurec(menu, info->pos);
      if(temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    else
    {
      info->pos=0;

      temp=getvarimenurec(menu, info->pos);
      if(temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    ++cur;

    if(cur==amount)
      done=1;
  }
}

void varimenuleft(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int done=0, cur=0, amount=menu->amount;
  int looky=0;

  info->last=info->pos;

  temp=getvarimenurec(menu, info->pos);
  looky=temp->ypos;


  while(!done)
  {
    int thisy=0;

    if(info->pos)
    {
      --info->pos;
      temp=getvarimenurec(menu, info->pos);

      thisy=temp->ypos;

      if(thisy==looky && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    else
    {
      if(looky)
        --looky;
      else
        looky=60;

      info->pos=amount-1;

      temp=getvarimenurec(menu, info->pos);
      thisy=temp->ypos;

      if(thisy==looky && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }

    ++cur;

//    if(cur==amount)
//      done=1;
  }
  
}

void varimenuup(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int done=0, cur=0, amount=menu->amount;
  int lookx=0;

  info->last=info->pos;

  temp=getvarimenurec(menu, info->pos);
  lookx=temp->xpos;


  while(!done)
  {
    int thisx=0;

    if(info->pos)
    {
      --info->pos;
      temp=getvarimenurec(menu, info->pos);
      thisx=temp->xpos;

      if(thisx==lookx && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    else
    {
      if(lookx)
        --lookx;
      else
        lookx=80;



      info->pos=amount-1;

      temp=getvarimenurec(menu, info->pos);
      thisx=temp->xpos;

      if(thisx==lookx && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }

    ++cur;

//    if(cur==amount)
//      done=1;
  }
  
}

void varimenuright(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int done=0, cur=0, amount=menu->amount;
  int looky;

  info->last=info->pos;

  temp=getvarimenurec(menu, info->pos);
  looky=temp->ypos;


  while(!done)
  {
    int thisy;

    if(info->pos<amount-1)
    {
      ++info->pos;

      temp=getvarimenurec(menu, info->pos);
      thisy=temp->ypos;

      if(thisy==looky && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    else
    {
      if(looky<=60)
        ++looky;
      else
        looky=0;


      info->pos=0;

      temp=getvarimenurec(menu, info->pos);
      thisy=temp->ypos;

      if(thisy==looky && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    ++cur;

//    if(cur==amount)
//      done=1;
  }
}

void varimenudown(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int done=0, cur=0, amount=menu->amount;
  int lookx;

  info->last=info->pos;

  temp=getvarimenurec(menu, info->pos);
  lookx=temp->xpos;


  while(!done)
  {
    int thisx;

    if(info->pos<amount-1)
    {
      ++info->pos;

      temp=getvarimenurec(menu, info->pos);
      thisx=temp->xpos;

      if(thisx==lookx && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    else
    {
      if(lookx<120)
        ++lookx;
      else
        lookx=0;



      info->pos=0;

      temp=getvarimenurec(menu, info->pos);
      thisx=temp->xpos;

      if(thisx==lookx && temp->active)
      {
        done=1;
        redrawvarimenu(COMMON_PARTIAL, menu, info);
      }
    }
    ++cur;

//    if(cur==amount)
//      done=1;
  }
}


void varimenu(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;


  if(info->redraw!=COMMON_NONE)
    redrawvarimenu(info->redraw, menu, info);

  info->redraw=COMMON_NONE;

  while(1)
  {
    temp=getvarimenurec(menu, info->pos);
    switch(temp->type)
    {
      case SHOW_TEXT_TYPE:
        showtext(&temp->types->st, info);
        break;

      case INPUT_EDIT_TYPE:
        input_edit(&temp->types->ie, info);
        break;

      case RADIO_BUTTON_TYPE:
        radio_button(&temp->types->rb, info);
        break;

      case CHECK_BOX_TYPE:
        check_box(&temp->types->cb, info);
        break;


      default:
        sysoplog("Undefined type in varimenu");
        break;
    }

    if(varimenu_findhotkey(menu, info) > -1000)
    {
      redrawvarimenu(COMMON_PARTIAL, menu, info);

      temp=getvarimenurec(menu, info->pos);
      info->returnvalue=temp->returnvalue;

      return;
    }

    switch(info->event)
    {
      case COMMAND_STAB:
        varimenuforward(menu, info);
        break;

      case COMMAND_UP:
        varimenuup(menu, info);
        break;

      case COMMAND_LEFT:
        varimenuleft(menu, info);
        break;

      case COMMAND_DOWN:
        varimenudown(menu, info);
        break;

      case COMMAND_RIGHT:
        varimenuright(menu, info);
        break;

      case TAB:
        varimenubackward(menu, info);
        break;

      default:

        temp=getvarimenurec(menu, info->pos);
        info->returnvalue=temp->returnvalue;
        return;
    }
  }
}

varimenurec * getvarimenurec(varimenurec *menu, int which)
{
  varimenurec *temp;
  int pos=0;
  int amount=menu->amount;

  if(which>=amount)
  {
    sysoplog("Tried to get a varimenuitem that is out of range");
    return NULL;
  }

  temp=menu;
  if(which==0)
    return(temp);



  while(pos<which)
  {
    temp=temp->next;
    if(pos==which)
      return(temp);

    ++pos;
  }

  return(temp);
}




void redrawvarimenu(int redraw, varimenurec *menu, varimenuinfo *info)
{
  varimenurec *temp;
  int cur, savecolor=curatr;
  int mode;



  if(redraw==COMMON_FULL)
  {
    cur=0;
    temp=menu;

    setc(info->mi_normal);


    while(cur<menu->amount)
    {
      if(cur)
        temp=temp->next;
      else
        temp=menu;

      mode = temp->active==FALSE ? COMMON_INACTIVE : cur==info->pos ? COMMON_CURRENT : COMMON_ITEM;


      switch(temp->type)
      {
        case SHOW_TEXT_TYPE:
          redrawshowtext(COMMON_FULL, &temp->types->st, info, mode);
          break;

        case INPUT_EDIT_TYPE:
          redrawinputedit(COMMON_FULL, &temp->types->ie, info, mode);
          break;

        case RADIO_BUTTON_TYPE:
          redrawradiobutton(COMMON_FULL, &temp->types->rb, info, mode);
          break;

        case CHECK_BOX_TYPE:
          redrawcheckbox(COMMON_FULL, &temp->types->cb, info, mode);
          break;

        default:
          sysoplog("Undefined type in redrawvarimenu");
          break;
      }

      ++cur;
    }
  }
  else if(redraw==COMMON_PARTIAL)
  {
    if(info->pos!=info->last)
    {
      temp=getvarimenurec(menu, info->pos);

      mode = temp->active==FALSE ? COMMON_INACTIVE : COMMON_CURRENT;

      switch(temp->type)
      {
        case SHOW_TEXT_TYPE:
          redrawshowtext(COMMON_NONE, &temp->types->st, info, mode);
          break;

        case INPUT_EDIT_TYPE:
          redrawinputedit(COMMON_NONE, &temp->types->ie, info, mode);
          break;

        case RADIO_BUTTON_TYPE:
          redrawradiobutton(COMMON_NONE, &temp->types->rb, info, mode);
          break;

        case CHECK_BOX_TYPE:
          redrawcheckbox(COMMON_NONE, &temp->types->cb, info, mode);
          break;


        default:
          sysoplog("Undefined type in redrawvarimenu");
          break;
      }



      temp=getvarimenurec(menu, info->last);

      mode = temp->active==FALSE ? COMMON_INACTIVE : COMMON_ITEM;

      switch(temp->type)
      {
        case SHOW_TEXT_TYPE:
          redrawshowtext(COMMON_FULL, &temp->types->st, info, mode);
          break;

        case INPUT_EDIT_TYPE:
          redrawinputedit(COMMON_FULL, &temp->types->ie, info, mode);
          break;

        case RADIO_BUTTON_TYPE:
          redrawradiobutton(COMMON_FULL, &temp->types->rb, info, mode);
          break;

        case CHECK_BOX_TYPE:
          redrawcheckbox(COMMON_FULL, &temp->types->cb, info, mode);
          break;


        default:
          sysoplog("Undefined type in redrawvarimenu");
          break;
      }
    }

  }
  else if(redraw==COMMON_NONE)
  {
    return;
  }
  else
  {
    sysoplog("RedrawVariMenu is getting an invalid redraw value");
    return;
  }

  GOTO_XY(info->xpos, info->ypos);
  setc(savecolor);
}


void killvarimenu(varimenurec *menu)
{
  varimenurec *m[100];
  int cur=1, amount=menu->amount;

  m[0]=menu;

  while(cur < amount)
  {
    m[cur]=m[cur-1]->next;
    ++cur;
  }

  cur=0;
  while(cur < amount)
  {
    if(m[cur]->type==INPUT_EDIT_TYPE)
      kill_inputrec(&m[cur]->types->ie);
    else if(m[cur]->type==SHOW_TEXT_TYPE)
      kill_showtextrec(&m[cur]->types->st);
    else if(m[cur]->type==RADIO_BUTTON_TYPE)
      kill_radiobutton(&m[cur]->types->rb);
    else if(m[cur]->type==CHECK_BOX_TYPE)
      kill_checkbox(&m[cur]->types->cb);



    free(m[cur]);
    ++cur;
  }
}

void kill_inputrec(inputeditrec *input)
{
  free(input->text);
  free(input->show);
}

void kill_showtextrec(showtextrec *text)
{
  free(text->text);
  free(text->show);
}

void kill_radiobutton(radiobuttonrec *radio)
{
  if(radio!=radio)
    radio=radio;
}

void kill_checkbox(checkboxrec *check)
{
  if(check!=check)
    check=check;
}






int varimenu_findhotkey(varimenurec *menu, varimenuinfo *info)
{
  varimenurec *m;
  int cur=0, amount=menu->amount;

  unsigned e, h;


  m=menu;

  e=info->event;
  h=m->hotkey;

  if(!h || !e)
    return -1001;

  if(e>='A' && e <='Z')
    e=tolower(e);
  if(h>='A' && h <='Z')
    h=tolower(h);

  if(e==h && e)
  {
    if(menu->type==SHOW_TEXT_TYPE)
      info->event=EXECUTE;
    info->last=info->pos;
    info->pos=cur;

    return 1;
  }

  ++cur;  // we checked pos 0, inc up to pos 1
  while(cur < amount)
  {
    m=m->next;

    h=m->hotkey;
    if(h>='A' && h <='Z')
      h=tolower(h);


    if(e==h && e)
    {
      if(menu->type==SHOW_TEXT_TYPE)
        info->event=EXECUTE;
      info->last=info->pos;
      info->pos=cur;

      return 1;
    }

    ++cur;

  }
  return -1001;
}


void fillvarimenurec(varimenurec *menu, void *rec, int type, unsigned hotkey, int returnvalue, int active)
{
  memset(menu, 0, sizeof(varimenurec));

  (void *)menu->types=rec;

  menu->type=type;

  menu->hotkey=hotkey;
  menu->returnvalue=returnvalue;

  menu->active=active;

  switch(menu->type)
  {
    case SHOW_TEXT_TYPE:
      menu->xpos=menu->types->st.xpos;
      menu->ypos=menu->types->st.ypos;
      break;

    case INPUT_EDIT_TYPE:
      menu->xpos=menu->types->ie.xpos;
      menu->ypos=menu->types->ie.ypos;
      break;

    case RADIO_BUTTON_TYPE:
      menu->xpos=menu->types->rb.xpos;
      menu->ypos=menu->types->rb.ypos;
      break;

    case CHECK_BOX_TYPE:
      menu->xpos=menu->types->cb.xpos;
      menu->ypos=menu->types->cb.ypos;
      break;
  }
}



void build_inputrec(inputeditrec *input, int maxlen, int xpos, int ypos, int width, int insert, int char_case)
{
  memset(input, 0, sizeof(inputeditrec));

  input->pos=0;
  input->curlen=0;
  input->maxlen=maxlen;
  input->first=0;
  input->xpos=xpos;
  input->ypos=ypos;
  input->amount_to_show=width;
  input->curxpos=xpos;
  input->curypos=ypos;
  input->insert=insert;
  input->curmode=-1;
  input->text=(char *)malloc(maxlen+1);
  memset(input->text, 0, maxlen+1);
  input->show=(char *)malloc(width+5);
  memset(input->show, 0, width);
  input->char_case=char_case;
}

void build_radiobuttonrec(radiobuttonrec *radio, int xpos, int ypos, int amount, int pos, int rc, int fc)
{
  memset(radio, 0, sizeof(radiobuttonrec));
  radio->xpos=xpos;
  radio->ypos=ypos;
  radio->amount=amount;
  radio->pos=pos;

  if(pos >= amount)
    pos=amount-1;

  radio->radio_char=rc;
  radio->fill_char=fc;
}

void build_checkboxrec(checkboxrec *check, int xpos, int ypos, int amount, int pos, unsigned bi, int rc, int fc)
{
  memset(check, 0, sizeof(checkboxrec));
  check->xpos=xpos;
  check->ypos=ypos;
  check->amount=amount;
  check->bi.n.ni=bi;

  check->pos=pos;
  if(pos >= amount)
    pos=amount-1;


  check->check_char=rc;
  check->fill_char=fc;
}

void radio_button(radiobuttonrec *radio, varimenuinfo *info)
{
  if(info->redraw!=COMMON_NONE)
    redrawradiobutton(info->redraw, radio, info, COMMON_CURRENT);

  while(1)
  {
    info->event=get_kb_event();

    switch(info->event)
    {
      case COMMAND_UP:
        radio->last=radio->pos;
        if(radio->pos)
        {
          --radio->pos;
          redrawradiobutton(COMMON_PARTIAL, radio, info, COMMON_CURRENT);
        }
        else
        {
          radio->pos=radio->amount-1;
          redrawradiobutton(COMMON_PARTIAL, radio, info, COMMON_CURRENT);
        }
        info->event=0;
        return;
        
      case COMMAND_DOWN:
        radio->last=radio->pos;
        if(radio->pos<radio->amount-1)
        {
          ++radio->pos;
          redrawradiobutton(COMMON_PARTIAL, radio, info, COMMON_CURRENT);
        }
        else
        {
          radio->pos=0;
          redrawradiobutton(COMMON_PARTIAL, radio, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      default:
        return;
    }
  }
}

void check_box(checkboxrec *check, varimenuinfo *info)
{
  if(info->redraw!=COMMON_NONE)
    redrawcheckbox(info->redraw, check, info, COMMON_CURRENT);

  while(1)
  {
    info->event=get_kb_event();

    switch(info->event)
    {
      case COMMAND_UP:
        if(check->pos)
        {
          --check->pos;
          redrawcheckbox(COMMON_NONE, check, info, COMMON_CURRENT);
        }
        else
        {
          check->pos=check->amount-1;
          redrawcheckbox(COMMON_NONE, check, info, COMMON_CURRENT);
        }
        info->event=0;
        return;
        
      case COMMAND_DOWN:
        if(check->pos<check->amount-1)
        {
          ++check->pos;
          redrawcheckbox(COMMON_NONE, check, info, COMMON_CURRENT);
        }
        else
        {
          check->pos=0;
          redrawcheckbox(COMMON_NONE, check, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case ' ':
        if(BitTst(check->bi.n.ni, check->pos))
          check->bi.n.ni=BitClr(check->bi.n.ni, check->pos);
        else
          check->bi.n.ni=BitSet(check->bi.n.ni, check->pos);

        redrawcheckbox(COMMON_PARTIAL, check, info, COMMON_CURRENT);
        info->event=0;
        return;

      default:
        return;

    }
  }
}



void input_edit(inputeditrec *input, varimenuinfo *info)
{
  if(info->redraw!=COMMON_NONE)
    redrawinputedit(info->redraw, input, info, COMMON_CURRENT);

  while(1)
  {
    info->event=get_kb_event();
    input->bs=FALSE;

    switch(info->event)
    {
      case COMMAND_LEFT:
        if(input->pos)
        {
          --input->pos;
          redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;
        
      case COMMAND_RIGHT:
        if(input->pos<input->curlen)
        {
          ++input->pos;
          redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_HOME:
        if(input->pos!=0)
        {
          input->pos=0;
          redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_END:
        if(input->pos!=input->maxlen)
        {
          input->pos=input->curlen;
          redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_INSERT:
        input->insert=!input->insert;
        info->event=0;
        return;

      case BACKSPACE:
        if(input->pos)
        {
          --input->pos;
          delete_inputedit(input, info);
          redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_DELETE:
        delete_inputedit(input, info);
        redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        info->event=0;
        return;

      case COMMAND_STAB:
      case TAB:
        return;

      default:

        if(ok_char_inputedit(input, info))
        {
          if(IE_UPPER & input->char_case)
            info->event=toupper(info->event);
          else if(IE_PROPPER & input->char_case)
          {
            if(input->pos && isspace(input->text[input->pos-1]))
              info->event=toupper(info->event);
          }

          add_char_inputedit(input, info);
          redrawinputedit(COMMON_PARTIAL, input, info, COMMON_CURRENT);

          info->event=0;
          return;
        }
        else
          return;
    }
  }
}

int ok_char_inputedit(inputeditrec *input, varimenuinfo *info)
{
  unsigned event;

  event=info->event;

  if(event >= ' ' && event < 255)
    return 1;

  // Cut off warning until I expand this function
  if(input!=input)
    input=input;

  return 0;
}

void add_char_inputedit(inputeditrec *input, varimenuinfo *info)
{
  if(input->insert)
  {
    if(input->curlen<input->maxlen)
    {
      memmove(input->text+input->pos+1, input->text+input->pos, input->curlen-input->pos+1);
      input->text[input->pos]=(char)info->event;
      ++input->pos;
      ++input->curlen;
    }
  }
  else
  {
    if(input->pos<input->maxlen)
    {
      input->text[input->pos]=(char)info->event;

      if(input->pos==input->curlen)
        ++input->curlen;

      ++input->pos;
    }
  }
}


void redrawinputedit(int type, inputeditrec *input, varimenuinfo *info, int mode)
{
  int savecolor=curatr;

  if(input->pos < input->first)
  {
    input->first=input->pos - (input->amount_to_show/2);
    if(input->first<0)
      input->first=0;

    type=COMMON_FULL;
  }
  else if(input->pos - input->first > input->amount_to_show)
  {
    input->first=input->pos - (input->amount_to_show/2);
    if(input->first > input->maxlen)
      input->first=input->maxlen;
    type=COMMON_FULL;
  }
  else if(input->curmode!=mode)
    type=COMMON_FULL;

  input->curmode=mode;

  input->curxpos=input->xpos+(input->pos-input->first);
  input->curypos=input->ypos;

  if(type==COMMON_FULL)
  {
    strncpy(input->show, input->text+input->first, input->amount_to_show);
    input->show[input->amount_to_show]=0;

    pad_string(input->show, input->amount_to_show);
    GOTO_XY(input->xpos, input->ypos);
    setc(mode==COMMON_INACTIVE ? info->inactive_color : mode ==COMMON_ITEM ? info->mi_normal : info->ci_normal);

    if(IE_PASSWORD & input->char_case)
      echo=0;
    else
      echo=1;
    outstr(input->show);
  }
  else if(type==COMMON_PARTIAL)
  {
    int where = input->first+(input->pos-input->first);
    int a=input->amount_to_show-(input->pos-input->first)+1;

    if(input->pos!=input->first)
    {
      strncpy(input->show, input->text+where-1, a+1);
      input->show[a]=0;
      input->show[input->amount_to_show]=0 ;

      if(input->bs && strlen(input->show) != input->amount_to_show)
        strcat(input->show, " ");

      GOTO_XY(input->xpos + input->pos - input->first - 1, input->ypos);
    }
    else
    {
      strncpy(input->show, input->text+where, a);
      input->show[a]=0;
      input->show[input->amount_to_show]=0;

      if(input->bs && strlen(input->show) != input->amount_to_show)
        strcat(input->show, " ");

      GOTO_XY(input->xpos + input->pos - input->first, input->ypos);
    }
    setc(mode==COMMON_INACTIVE ? info->inactive_color : mode ==COMMON_ITEM ? info->mi_normal : info->ci_normal);

    if(IE_PASSWORD & input->char_case)
      echo=0;
    else
      echo=1;
    outstr(input->show);
  }
  else if(type==COMMON_NONE)
  {
  }
  else
  {
    sysoplog("Undefined update type in function redrawinputedit");
  }


  if(mode==COMMON_CURRENT)
  {

    info->xpos=input->xpos + input->pos - input->first;
    info->ypos=input->ypos;
    GOTO_XY(info->xpos, info->ypos);
  }

  input->bs=FALSE;
  setc(savecolor);
}


void delete_inputedit(inputeditrec *input, varimenuinfo *info)
{
  if((input->pos>0 && input->pos==input->curlen) || !input->curlen)
  {
    info->redraw=COMMON_NONE;
    return;
  }

  memmove(input->text+input->pos, input->text+input->pos+1, input->curlen-input->pos);

  --input->curlen;
  input->bs=TRUE;
  info->redraw=COMMON_PARTIAL;
}


void redrawradiobutton(int redraw, radiobuttonrec *radio, varimenuinfo *info, int mode)
{
  int savecolor=curatr;
  int color;
  int x=0;

  if(redraw==COMMON_FULL)
  {

    while(x<radio->amount)
    {
      color = (mode == COMMON_INACTIVE ? info->inactive_color : x == radio->pos ? info->mi_normal : info->ci_normal);
      setc(color);

      GOTO_XY(radio->xpos, radio->ypos+x);
      if(x==radio->pos)
        outchr(radio->radio_char);
      else
        outchr(radio->fill_char);

      ++x;
    }
  }
  else if(redraw!=COMMON_NONE)
  {
    if(radio->pos!=radio->last)
    {
      while(x<radio->amount)
      {
        if(x==radio->pos || x==radio->last)
        {
          color = (mode == COMMON_INACTIVE ? info->inactive_color : x == radio->pos ? info->mi_normal : info->ci_normal);
          setc(color);

          GOTO_XY(radio->xpos, radio->ypos+x);
          if(x==radio->pos)
            outchr(radio->radio_char);
          else
            outchr(radio->fill_char);
        }
        ++x;
      }
    }
  }


  if(mode==COMMON_CURRENT)
  {
    info->xpos=radio->xpos;
    info->ypos=radio->ypos+radio->pos;
    GOTO_XY(info->xpos, info->ypos);
  }

  setc(savecolor);
}

void redrawcheckbox(int redraw, checkboxrec *check, varimenuinfo *info, int mode)
{
  int savecolor=curatr;
  int color;
  int x=0;

  if(redraw==COMMON_FULL)
  {

    while(x<check->amount)
    {
      color = (mode == COMMON_INACTIVE ? info->inactive_color : x == check->pos ? info->mi_normal : info->ci_normal);
      setc(color);

      GOTO_XY(check->xpos, check->ypos+x);
      if(BitTst(check->bi.n.ni, x))
        outchr(check->check_char);
      else
        outchr(check->fill_char);

      ++x;
    }
  }
  else if(redraw!=COMMON_NONE)
  {
    while(x<check->amount)
    {
      if(x==check->pos)
      {
        color = (mode == COMMON_INACTIVE ? info->inactive_color : x == check->pos ? info->mi_normal : info->ci_normal);
        setc(color);

        GOTO_XY(check->xpos, check->ypos+x);
        if(BitTst(check->bi.n.ni, x))
          outchr(check->check_char);
        else
          outchr(check->fill_char);
      }
      ++x;
    }
  }


  if(mode==COMMON_CURRENT)
  {
    info->xpos=check->xpos;
    info->ypos=check->ypos+check->pos;
    GOTO_XY(info->xpos, info->ypos);
  }

  setc(savecolor);
}



void redrawshowtext(int redraw, showtextrec *text, varimenuinfo *info, int mode)
{
  int savecolor=curatr;
  int color;

  strncpy(text->show, text->text, text->amount_to_show);
  text->show[text->amount_to_show]=0;

  justify_string(text->show, text->amount_to_show, text->bg, text->justify);

  color = (mode == COMMON_INACTIVE ? info->inactive_color : mode == COMMON_ITEM ? info->mi_normal : info->ci_normal);
  if(color!=text->cur_color)
    redraw=COMMON_FULL;
  text->cur_color=color;

  if(redraw!=COMMON_NONE)
  {
    setc(color);

    GOTO_XY(text->xpos, text->ypos);
    outstr(text->show);
  }

  if(mode==COMMON_CURRENT)
  {
    info->xpos=text->xpos;
    info->ypos=text->ypos;
    GOTO_XY(info->xpos, info->ypos);
  }

  setc(savecolor);
}

void showtext(showtextrec *text, varimenuinfo *info)
{

  if(info->redraw!=COMMON_NONE)
    redrawshowtext(info->redraw, text, info, COMMON_CURRENT);

  info->event=get_kb_event();
  return;
}

void build_showtextrec(showtextrec *text, int xpos, int ypos, int width, char *t, int justify, int bg)
{
  memset(text, 0, sizeof(showtextrec));

  text->xpos=xpos;
  text->ypos=ypos;
  text->amount_to_show=width;
  text->curxpos=xpos;
  text->curypos=ypos;

  text->justify=justify;
  text->bg=bg;

  text->text=(char *)malloc(width+1);
  strncpy(text->text, t, width);
  text->text[width]=0;

  text->show=(char *)malloc(width+1);
}




#ifdef TEST_VM
void test_vm(void)
{
  inputeditrec input1, input2;
  showtextrec text1, text2;

  varimenurec *menu=NULL, newmenu;
  varimenuinfo info={YELLOW+(BLUE<<4), RED+(BLUE<<4), BLACK+(CYAN<<4), RED+(CYAN<<4), DARKGRAY+(BLUE<<4),
                     COMMON_FULL, 0, 0, 0, 0, 0};
  int done=0;

  enum TEST_STUFF
  {
    LOGON,
    CHAT,
    EMAIL,
    GOODBYE
  };


  build_showtextrec(&text1, 5, 5, 17, "Logon", JUSTIFY_CENTER, '');
  fillvarimenurec(&newmenu, &text1, SHOW_TEXT_TYPE, 0, LOGON, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_showtextrec(&text2, 5, 7, 17, "GoodBye", JUSTIFY_CENTER, '');
  fillvarimenurec(&newmenu, &text2, SHOW_TEXT_TYPE, 0, GOODBYE, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);

  build_inputrec(&input1, 30, 5, 9, 17, 1, IE_MIXED);
  fillvarimenurec(&newmenu, &input1, INPUT_EDIT_TYPE, 0, CHAT, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);


  build_inputrec(&input2, 30, 5, 11, 17, 1, IE_PROPPER);
  fillvarimenurec(&newmenu, &input2, INPUT_EDIT_TYPE, 0, EMAIL, COMMON_ACTIVE);
  menu=addvarimenu(menu, &newmenu);


  // Print out ansi or prep screen in other way
  CLS();

  while(!done && !hangup)
  {
    varimenu(menu, &info);

    switch(info.event)
    {
      case EXECUTE:
        switch(info.returnvalue)
        {
          case GOODBYE:
          case GET_OUT:
            done=1;
            break;
          default:
            info.redraw=COMMON_NONE;
            break;
        }
        break;

      case GET_OUT:
        done=1;
        break;

      default:
        info.redraw=COMMON_NONE;
        break;
    }

  }

  killvarimenu(menu);
  CLS();
}
#endif   // end ifdef test_var




// Waits amount of secs, or until a key is hit
void wait_sec_or_hit(double seconds)
{
  time_t time1;
  time_t time2;

  time(&time1);
  time(&time2);

  if( seconds == 1 )
    ++seconds;

  while(difftime(time2,time1) < seconds && !hangup && !comhit() && !kbhit())
    time(&time2);
}

// Waits for 'seconds' seconds, does not exit on comhit
void wait_sec(double seconds)
{
  time_t time1;
  time_t time2;

  time(&time1);
  time(&time2);

  if( seconds == 1 )
    ++seconds;

  while(difftime(time2,time1) < seconds && !hangup)
    time(&time2);
}


long filesize(FILE *stream)
{
  long curpos, length;
  
  curpos=ftell(stream);
  
  fseek(stream, 0L, SEEK_END);
  length=ftell(stream);
  
  fseek(stream, curpos, SEEK_SET);
  
  return length;
}



int fset_rec(FILE *stream, unsigned rec, unsigned rec_size)
{
  int error;
  
  error = fseek(stream, (long) ((rec)*((long)rec_size)), SEEK_SET);

  
  if(error)
    ; // Could not set rec
    
  return(!error);
}

int set_rec(int filenum, unsigned rec, unsigned rec_size)
{
  int error;
  
  error = sh_lseek(filenum, (long) ((rec)*((long)rec_size)), SEEK_SET);

  
  if(error)
    ; // Could not set rec
    
  return(!error);
}



// #define check_ar(which) check_bitfield(thisuser.ar, (which))
// #define check_dar(which) check_bitfield(thisuser.dar, (which))
// These are defined in COMMON.H, example calls:
//
// if(check_ar("CDF"))  (or if(check_dar("GA"))
//   do_whatever();
//
// It will return TRUE (1) if all bits specified in paremater 'which' are set
// Say in check_ar("CDF"), if the user has CD, but not F specified, then FALSE
// (0) is returned/
//
// To use check_bitfield, you must specify the bitfield you are checking, and
// you must specify bit 'A' as the first bit, 'B' as the second... on up to 'P'
// as your 16th bit, and paremater 'which' is used just as above
//
// if(check_bitfield(thisuser.restrict, "AC"))
//   annoy_user_a_little();
//
// Should make checking bit fields for novice users, as well as everyone else
// alot easier

int check_bitfield(unsigned bitfield, char *which)
{
  unsigned total=0, bit, temp;
  int x=0, y;

  strupr(which);

  while((y=which[x])!=0)
  {
    // There IS error detection for if you specify the same bit field
    // twice, or if you specify something other than A-P
    if(y>='A' && y <= 'P')
    {
      bit=1 << (y-'A');
      // Make sure that this bit has not already been set
      if(!(total&bit))
        total+=bit;
    }
    ++x;
  }

  temp=bitfield & total;
  if(temp==total)
    return 1;
  return 0;
}


#ifdef TEST_BITFIELD
void test_check_bitfield(void)
{
  int done=0;
  char s[17];

  while(!done)
  {
    pl("Enter alpha style bit field to check against thisuser.ar");
    input(s, 16);

    if(s[0])
    {
      if(check_ar(s))
        pl("You have the specified bits");
      else
        pl("You DON'T have the specified bits");
    }
    else
      done=1;
  }
}
#endif


int check_arc(char *filename)
{
  char header[10];
  char *ext;
  int file;


  file=sh_open1(filename, O_RDONLY);

  if(file<0)
    return(COMPRESSION_UNKNOWN);

  sh_lseek(file, 0, SEEK_SET);
  sh_read(file, (void *)&header, 10);

  sh_close(file);

  switch(header[0])
  {
    case 0x60:
      if((unsigned char)header[2]==(unsigned char)0xEA)
        return(COMPRESSION_ARJ);

      break;

    case 0x1a:
      return(COMPRESSION_PAK);

    case 'P':
      if(header[1]=='K')
        return(COMPRESSION_ZIP);

      break;

    case 'Z':
      if(header[1]== 'O' && header[2] == 'O')
        return(COMPRESSION_ZOO);

      break;

    default:

      if(strstr(header, "-lh"))
        return(COMPRESSION_LHA);

      // Guess on type, using extension to guess
      ext=strstr(filename, ".");

      if(ext)
      {
        ++ext;

        if(stricmp(ext, "ZIP")==0)
          return(COMPRESSION_ZIP);

        if(stricmp(ext, "LHA")==0)
          return(COMPRESSION_LHA);

        if(stricmp(ext, "LZH")==0)
          return(COMPRESSION_LHA);

        if(stricmp(ext, "ZOO")==0)
          return(COMPRESSION_ZOO);

        if(stricmp(ext, "ARC")==0)
          return(COMPRESSION_PAK);

        if(stricmp(ext, "PAK")==0)
          return(COMPRESSION_PAK);

        if(stricmp(ext, "ARJ")==0)
          return(COMPRESSION_ARJ);

        return(COMPRESSION_UNKNOWN);
      }
  }
  return(COMPRESSION_UNKNOWN);
}

// Returns which archive as a number in your archive config
// Returns the first archiver you have listed if unknown
// One thing to note, if an 'arc' is found, it uses pak, and returns that
// The reason being, PAK does all ARC does, plus a little more, I belive
// PAK has its own special modes, but still look like an ARC, thus, an ARC
// Will puke if it sees this
int match_archiver(char *filename)
{
  int x=0;
  char type[4];

  x=check_arc(filename);

  if(x==COMPRESSION_UNKNOWN)
    return 0;


  switch(x)
  {
    case COMPRESSION_ZIP:
      strcpy(type, "ZIP");
      break;

    case COMPRESSION_LHA:
      strcpy(type, "LHA");
      break;

    case COMPRESSION_ARJ:
      strcpy(type, "ARJ");
      break;

    case COMPRESSION_PAK:
      strcpy(type, "PAK");
      break;

    case COMPRESSION_ZOO:
      strcpy(type, "ZOO");
      break;
  }

  x=0;

  while(x<4)
  {
    if(stricmp(type, syscfg.arcs[x].extension)==0)
      return x;

    ++x;
  }

  return 0;
}



long file_daten(char *filename)
{
  int fn;

  struct ftime file;
  struct time  dtime;
  struct date  ddate;


  fn = sh_open1(filename, O_RDONLY);
  if (fn != -1)
  {
    getftime(fn, &file);
    fn=sh_close(fn);

    dtime.ti_hund = 0;
    dtime.ti_min = file.ft_min;
    dtime.ti_hour = file.ft_hour;
    dtime.ti_sec = file.ft_tsec * 2;
    ddate.da_year = file.ft_year + 1980;
    ddate.da_day = file.ft_day;
    ddate.da_mon = file.ft_month;

    return(dostounix(&ddate, &dtime));
  }
  return 0;
}




void build_inputpicrec(inputpicrec *input, int xpos, int ypos, int width, int insert, char *picture)
{
  memset(input, 0, sizeof(inputpicrec));

  input->pos=0;
  input->curlen=0;
  input->first=0;
  input->xpos=xpos;
  input->ypos=ypos;
  input->amount_to_show=width;
  input->curxpos=xpos;
  input->curypos=ypos;
  input->insert=insert;
  input->curmode=-1;
  input->show=(char *)malloc(width+5);
  memset(input->show, 0, width);
//  input->picture=get_picture(picture, input->maxlen);
  if(picture!=picture)
    picture=picture;
  input->text=(char *)malloc(input->maxlen+1);
  memset(input->text, ' ', input->maxlen+1);

}

void kill_inputpic(inputpicrec *input)
{
  free(input->text);
  free(input->show);

  if(input->picture)
    free(input->picture);
}

void input_picture(inputpicrec *input, varimenuinfo *info)
{
  if(info->redraw!=COMMON_NONE)
    redrawinputpic(info->redraw, input, info, COMMON_CURRENT);

  while(1)
  {
    info->event=get_kb_event();
    input->bs=FALSE;

    switch(info->event)
    {
      case COMMAND_LEFT:
        if(input->pos)
        {
          --input->pos;
          redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;
        
      case COMMAND_RIGHT:
        if(input->pos<input->curlen)
        {
          ++input->pos;
          redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_HOME:
        if(input->pos!=0)
        {
          input->pos=0;
          redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_END:
        if(input->pos!=input->maxlen)
        {
          input->pos=input->curlen;
          redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case BACKSPACE:
        if(input->pos)
        {
          --input->pos;
          input->text[input->pos]=' ';
          redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        }
        info->event=0;
        return;

      case COMMAND_DELETE:
        input->text[input->pos]=' ';
        redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);
        info->event=0;
        return;

      case COMMAND_STAB:
      case TAB:
        return;

      default:

        if(ok_char_inputpic(input, info))
        {
          input->text[input->pos]=info->event;
          ++info->pos;
          redrawinputpic(COMMON_PARTIAL, input, info, COMMON_CURRENT);

          info->event=0;
          return;
        }
        else
          return;
    }
  }
}

int ok_char_inputpic(inputpicrec *input, varimenuinfo *info)
{
  unsigned event;

  event=info->event;

  if(event >= ' ' && event < 255)
    return 1;

  // Cut off warning until I expand this function
  if(input!=input)
    input=input;

  return 0;
}


char ** read_picture(char *picture)
{
  int amount;
  int pos=0;
  int x, done=0;
  int next=0;


  while(!done)
  {

    x=picture[pos];

    if(!x)
      break;

    switch(x)
    {
      case '!': // Execlude
        next=1;
        ++pos;
        break;

      case '[': // Start range
        while(x!=']' && x)
        {
          ++pos;
          x=picture[pos];
        }
        next=0;
        break;

      case '@': // Predefined type
        next=1;
        ++pos;
        break;

      case '~': // Force next char
        ++pos;
        if(picture[pos])
          ++pos;

        next=0;
        break;

      default:
        next=0;
        ++pos;
        break;
    }

    if(next)
      ++amount;

  }

  return NULL;
}






void redrawinputpic(int type, inputpicrec *input, varimenuinfo *info, int mode)
{
  int savecolor=curatr;

  if(input->pos < input->first)
  {
    input->first=input->pos - (input->amount_to_show/2);
    if(input->first<0)
      input->first=0;

    type=COMMON_FULL;
  }
  else if(input->pos - input->first > input->amount_to_show)
  {
    input->first=input->pos - (input->amount_to_show/2);
    if(input->first > input->maxlen)
      input->first=input->maxlen;
    type=COMMON_FULL;
  }
  else if(input->curmode!=mode)
    type=COMMON_FULL;

  input->curmode=mode;

  input->curxpos=input->xpos+(input->pos-input->first);
  input->curypos=input->ypos;

  if(type==COMMON_FULL)
  {
    strncpy(input->show, input->text+input->first, input->amount_to_show);
    input->show[input->amount_to_show]=0;

    pad_string(input->show, input->amount_to_show);
    GOTO_XY(input->xpos, input->ypos);
    setc(mode==COMMON_INACTIVE ? info->inactive_color : mode ==COMMON_ITEM ? info->mi_normal : info->ci_normal);

    if(IE_PASSWORD & input->char_case)
      echo=0;
    else
      echo=1;
    outstr(input->show);
  }
  else if(type==COMMON_PARTIAL)
  {
    int where = input->first+(input->pos-input->first);
    int a=input->amount_to_show-(input->pos-input->first)+1;

    if(input->pos!=input->first)
    {
      strncpy(input->show, input->text+where-1, a+1);
      input->show[a]=0;
      input->show[input->amount_to_show]=0 ;

      if(input->bs && strlen(input->show) != input->amount_to_show)
        strcat(input->show, " ");

      GOTO_XY(input->xpos + input->pos - input->first - 1, input->ypos);
    }
    else
    {
      strncpy(input->show, input->text+where, a);
      input->show[a]=0;
      input->show[input->amount_to_show]=0;

      if(input->bs && strlen(input->show) != input->amount_to_show)
        strcat(input->show, " ");

      GOTO_XY(input->xpos + input->pos - input->first, input->ypos);
    }
    setc(mode==COMMON_INACTIVE ? info->inactive_color : mode ==COMMON_ITEM ? info->mi_normal : info->ci_normal);

    if(IE_PASSWORD & input->char_case)
      echo=0;
    else
      echo=1;
    outstr(input->show);
  }
  else if(type==COMMON_NONE)
  {
  }
  else
  {
    sysoplog("Undefined update type in function redrawinputpic");
  }


  if(mode==COMMON_CURRENT)
  {

    info->xpos=input->xpos + input->pos - input->first;
    info->ypos=input->ypos;
    GOTO_XY(info->xpos, info->ypos);
  }

  input->bs=FALSE;
  setc(savecolor);
}

/* ********************************************************************** */
/* Asylum INI Code (Part of COMMON) - by Michael Deweese Copyright 1994   */
/*                                                                        */
/* You may use this code in WWIV as installed under the COMMON.MOD file   */
/* You may not use this code in your own programs without the consent of  */
/* Michael Deweese.                                                       */
/* You can call these functions from your own WWIV modifications, but may */
/* not rip these out and include them in your mod.  In other words, to    */
/* access these functions, the user using your modification must have     */
/* mod installed                                                          */
/*                                                                        */
/*                                                                        */
/* USAGE:                                                                 */
/*    There are two basic ways to make use of these ini functions, the    */
/*    first and most simple is two call two high level functions that take*/
/*    care of all the work, they are:                                     */
/*                                                                        */
/*    get_ini_value                                                       */
/*    put_ini_value                                                       */
/*                                                                        */
/*    These two functions will open up the ini file, read it into memory, */
/*    do any modifications to it, as needed, and then write it back to    */
/*    disk.  Now this is on every single call, and thus, might be kind of */
/*    slow on large ini readings                                          */
/*                                                                        */
/*    eg                                                                  */
/*                                                                        */
/*    (Start ASYLUM.INI)                                                  */
/*    [LISTPLUS]                                                          */
/*    bar_color = 8                                                       */
/*    other_color = 5                                                     */
/*                                                                        */
/*    char s[10];                                                         */
/*    strcpy(s, "7");    // 7 to be used as a default if bar_color        */
/*                       // doesn't exist                                 */
/*    get_ini_value("ASYLUM.INI", "listplus", "bar_color", s, 10);        */
/*                                                                        */
/*    // s now equals "8"                                                 */
/*                                                                        */
/*    strcpy(s, "Zu Digital"                                              */
/*    get_ini_value("ASYLUM.INI", "Super Config", "WHO", s, 10);          */
/*                                                                        */
/*    // [Super Config] didn't exist, so it was created, likewise, WHO    */
/*    // didn't exist, so a 'WHO = Zu Digital' was added                  */
/*                                                                        */
/*                                                                        */
/*    strcpy(s, "1");                                                     */
/*    put_ini_value("ASYLUM.INI", "ListPlus", "other_color", s);          */
/*                                                                        */
/*    // other_color already existed in section [ListPlus], so it was     */
/*    // removed and replaced with other_color = 1                        */
/*                                                                        */
/*                                                                        */
/* Again, that reads and writes after every single call, if you need to   */
/* do alot of reading, then a little code such as the following is what   */
/* you want...                                                            */
/*                                                                        */
/*                                                                        */
/*  ini_inforec ini_info;                                                 */
/*  char s[10];                                                           */
/*                                                                        */
/*  // Read ini file into memory                                          */
/*  if(!open_ini_file("ASYLUM.INI", &ini_info))                           */
/*    return -1;    // Wasn't able to retrieve or create fname.ini        */
/*                                                                        */
/*                                                                        */
/*  // this will read the values...                                       */
/*  strcpy(s, "15");                                                      */
/*  read_ini_string(&ini_info, "ListPlus", "Color", s, 10);                */
/*                                                                        */
/*  // This will overwrite previous color with new value                  */
/*  strcpy(s, "NONE");                                                    */
/*  set_ini_string(&ini_info, "ListPlus", "Color", s, 10);                 */
/*                                                                        */
/*  // Now write your changes to disk                                     */
/*  write_ini_file(&ini_info);                                            */
/*                                                                        */
/*  // And free your memory                                               */
/*  free_ini_info(&ini_info);                                             */
/*                                                                        */
/* ********************************************************************** */


int get_ini_value(char *fname, char *area, char *indent, char *value, int max_value)
{
  ini_inforec ini_info;

  if(!open_ini_file(fname, &ini_info))
    return -1;    /* Wasn't able to retrieve or create fname.ini */

  read_ini_string(&ini_info, area, indent, value, max_value);

  if(ini_info.changes_made)
    write_ini_file(&ini_info);   // value had to be added, so write it to disk

  free_ini_info(&ini_info);
  return 1;       /* Successful read */
}

int put_ini_value(char *fname, char *area, char *indent, char *value)
{
  ini_inforec ini_info;

  if(!open_ini_file(fname, &ini_info))
    return -1;    /* Wasn't able to retrieve or create fname.ini */

  set_ini_string(&ini_info, area, indent, value);
  write_ini_file(&ini_info);   // set_ini_string only sets the memory, it must
                               // be written to disk

  free_ini_info(&ini_info);
  return 1;       /* Successful read */
}

void free_ini_info(ini_inforec *ini_info)
{
  if(ini_info->ini)
    free(ini_info->ini);
}



int write_ini_file(ini_inforec *ini_info)
{
  FILE *fp;

  fp = fsh_open(ini_info->fname, "w+t");
  if(!fp)
    return 0;               /*  Couldn't create ini file */

  fseek(fp, 0, SEEK_SET);
  fsh_write((void *)ini_info->ini, 1, ini_info->fsize, fp);

  fsh_close(fp);
  return 1;
}

char *open_ini_file(char *fname, ini_inforec *ini_info)
{
  FILE *fp;

  memset((void *)ini_info, 0, sizeof(ini_inforec));
  strcpy(ini_info->fname, fname);

  fp = fsh_open(fname, "rt" );

  if(!fp)                        /* if it doesn't exist, create it */
  {
    fp = fsh_open(fname, "w+t");
    if(!fp)
      return NULL;               /*  Couldn't create ini file */
  }

  ini_info->fsize=filesize(fp);

  if(ini_info->fsize < 60000L)   /* Make 60,000 our file size */
    ini_info->ini = (char *) malloca(ini_info->fsize + EXTRA_INI_SPACE);

  if(!ini_info->ini)
  {
    fclose(fp);
    return NULL;
  }

  fseek(fp, 0, SEEK_SET);
  ini_info->fsize = fread((void *)ini_info->ini, 1, ini_info->fsize, fp);
  ini_info->ini[ini_info->fsize]=0;

  ini_info->allocated=ini_info->fsize + EXTRA_INI_SPACE;

  fsh_close(fp);
  return(ini_info->ini);
}

char * increase_ini_allocation(ini_inforec *ini_info)
{
  ini_info->allocated += EXTRA_INI_SPACE;

  if(ini_info->allocated > 0xffff)
    return NULL;

  ini_info->ini = (char *)realloc(ini_info->ini, ini_info->allocated);

  return(ini_info->ini);
}


void set_ini_string(ini_inforec *ini_info, char *area, char *indent, char *value)
{
  FILE *fp;
  char buff[255], *tmp, w1[128], w2[128];
  long area_start, pos, save_pos;
  int amount;


  /* If area == "" then don't bother with an [area] */
  if(area[0])
    area_start = find_ini_area(ini_info->ini, area);
  else
    area_start = ini_info->fsize;

  if(area_start >= ini_info->fsize)
  {

    if(area[0])
    {
      amount = sprintf(buff, "\n[%s]\n", area);

      if(ini_info->fsize + amount >= ini_info->allocated)
        if(!increase_ini_allocation(ini_info))
          return;

      strcat(ini_info->ini, buff);
      ini_info->fsize+= amount;
    }

    amount = sprintf(buff, "%s = %s\n", indent, value);

    if(ini_info->fsize + amount >= ini_info->allocated)
      if(!increase_ini_allocation(ini_info))
        return;

    strcat(ini_info->ini, buff);
    ini_info->fsize+= amount;

    ini_info->changes_made = 1;
    return;
  }


  pos = area_start;
  while(1)
  {
    save_pos = pos;
    tmp = get_ini_line(buff, 255, &pos, ini_info->ini);

    if(!tmp)
      break;

    strip_string(buff);

    if(buff[0]=='[')  // Star of a new area, so break
    {
      save_pos = area_start;    // Put value right after [area], comment out this line to put at end
      break;
    }
    break_up_ini(buff, w1, w2);

    if(strcmpi(w1, indent) == 0)
    {
      if(!w2[0])
        strcpy(w2, value);

      memmove(ini_info->ini + save_pos, ini_info->ini + pos, ini_info->fsize - pos+1);
      ini_info->fsize = ini_info->fsize - (pos - save_pos);
      break;
    }
  }

  amount = sprintf(buff, "%s = %s\n", indent, value);

  if(ini_info->fsize + amount >= ini_info->allocated)
    if(!increase_ini_allocation(ini_info))
      return;

  memmove(ini_info->ini+amount+save_pos, ini_info->ini+save_pos,
                               ini_info->fsize+amount-save_pos+1);
  strncpy(ini_info->ini+save_pos, buff, amount);
  ini_info->fsize += amount;

  ini_info->changes_made = 1;
  return;         // Value was updated
}

void set_ini_number(ini_inforec *ini_info, char *area, char *indent, long value)
{
  FILE *fp;
  char buff[255], *tmp, w1[128], w2[128];
  long area_start, pos, save_pos;
  int amount;


  /* If area == "" then don't bother with an [area] */
  if(area[0])
    area_start = find_ini_area(ini_info->ini, area);
  else
    area_start = ini_info->fsize;

  if(area_start >= ini_info->fsize)
  {

    if(area[0])
    {
      amount = sprintf(buff, "\n[%s]\n", area);

      if(ini_info->fsize + amount >= ini_info->allocated)
        if(!increase_ini_allocation(ini_info))
          return;

      strcat(ini_info->ini, buff);
      ini_info->fsize+= amount;
    }

    amount = sprintf(buff, "%s = %ld\n", indent, value);

    if(ini_info->fsize + amount >= ini_info->allocated)
      if(!increase_ini_allocation(ini_info))
        return;

    strcat(ini_info->ini, buff);
    ini_info->fsize+= amount;

    ini_info->changes_made = 1;
    return;
  }


  pos = area_start;
  while(1)
  {
    save_pos = pos;
    tmp = get_ini_line(buff, 255, &pos, ini_info->ini);

    if(!tmp)
      break;

    strip_string(buff);

    if(buff[0]=='[')  // Star of a new area, so break
    {
      save_pos = area_start;    // Put value right after [area], comment out this line to put at end
      break;
    }
    break_up_ini(buff, w1, w2);

    if(strcmpi(w1, indent) == 0)
    {
      memmove(ini_info->ini + save_pos, ini_info->ini + pos, ini_info->fsize - pos+1);
      ini_info->fsize = ini_info->fsize - (pos - save_pos);
      break;
    }
  }

  amount = sprintf(buff, "%s = %ld\n", indent, value);

  if(ini_info->fsize + amount >= ini_info->allocated)
    if(!increase_ini_allocation(ini_info))
      return;

  memmove(ini_info->ini+amount+save_pos, ini_info->ini+save_pos,
                               ini_info->fsize+amount-save_pos+1);
  strncpy(ini_info->ini+save_pos, buff, amount);
  ini_info->fsize += amount;

  ini_info->changes_made = 1;
  return;
}


long read_ini_number(ini_inforec *ini_info, char *area, char *indent, long value)
{
  char *ini, *tmp, buff[255], w1[128], w2[128];
  long fsize, area_start, pos;
  int amount;


  /* If area == "" then don't bother with an [area] */
  if(area[0])
    area_start = find_ini_area(ini_info->ini, area);
  else
    area_start = ini_info->fsize;

  if(area_start >= ini_info->fsize)
  {


    if(area[0])
    {
      amount = sprintf(buff, "\n[%s]\n", area);

      if(ini_info->fsize + amount >= ini_info->allocated)
        if(!increase_ini_allocation(ini_info))
          return -1;

      strcat(ini_info->ini, buff);
      ini_info->fsize += amount;
    }

    amount = sprintf(buff, "%s = %ld\n", indent, value);

    if(ini_info->fsize + amount >= ini_info->allocated)
      if(!increase_ini_allocation(ini_info))
        return -1;

    strcat(ini_info->ini, buff);
    ini_info->fsize += amount;


    ini_info->changes_made = 1;
    return(value);
  }



  pos = area_start;
  while(1)
  {
    tmp = get_ini_line(buff, 255, &pos, ini_info->ini);

    if(!tmp)          // No more lines
    {
      ini_info->changes_made = 1;
      set_ini_number(ini_info, area, indent, value);
      return 3;
    }

    strip_string(tmp);


    if(buff[0]=='[')  // Star of a new area
    {
      ini_info->changes_made = 1;
      set_ini_number(ini_info, area, indent, value);
      return 3;
    }

    break_up_ini(buff, w1, w2);

    if(strcmpi(w1, indent) == 0)
      return(atol(w2));
  }
}



int read_ini_string(ini_inforec *ini_info, char *area, char *indent, char *value, int max_value)
{
  char *ini, *tmp, buff[255], w1[128], w2[128];
  long fsize, area_start, pos;
  int amount;


  /* If area == "" then don't bother with an [area] */
  if(area[0])
    area_start = find_ini_area(ini_info->ini, area);
  else
    area_start = ini_info->fsize;

  if(area_start >= ini_info->fsize)
  {

    if(area[0])
    {
      amount = sprintf(buff, "\n[%s]\n", area);

      if(ini_info->fsize + amount >= ini_info->allocated)
        if(!increase_ini_allocation(ini_info))
          return 0;

      strcat(ini_info->ini, buff);
      ini_info->fsize += amount;
    }

    amount = sprintf(buff, "%s = %s\n", indent, value);

    if(ini_info->fsize + amount >= ini_info->allocated)
      if(!increase_ini_allocation(ini_info))
        return 0;

    strcat(ini_info->ini, buff);
    ini_info->fsize += amount;

    ini_info->changes_made = 1;
    return 2;                 /* Value was added, area was created */
  }



  pos = area_start;
  while(1)
  {
    tmp = get_ini_line(buff, 255, &pos, ini_info->ini);

    if(!tmp)          // No more lines
    {
      set_ini_string(ini_info, area, indent, value);
      return 3;
    }

    strip_string(tmp);

    if(buff[0]=='[')  // Star of a new area
    {
      set_ini_string(ini_info, area, indent, value);
      return 3;
    }

    break_up_ini(buff, w1, w2);

    if(strcmpi(w1, indent) == 0)
    {
      if(w2[0])
      {
        strncpy(value, w2, max_value);
        value[max_value]=0;
      }
      return 1;
    }
  }
}






char * get_ini_line(char *buff, int max_len, long *pos, char *ini)
{
  int c, buff_pos=0;
  char *temp;

  if(!ini[*pos])     // If at end of buffer, return NULL
    return NULL;

  while(1)
  {
    c = ini[*pos];

    if(c == 0 || c == '\n')
    {
      buff[buff_pos] = 0;
      if(c)    // Only increment if we are on a newline
        ++*pos;

      temp=strchr(buff, ';');
      if(temp)
        temp[0]=0;      // Null out all after ; (comment)

      return(buff);
    }

    buff[buff_pos] = c;

    ++buff_pos;
    ++*pos;

    if(buff_pos >= max_len)
    {
      buff[buff_pos] = 0;

      temp=strchr(buff, ';');
      if(temp)
        temp[0]=0;      // Null out all after ; (comment)

      return(buff);
    }
  }
}



void break_up_ini(char *buff, char *w1, char *w2)
{
  int pos=0, spos;
  int c;

  strip_string(buff);

  while(1)
  {
    c = buff[pos];

    if(c == '=' || c == 0)
    {
      buff[pos]=0;
      if(c)
        ++pos;
      break;
    }
    ++pos;
  }
  strcpy(w1, buff);

  spos=pos;

  while(1)
  {
    c = buff[pos];

    if(c == 0)
    {
      buff[pos] = 0;
      break;
    }

    ++pos;
  }

  strcpy(w2, buff+spos);

  strip_string(w1);
  strip_string(w2);
}


long find_ini_area(char *ini, char *area)
{
  char buff[255], *other_side, *tmp;
  long pos=0;

  if(!area[0])
    strlen(ini);

  while(1)
  {
    tmp = get_ini_line(buff, 255, &pos, ini);

    if(!tmp)
      return(pos);

    strip_string(buff);

    if(buff[0] != '[')
      continue;

    tmp=strchr(buff, ']');

    if(!tmp)
      return(pos);

    tmp[0]=0;

    if(strcmpi(buff+1, area) == 0)
      return(pos);

  }
}


