{$M $4000,0,655350}
{$X+,S+,R+}     {S,R should be turned off when compiling a final copy}
program test;
{
      This is just a small testing program for the COMMIO DOOR Kit.  It shows
      an example of how to setup the SIO routines, so you can communicate
      with the remote user.
      You can use this file as a basis to help you create your first door.
}
uses _exit, cmdline, crt, dos, mtask, commio, doorio, iniunit,
     dfunit, taskunit;

var
  ch:char;
  i:integer;
  v:Tinival;
  lastkey:boolean;

{}
Procedure init;
begin
  if paramstr(1)='' then terminate('SYSOP: you must put the "path\filename.ext" for the INI file on'#13#10+
                                   '       the command line.');
  {v- Read in INI file. }
  i:=OpenIni(paramstr(1));
  if i=ErrOk then with door do begin
    i:=GetIniVal('USEFOSSIL',Iniboolean,v);
    if v.bool then WhichIO:=fossilIO else WhichIO:=InternalIO;
    i:=GetIniVal('NODE',Inibyte,v);
    if i=ok then node:=v.b else node:=1;{ else terminate('"NODE" keyname not found in INI file!');}
    i:=GetIniVal('COMPORT',Inibyte,v);
    if i=ok then comport:=v.b else terminate('SYSOP: "COMPORT" keyname not found in INI file!');
    i:=GetIniVal('BAUDRATE',Inilongint,v);
    if i=ok then baudrate:=v.li else terminate('SYSOP: "BAUDRATE" keyname not found in INI file!');
    i:=GetIniVal('USEFIFOS',IniBoolean,v);
    if i=ok then ChangeFIFO(comport,v.bool);
    i:=GetIniVal('IRQ',Inibyte,v);
    if i=ok then if (v.b>0)and(v.b<16) then begin IRQ:=v.b; ChangeIRQ(comport,IRQ); end
      else terminate('SYSOP: Invalid IRQ given in INI file!');
    i:=GetIniVal('WORDSIZE',Inibyte,v);
    if i=ok then wordsize:=v.b else wordsize:=8;
    i:=GetIniVal('PARITY',Inistring,v);
    if i=ok then parity:=v.st[1] else parity:='N';
    i:=GetIniVal('STOPBITS',Inibyte,v);
    if i=ok then stopbits:=v.b else stopbits:=1;
    i:=GetIniVal('INBUFSIZE',IniInteger,v);
    if i=ok then inbufsize:=v.i else inbufsize:=512;
    i:=GetIniVal('OUTBUFSIZE',IniInteger,v);
    if i=ok then outbufsize:=v.i else outbufsize:=1024;
  end else terminate('SYSOP: INI file "'+paramstr(1)+'" not found!');
  CloseIni;

  {v- Pharse command line. }
  if ScanParam('/L',false) then door.comport:=0; {local mode}

  If not InitComport
    then terminate('SYSOP: No carrier detected on COM'+istr(door.comport,0)+'!')
    else door.online:=true;

{  if C_FifoOK[door.comport]
    then writeln('FIFO''s found!')
    else writeln('FIFO''s NOT found!');{}

  HideStatusBar;
  ShowStatusBar;
  InstallAllTasks;
end;
{}

var
  h,m,s,hs:word;
  f:text;
  st:string;
  c:char;
  l:longint;
  t:byte;
  x,y:byte;
begin
  init;

  textattr:=7;
  sioclrscr;

  InitVirtScr; {initialize virtual screen}
  putstr('|03bA simple test program written by Lief O''Pardy to test his new COMM routines!!|0.');
  putstr('3aThis is a basic CHAT program.  Supporting different color text for each user..|0');
  putstr('.3The sysop should try to use his local statusbar commands, at the same time the.');
  putstr('3user types in stuff.  They should both work at the same time, w/o messing up.');
  putstr('3anything the remote user is doing!.');
  putstr('Push <esc> to exit...');

{  MACROSTR:='^~J^~a^~s^~o^~n Morriss';{}
  setcolor(15,0); lastkey:=true;
  repeat
    ch:=sioreadkey;
{    if door.online=false then break;{}

    if (door.localkey)and(not lastkey) then begin
      lastkey:=true;
      setcolor(15,0);
    end else if (not door.localkey)and(lastkey) then begin
      lastkey:=false;
      setcolor(3,0);
    end;

    case ch of
      #8  : siowrite(#8' '#8);
      #13 : siowriteln('');
      #27 : {quit};
      '8','H' : siocursorup(1);     {siogotoxy(virtx,virty-1);}
      '2','P' : siocursordown(1);   {siogotoxy(virtx,virty+1);}
      '4','K' : siocursorleft(1);   {siogotoxy(virtx-1,virty);}
      '6','M' : siocursorright(1);  {siogotoxy(virtx+1,virty);}
      '|' : begin
        t:=textattr;
        DisplayAnsifile('test.ans',25);
        {^ this still does'nt do correct page breaks. it varies for each ansi.
           i have an idea of how to fix it, and i will sooner or later}
        textattr:=t;
      end;{}
      '!' : drawscr(virtscr,1,1,80,25);  {refresh the screen}
      {^- make sure you read the TODO.LST about the virtual routines}
      '~' : begin
        setcolor(7,0);
        door.usecolor:=not door.usecolor;
        if door.usecolor then siowriteln(#13#10'COLOR is now ON.')
          else siowriteln(#13#10'COLOR is now OFF.')
      end;{}
{      '@' : begin kickedout:=true; door.online:=false; end;}
      else siowritec(ch);
    end;

{    writestr(60,1,'WhereX: '+istr(virtx,2)+' ');
    writestr(60,2,'WhereY: '+istr(virty,2)+' ');
{    x:=wherex; y:=wherey;
    gotoxy(60,1);
    write('CTS stat:',CTSstat(door.comport));
    gotoxy(60,2);
    write('RTS stat:',RTSstat(door.comport));
    gotoxy(60,3);
    write('DSR stat:',DSRstat(door.comport));
    gotoxy(x,y);{}
  until (ch=#27);

{  freevirtscr;{called automatically}
{  DeInitComport;{this is done automatically after the program halts!}
end.