{$O+,F+}        {Overlay it to save memory... since this is basically only
                 used once in a program.}
unit INIunit;
{
          This unit is a companion to the COMMIO communications unit.
                Written by Jason Morriss a.k.a. Lief O'Pardy

                  Copyright (C) 1995,1996 by Jason Morriss
}
interface

uses dos,doorio;  {doorio for killextrablanks()}

type
  String30 = string[30];
  TiniVal = record (* INI values (when reading an INI file) *)
    case n:byte of
      1 : (st:string[222]); {should not be larger then 222}
      2 : (li:longint);
      3 : (w:word);
      4 : (i:integer);
      5 : (b:byte);
      6 : (si:shortint);
      7 : (bool:boolean);
  end;

const
  IniString   = 1;
  IniLongint  = 2;
  IniWord     = 3;
  IniInteger  = 4;
  IniByte     = 5;
  IniShortint = 6;
  IniBoolean  = 7;

const
  ErrOk        = 0;
  ErrNotFound  = 1;
  ErrDiskError = 2;
  ErrNoMemory  = 3;

  Ok           = 0;
  KeyNotFound  = 4;

Function OpenIni(filename:pathstr):byte;
{^ This prepares the INI file to be read from, and sets up a buffer for
   the reading of the keynames.  Returns one of the ERR codes shown above.
   (This tries to allocate at max, a 64k buffer but will use less if that
   much is not available).
   NOTE: until i create a "SetIniVal()" proc. this function will actually
         CLOSE the ini file, but will leave the buffer alone.  The CloseINI()
         procedure will only free the buffer, so you still must call that. }
Function GetIniVal(keyname:string30; valtype:byte; var val:TIniVal):byte;
{^ Get a value from the INI file.  This is called as many times as you need
   after you have OPENED the ini file with the above function.  OpenINI()
   loads all the keynames and thier values into MEMORY, so this function
   does not need to access the disk.
   Keyname : Search for this keyname string.
   valtype : What type of data are you looking for?
             1=string; 2=longint; 3=word; 4=integer; 5=byte; 6=shortint;
             7=boolean;
   val     : If Keyname was found then this holds the data, else its 0.  If
             the data that was found is invalid for the valtype you gave, a
             0 is returned in val. (ie: you want an WORD and the data
             found was "1024k" (w/o qoutes); that would return a 0 in val) }
Procedure CloseIni;
{^ Close the INI file.  This also Kills the buffer used by the keynames.
   (see note in description of OpenINI() function above) }
{
  INI file format & manageability:
  
  NOTES:
    The maximum number of Keynames allowed in a single INI file is 255
    Only the first 255 chars on a line are read, anymore are ignored
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Keynames:   Keynames must be ONE word and can consist of any character,
              except the following: [';',' ',#0..#31].  Keynames can be any
              length from 1 to 30 chars, if a keyname is any longer, the
              remaining chars will be ignored, so the following 2 keynames
              would have the same keyname according to these routines, and
              probably cause trouble while trying to read the ini file:
                This_is_my_30_character_keyname_#one=1
                This_is_my_30_character_keyname_#two=2
              All Keynames are automatically uppercased when read, so its
              not case sensitive.
  Delimiter:  The delimiter is what seperates the keyname from the value. ie:
              mykeyname=myvalue ;The "=" is the delimiter...
              as of now, only an "=" (equal-sign) may be used... But future
              versions will allow different delimiters and that tells the
              pharser how to read the "value".
  Value:      Values can have up to 222 chars on its line (after the
              delimiter).
              The Value comes right after the delimiter.  And can be any
              one of the following types:
              a String, longint, word, integer, byte, shortint, boolean.

              BOOLEAN values can be represented in a few different ways.
              values for TRUE : 'yes','on','1'
              values for FALSE: 'no','off','0'
              Boolean values do not use double quotes like strings below.
              (boolean values should NOT have quotes at all)

              STRING values should be enclosed in `"` (double quotes), the
              string itself can also have double quotes in it, w/o doing
              anything special. (ie: StrValue="This is my "Str" with its
              own double quotes '"'").  This is so that the strings in the
              ini file can have leading & trailing spaces, w/o the quotes
              those extra spaces would be deleted,  uhmmm, that probably just
              confused a bunch of people! don't worry 'bout it.

  (The keyname+delimiter+value do not have to be directly next to each other,
   ie: [mykey =   "this value"] is the same as: [mykey="this value"])

  Comments:   A Comment must be on its own line and start with a ";"
              (semi-colon).
              heres an example:
                ..
                ;Current HI Score (this line is completely ignored)
                hiscore=123456789
                ..
}

type
  Tinikey = record
    keyname : string30;
    value   : string[222];
    changed : boolean;
  end;
  TKeyArray = array[1..1] of Tinikey;

var
  INIval : ^TKeyArray;
  MaxKeynames : integer;
  NumKeys     : integer;

implementation

const
  INIisOpen : boolean = false;
var
  inivalsize : word;
  INIname : string[79];
  INIfile : text;

{}
Function OpenIni;
var
  ws : string;           {work string}
  tmpkey : Tinikey;      {temp keyname}
  ch : char;             {work char}
  i : integer;
begin
  If INIisOpen then exit;
  if filename='' then begin
    INIisOpen:=false;
    OpenIni:=ErrNotFound;
    exit;
  end;
{$I-}
  assign(inifile,filename);
  reset(inifile);
{$I+}
  i:=IOresult;
  if i>2 then i:=2;
  INIisOpen:=(i=0);
  OpenIni:=i;
  if INIisOpen then begin
    if MaxAvail>=65520
      then MaxKeynames:=65520 div sizeof(Tinikey)
      else MaxKeynames:=MaxAvail div sizeof(Tinikey);
    inivalsize:=MaxKeynames * sizeof(Tinikey);
    getmem(inival,inivalsize);
    fillchar(inival^,inivalsize,0);
    NumKeys:=0;
    INIname:=filename;
  end else exit;

  (* read in the INI file into the Keyname array *)
  While (not eof(inifile))and(NumKeys<MaxKeynames) do begin
    read(inifile,ws);
    KillExtraBlanks(ws);
    if (ws[1]=';')or(ws='') then begin      {if line is a comment or blank,}
      readln(inifile);                      { ignore it}
    end else begin                          {else proccess it}
      i:=1;
      fillchar(tmpkey,sizeof(tmpkey),0);
      {v- read until a delimiter or blank is found}
      while not (ws[1] in ['=',' '])and(i<31) do begin
        tmpkey.keyname:=tmpkey.keyname+upchar(ws[1]);
        inc(i);
        delete(ws,1,1);
      end;
      {v- incase keyname was more then 1 word, or delimiter was spaced away}
      while not (ws[1] in ['='])and(ws<>'') do delete(ws,1,1);

      {v- read in value}
      if ws<>'' then begin
        ch:=ws[1];
        delete(ws,1,1);
        while(ws[1]=' ') do delete(ws,1,1);
        i:=1;
        {v- value is read differently depending on delimiter}
        case ch of
          '=' : begin
{            while (ws<>'')and(i<223) do begin{}
              tmpkey.value:=upcasestr(ws);
              ws:='';
{              tmpkey.value:=tmpkey.value+ws[1];
              inc(i);
              delete(ws,1,1);
            end;{}
            inc(NumKeys);
            inival^[NumKeys]:=tmpkey;
          end;
        end; {of case}
      end;
      readln(inifile);
    end;
  end;
{$I-}
  close(inifile);
{$I+}
end;
{}
Function GetIniVal;
var key:integer; s:string; c:integer;
begin
  if Not INIisOpen then exit;
  keyname:=UpCaseStr(keyname);
  key:=0;
  repeat inc(key); until (inival^[key].keyname=keyname)or(key>NumKeys);

  if inival^[key].keyname=keyname then begin
    s:=inival^[key].value;
    case valtype of
      1 : begin
        if (s[1]='"')and(s[length(s)]='"')and(length(s)>1) then begin
          delete(s,1,1);
          delete(s,length(s),1);
        end;
        val.st:=s;
      end;
      2 : system.val(s,val.li,c);
      3 : system.val(s,val.w,c);
      4 : system.val(s,val.i,c);
      5 : system.val(s,val.b,c);
      6 : system.val(s,val.si,c);
      7 : begin
        s:=upcasestr(s);
        if (s='ON')or(s='1')or(s='YES')
          then val.bool:=true
          else val.bool:=false;
      end;
    end;
    GetIniVal:=Ok;
  end else begin {keyname was not found}
    fillchar(val,sizeof(val),0);
    GetIniVal:=KeyNotFound;
  end;
end;
{}
Procedure CloseIni;
begin
  if Not INIisOpen then exit;
  INIisOpen:=false;
  freemem(inival,inivalsize);
{  close(inifile);{}
end;
{}
end.