{$G+,A+}
Unit FOSUnit;
{
          This unit is a companion to the COMMIO communications unit.
                Written by Jason Morriss a.k.a. Lief O'Pardy

                  Copyright (C) 1995,1996 by Jason Morriss
}
Interface

Function  F_Init(Comport: Byte) : boolean;
Procedure F_Close(Comport: Byte);
Procedure F_Parms(Comport: Byte; Baud: Word; DataBits: Byte; Parity: Char; StopBit: Byte);
Procedure F_SendChar(Comport: Byte; C: Char);   {this DOES wait}
Procedure F_Write(Comport: Byte; S: String);    {""}
Procedure F_Writeln(Comport: Byte; S: String);  {""}
Function  F_ReadChar(Comport: Byte) : Char;
Procedure F_Dtr(Comport: Byte; State: Boolean);
Procedure F_Flow(Comport: Byte; State: Boolean);
Function  F_CD(Comport: Byte) : Boolean;
Procedure F_Kill_Out(Comport: Byte);
Procedure F_Kill_In(Comport: Byte);
Procedure F_Flush(Comport: Byte);
Function  F_Avail(Comport: Byte) : Boolean;
Function  F_OkToSend(Comport: Byte) : Boolean;
Function  F_Empty(Comport: Byte) : Boolean;


Implementation

{}
Function F_Init(Comport: Byte):boolean; assembler;
asm
  mov  ah,4
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  xor  bx,bx
  int  14h

  cmp  ax,1954h
  jne  @@no
@@yes:
  mov  al,1
  jmp  @@exit
@@no:
  xor  al,al
@@exit:
end;
{}
Procedure F_Close(Comport: Byte); assembler;
asm
  mov  ah,5
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
end;
{}
Procedure F_Parms(ComPort: Byte; Baud: word; DataBits: Byte; Parity: Char;
                  StopBit: Byte);
var c:byte;
begin
  if baud=0 then exit;
  c:=0;

  c:=(databits-5);                           {000000xx}
  c:=c or ((stopbit-1)shl 2);                {00000x00}

  Case upcase(Parity) of                     {000xx000}
{   'N': c:=c or $00;}
    'O': c:=c or $08;
    'E': c:=c or $18;
  end;

  Case Baud of                               {xxx00000}
    19200: c:=c or $00;  {0000-0000}
    38400: c:=c or $20;  {0010-0000}
    300  : c:=c or $40;  {0100-0000}
    600  : c:=c or $60;  {0110-0000}
    1200 : c:=c or $80;  {1000-0000}
    2400 : c:=c or $A0;  {1010-0000}
    4800 : c:=c or $C0;  {1100-0000}
    9600 : c:=c or $E0;  {1110-0000}
    else if baud>38400 then c:=c or $20;
  end;

  asm
    xor  ah,ah;
    mov  al,[c];
    mov  dl,[comport]
    xor  dh,dh
    dec  dx;
    int  14h;
  end;
end;
{}
Procedure F_Dtr(Comport: Byte; State: Boolean); assembler;
asm
  mov  ah,6
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  mov  al,[state]
  int  14h
end;
{}
Function F_CD(Comport: Byte) : Boolean; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h

  mov  bl,al
  xor  al,al
  and  bl,80h
  cmp  bl,80h
  jne  @@exit
  inc  al
@@exit:
end;
{}
Procedure F_Flow(Comport: Byte; State: Boolean); assembler;
asm
  mov  ah,0Fh
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  xor  al,al
  cmp  [state],0
  je   @@off
  mov  al,255
@@off:
  int  14h
end;
{}
Procedure F_Kill_Out(Comport: Byte); assembler;
asm
  mov  ah,9
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
end;
{}
Procedure F_Kill_In(Comport: Byte); assembler;
asm
  mov  ah,10
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
end;
{}
Procedure F_Flush(Comport: Byte); assembler;
asm
  mov  ah,8
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
end;
{}
Function  F_Avail(Comport: Byte) : Boolean; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
  and  ah,1
  mov  al,ah
end;
{}
Function  F_OkToSend(Comport: Byte) : Boolean; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
  and  ah,20h
  shr  ah,5
  mov  al,ah
end;
{}
Function  F_Empty(Comport: Byte) : Boolean; assembler;
asm
  mov  ah,3
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h
  and  ah,40h
  shr  ah,6
  mov  al,ah
end;
{}
Procedure F_SendChar(Comport: Byte; C: Char); assembler;
asm
  mov  ah,1
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  mov  al,[c]
  int  14h
end;
{}
Procedure F_Write(Comport: Byte; S: String);
Var
  i: Byte;
begin
  For i := 1 to Length(S) do F_SendChar(Comport,S[i]);
end;
{}
Procedure F_Writeln(Comport: Byte; S: String);
begin
  F_Write(comport,s);
  F_SendChar(ComPort,#13);
  F_SendChar(ComPort,#10);
end;
{}
Function F_ReadChar(Comport: Byte) : Char; assembler;
asm
  mov  ah,2
  mov  dl,[comport]
  xor  dh,dh
  dec  dl
  int  14h  {al=char}
end;
{}


end.

