{$X+}
unit DOORIO;
{
          This unit is a companion to the COMMIO communications unit.
                Written by Jason Morriss a.k.a. Lief O'Pardy

                  Copyright (C) 1995,1996 by Jason Morriss

  This unit has a group of procedures and functions for getting input from
  the user in various ways, and writting text in various ways, including
  some animation.
  Some of the following routines CAN NOT be used over the modem since there's
  no way to "TELL" the other computer how to do it.  They are here because
  this unit used to be my own IO unit for my "normal" programs, i just
  converted it for these DOOR routines, and then added more routines
  ... enjoy.
}
INTERFACE

uses crt, commio;

Type
  TCharSet = Set of Char;
  Tauto = (noauto,upper,lower,smart);
  Twriter = (nofx,wipe1,fadein,fadeout);
Var
  Pause_Proc: procedure(s:string);
{  More_Proc : function(s:string;chs:tcharset):TMoreResults;}
Const Charset : tcharset = [#32..#232,#234..#255];
Const NumSet  : tcharset = ['0'..'9','-'];
Const
{  pausestr  : string[100] = '|1B <PAUSE> |0';
  pausestrl : byte = 9;{}
  inserton  : boolean = false;
{--[v- how the string is displayed with putstr/xy() ]--}
  writer    : Twriter = nofx;
  dlay      : array[Twriter] of word = (0,10,100,100);
{--[v- if true Getstr() will echo "secretchar" (used for passwords) ]--}
  secret    : boolean = false;
  secretchar: char = '';
{--[v- The Getstr() string will be filtered according to Tauto ]--}
  autocaps  : Tauto = noauto;
{--[v- if true input will be highlighted according to the const BGCol,
       when using most input routines                                  ]--}
  highlight : boolean = true;
{--[v- These are the allowable exit keys for getstr(): ]--}
  normalexitkeys : tcharset = [#27,#13];    {esc, enter}
{--[v- Extended keys are the ones who send #0 first, then the scancode ]--}
  extendedexitkeys : tcharset = [];

  FGCol   : Byte = 15;  {white}       { Fg color for most input routines }
  BGCol   : Byte = 1;   {blue}        { Bg color for most input routines }

  DVseg   : word = $B800;  {.$B800=color; $B000 for mono}
  DVofs   : word = $0000;  {the ofs is needed incase i/you create routines
                            that will write to a virtual page, virtual pages
                            will not always start at 0000.}

const
  nomemory     = 1;
  filenotfound = 2;

procedure terminate(s:string);
{^ Halts the program with the Error String "s". }
function CommaInt(number:longint):string;
{^ Inserts comma's into a number and returns a string of the number with the
   commas. ie: s:=Commint(1000000); (* s='1,000,000' *) Makes Larger numbers
   easier to read. }
function padFstr(s:string; ch:char; len:byte):string;
{^ Pad the front of the string with CH, up to LEN. }
function padEstr(s:string; ch:char; len:byte):string;
{^ Pad the end of the string with CH, up to LEN. }
function istr(n:longint; pad:byte):string;
{^ converts a number to a string.
     pad = how many 0's will be padded in front of the string, to make
           the number a certain length. ie: istr(45,3) = '045'}
function sint(s:string):longint;
{^ converts a string to a number.  if the string is invalid, 0 is returned. }
function CSLen(s:string):byte;
{^ returns the length of the string, not including any of the "" control
   codes. }
function UpChar(Ch:Char):Char;
{^ converts the Char to upper case.  this also supports some foreign chars. }
function LowChar(Ch:Char):Char;
{^ converts the char to lower case.  "     "    "        "   "        ". }
function UpCaseStr(s:string):string;
{^ conerts a string to upper case; uses Upchar. }
function LowCaseStr(s:string):string;
{^ converts a string to lower case; uses Lowchar. }
function SmartCaseStr(s:string):string;
{^ converts a string to a PROPERLY capitalized string.  only useful for
   names.  ie: "jasON moRRisS" = "Jason Morriss". }
procedure hidecursor;
{^ LOCAL ONLY: turns the cursor off; you can't see it on the screen, but its
   still there. }
procedure showcursor;
{^ LOCAL ONLY: turns the cursor on, if it was off. }
{function whereX:byte;
{^ LOCAL ONLY: returns the X position of the cursor.  This is just like TP's
   WhereX, except it is NOT window relitive. }
{function whereY:byte;
{^ LOCAL ONLY: returns the Y position of the cursor.  This is just like TP's
   WhereY, except it is NOT window relitive. }
procedure SetCursorSize(Top,Bot:Byte);
{^ LOCAL ONLY: Set the size of the cursor.  top=top scanline; bot=bottom
   scanline of cursor.  Both in the range of 1..8.  (7,8)="normal" cursor,
   (1,8)=block cursor... }
procedure KillBlanks(var s:string);
{^ Kills ALL blanks in the string. }
procedure KillExtraBlanks(var s:string);
{^ Kills any blanks in FRONT of, and at the END of the string. }
function AreYouSureY : char;
{^ Special procedure.  Displays a colored "[Y,n]" prompt and returns when the
   user presses either: 'Y','N',<enter>.  If <enter> is pressed then 'Y' is
   returned. }
function AreYouSureN : char;
{^ Special procedure.  Displays a colored "[y,N]" prompt and returns when the
   user presses either: 'Y','N',<enter>.  If <enter> is pressed then 'N' is
   returned. }
procedure GetPW(var st:string; len:byte);
{^ Special procedure.  Get a password from the user.  the character echoed
   is in the "secretchar" variable above. }
procedure GetInt(var num:longint; hotkey:boolean; l:longint; h:longint);
{^ Special procedure.  Get a number from the user.  l=lowest # allowed,
   h=highest # allowed.  If hotkey is true then the user will not always
   have to push enter after entering the number.  example:  if you want to
   get a number in the range of 1 to 500 and the user enters 325 then he/she
   won't have to hit enter, it will return the 325, since if the user were to
   enter ANY other number after the 5 (in 325) then the number would be
   larger then the maximum you set of 500.  But if the user enters something
   like 20 then he/she will have to push enter.  otherwise it will wait until
   the user pushes enter, to return the value.  got it?  negitive numbers are
   allowed also. }
function HotKey(CharSet:TCharSet):char;
{^ Special procedure.  Get A char from the user.  CharSet is the set of
   allowable characters to be pressed, any other character not in this
   set is ignored.  As soon as one of the allowed chars is read, it returns
   that char.  This does not echo any characters. }
function GetStr(var DestStr:String; MaxLen:Byte; CharSet:TCharSet):char;
{^ Get a string from the user.  If DestStr is not empty then the user starts
   with that string, and the cursor starts at the end of the string (this
   will write the string to the screen).  MaxLen is the maximum allowed
   length of the string (duh).  CharSet is the set of chars allowed to be
   entered into the string.  Also, look at the front of this unit, there are
   a bunch of other variables that effect the output of this routine.  This
   function returns the char that terminated the function. }
procedure PutStr(S:string);
{^ Powerful writting routine.  Color codes can be put directly into the
   string to change colors easily.  Also there are a few animation Codes
   also, you can easily write your own animation procedures and include them
   also; that ofcourse requires a recompilation.
   The CODE is: "" (alt+233).
   To change colors, the CODE comes first then one of the following chars:
    --------------------------------------------
    0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F (UPPERCASE!)
    a,b,c,d,e,f,g,h                 (LOWERCASE!)
    [,]
    --------------------------------------------
    The first line has all the values for changing the Foreground color.
      They must be UPPERCASE.  The values are the standard TP set, in
      that:  0=black, 1=blue, 2=green, ..., F (15)=white.
    The second line has all the values for changing the Background color.
      They must be LOWERCASE.  The values here go like: a=black, b=blue,
      c=green, d=cyan, e=red, f=magenta, g=brown, h=lgtgray, the same order
      as TP.
    The third line has the values for turning blinking on/off.
      [=blink on, ]=blink off.
    There are some other codes to know, look in the procedure itself to see
    them... Animation codes start with "|" and then a number for which
    writter (animator) to use.
    Remember CAPs DO matter! }
procedure PutStrxy(S:string;x1,y1:byte);
{^ Same as above, except you can change the X,Y position first. }

{procedure LocalSetColor(f,b:byte);
{^ LOCAL ONLY: Sets the color to f & b (fore & back). F range: 0..15;
   B range: 0..15; add 128 to turn blinking on, for B: 0..7.  This does not
   get sent to the remote side.  The only procedure that uses the this
   procedure is the "WriteStr()" below. }
procedure WriteStr(x,y:byte; s:string);
{^ LOCAL ONLY: This procedure is like the "PutStr()" procedure except it only
   writes to the LOCAL screen, AND it uses DIRECT Screen writes! (the cursor
   doesn't move)..  Colors can be used, but animation codes can not.  Any
   color changes you make with this will not effect the users color. }

{}

IMPLEMENTATION

type
  TWriter_Proc = procedure(s:string; var l:byte; f,b:byte);

procedure Writer_Nofx(s:string; var l:byte; f,b:byte); far; forward;
procedure Writer_Wipe1(s:string; var l:byte; f,b:byte); far; forward;
{procedure Writer_Wipe2(s:string; var l:byte; f,b:byte); far; forward;}
procedure Writer_fadein(s:string; var l:byte; f,b:byte); far; forward;
procedure Writer_fadeout(s:string; var l:byte; f,b:byte); far; forward;
{^- none of these are ever called directly.  But it wouldn't hurt anything
    if you did. }

const
  LocalAttr   : byte = 7;
  Writer_Proc : TWriter_Proc = Writer_Nofx;


{}
procedure Terminate(s:string);
begin
  textattr:=7;
  clrscr;
  textattr:=12;
  writeln(s);
  writeln;
  textattr:=7;
  delay(1000);
  halt;
end;
{}
function CommaInt(number:longint):string;
var
  numstr : string[15];
  len : byte;
  i : byte;
begin
  str(number,numstr);
  len := length(numstr);
  i := len+1;
  while (i>4)and(i<=len+1) do begin
    dec(i,3);
    insert(',',numstr,i);
  end;
  CommaInt := numstr;
end;
{}
function padEstr(s:string; ch:char; len:byte):string;
var i:byte;
begin
  while length(s)<len do s:=s+ch;
  padEstr:=s;
end;
{}
function padFstr(s:string; ch:char; len:byte):string;
var i:byte;
begin
  while length(s)<len do s:=ch+s;
  padFstr:=s;
end;
{}
function istr(n:longint; pad:byte):string;
var
  s:string[20];
begin
  str(n,s);
  while length(s)<pad do insert('0',s,1);
  istr:=s;
end;
{}
function sint(s:string):longint;
var
  l:longint;
  u:integer;
begin
  val(s,l,u);
  sint:=l;
end;
{}
function CSLen(s:string):byte;
{ Returns the length of a -Color Coded- string EX-Cluding any '' codes }
var
  slen : byte absolute s;
  i,len: byte;
begin
  len:=0;
  for i := 1 to slen do begin
    if i>length(s) then break;
    if (s[i]='')and(s[i+1]='|')
      then inc(i,2)
      else if S[i]='' then begin
        Inc(i);
        if S[i]='' then inc(len)
      end else inc(len);
  end;
  CSLen:=len;
end;
{}
Function UpChar(Ch : Char) : Char;
begin
  If Ch In [#97..#122] Then Ch:=chr(byte(ch) and $DF) {Chr(Ord(Ch)-32)}
{    Else If Ch>#90 Then If Ch='' Then Ch:=''{}
    Else if Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:='';
  UpChar:=Ch;
end;
{}
Function LowChar(Ch : Char) : Char;
begin
  If Ch In [#65..#90] Then Ch:=chr(byte(ch) and $20) {Chr(Ord(Ch)+32)}
{    Else If Ch>#122 Then If Ch='' Then Ch:=' '{}
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:=''
    Else If Ch='' Then Ch:='' Else If Ch='' Then Ch:='';
  LowChar:=Ch;
end;
{}
Function UpCaseStr(S : String) : String;
Var
  SLen : Byte Absolute S;
  x    : Integer;
begin
  For x := 1 To SLen Do S[x]:=UpChar(S[x]);
  UpCaseStr := S;
end;
{}
Function LowCaseStr(S : String) : String;
Var
  SLen : Byte Absolute S;
  i    : Integer;
begin
  For i := 1 To SLen Do S[i]:=LowChar(S[i]);
  LowCaseStr := S;
end;
{}
Function SmartCaseStr(S : String) : String;
Var
  SLen : Byte Absolute S;
  i    : Integer;
begin
  s:=LowCaseStr(s);
  For i := 1 To SLen Do begin
    If i=1 Then S[1]:=UpChar(S[1])
    Else if S[i-1]=' ' Then S[i]:=UpChar(S[i])
    Else if (Ord(S[i-1]) In [32..64]) And (S[i-1]<>'''')
      Then S[i]:=UpChar(S[i]);
  end;
  SmartCaseStr := S;
end;
{}
Procedure HideCursor; Assembler;
asm
  mov   ax,0100h
  mov   cx,2607h
  int   10h
end;
{}
Procedure ShowCursor; Assembler;
asm
  mov   ax,0100h
  mov   cx,0506h
  int   10h
end;
{}
{function whereX:byte; assembler;
asm
  push  dx
  mov   ah,03h
  mov   bh,0
  int   10h
  mov   al,dl
  inc   al
  pop   dx
end;
{}
{function whereY:byte; assembler;
asm
  push  dx
  mov   ah,03h
  mov   bh,0
  int   10h
  mov   al,dh
  inc   al
  pop   dx
end;
{}
Procedure SetCursorSize(Top,Bot:Byte); Assembler;
Asm
  Mov ah,01h
  Mov ch,[Top]
  Mov cl,[Bot]
  Int 10h
End;
{}
procedure killblanks(var s:string);
{This kills ALL the blanks in the string}
var i:byte;
begin
  i:=1;
  while i<=length(s) do
    if (s[i]=' ') then delete(s,i,1) else inc(i);
end;
{}
procedure KillExtraBlanks(var s:string);
{This only kills the blanks in front of and at the end of the string}
var i:byte;
begin
  i:=1;
  while (s[i]=' ')and(i<=length(s)) do
    delete(s,i,1);
  i:=length(s);
  while (s[i]=' ')and(i>=1) do begin
    delete(s,i,1);
    dec(i);
  end;
end;
{}
{}
function AreYouSureY : char;
var ch:char;
begin
  putstr('a8[3Y8,3n8] 7 ');
  repeat
    ch:=HotKey([#13,'Y','N']);
    if ch=#13 then ch:='Y';
  until ch in [#13,'Y','N'];
  AreYouSureY := ch;
end;
{}
function AreYouSureN : char;
var ch:char;
begin
  putstr('a8[3y8,3N8] 7 ');
  repeat
    ch:=HotKey([#13,'Y','N']);
    if ch=#13 then ch:='N';
  until ch in [#13,'Y','N'];
  AreYouSureN := ch;
end;
{}
procedure GetPW(var st:string; len:byte);
const
  PWset : tcharset = [#0..#31,#33..#58,#60..#232,#234..#255];
var
  oldsec  : boolean;
  oldauto : tauto;
  x,y     : byte;
begin
  oldauto:=autocaps;
  autocaps:=upper;
  oldsec:=secret;
  secret:=true;
  x:=wherex; y:=wherey;
  repeat
    siogotoxy(x,y);
    GetStr(st,len,PWset);
  until st<>'';
  secret:=oldsec;
  autocaps:=oldauto;
end;
{}
procedure GetInt;
var
  done:boolean;
  c:integer;
  st:string[15];
  v:longint;
  ch:char;
begin
  done:=false;
  st:='';
  repeat
    ch:=sioreadkey; if ch=#0 then ch:=sioreadkey;
    case ch of
      '0'..'9' : if (length(st)<12)and(sint(st+ch)<=h)and(sint(st+ch)>=l) then begin
        if (ch='0') then begin
          if (st<>'-')and(st<>'') then begin
            insert(ch,st,length(st)+1);
            siowritec(ch);
          end;
        end else begin
          insert(ch,st,length(st)+1); {1..9}
          siowritec(ch);
        end;
      end;
      '-' : if (l<0)and(st='') then begin
        siowritec('-');
        st:='-';
      end;
      #8  : if st<>'' then begin
        siowrite(#8' '#8);
        delete(st,length(st),1);
      end;
      #13 : done:=true;
    end;

    val(st,v,c);
    if (hotkey)and(sint(st+'0')>h) then done:=true;

  until done;
  num:=v;
end;
{}
function HotKey(CharSet : TCharSet) : char;
var
  ch:char;
begin
  if CharSet=[] then begin HotKey:=#255; exit; end;
  if highlight then putstr('b a'#8);
  repeat
    ch:=upchar(sioReadkey);
  until ch in CharSet;
  HotKey:=ch;
end;
{}
function GetStr( Var DestStr  : String;                   {Self explanitory}
                     MaxLen   : Byte;                     {Ditto.. .  .    }
                     CharSet  : TCharSet )    {Set of allowable input chars}
                     : char;                      {returns char that exited}
Var
  StrSize : Byte;
  SPos : Byte;
  Extended : Boolean;
 {------------------------------------------------------------------------}
  Function GetKeyPress : Char;
  Var ch:Char;
  Begin
    Extended:=False;
    ch:=sioreadkey;
    case autocaps of
      noauto: ;
      upper: ch:=UpChar(ch);
      lower: ch:=LowChar(ch);
      smart: begin
        ch:=LowChar(ch);
        If SPos=1 Then ch:=UpChar(ch)
        Else if DestStr[SPos-1]=' ' Then ch:=UpChar(ch)
        Else if (Ord(DestStr[Spos-1]) In [32..64])And(DestStr[Spos-1]<>'''')
        Then ch:=UpChar(ch);
      end;
    end; {case autocaps}
    {If (Ch=#0)or((ch='[')and(Skeypressed)) Then Begin
      Extended:=True; Sread_char(ch);
    End;}
    GetKeyPress:=ch;
  End;
 {------------------------------------------------------------------------}
  Procedure DelEndBlank;
  Begin
    If DestStr[StrSize] = #32 Then Begin
      Delete(DestStr,StrSize,1);
      Dec(StrSize);
    End;
  End;
 {------------------------------------------------------------------------}
Const
  Right = #77; {0,M}  {Move cursor right}        {these cannot be used!}
  Left  = #75; {0,K}  {Move cursor left}         {these cannot be used!}
  Del   = #83; {0,S}  {Delete character}         {these cannot be used!}
  Ins   = #82; {0,R}  {Insert on/off}            {these cannot be used!}
  HomeK = #71; {0,G}  {Goto begining of string}  {these cannot be used!}
  EndK  = #79; {0,O}  {Goto end of string}       {these cannot be used!}
  CtrlX = #24; {}     {Erase entire line, start over}             {done}
  Esc   = #27; {}     {Exit with no changes to DestStr}           {done}
  BS    = #08; {}     {Destructive BackSpace}                     {done}
  Codes : Set of Char = [CtrlX,Esc,BS]; { these would literally print out
                                          if not in this set. }
Var
  OverWrite : Boolean; {insert on/off}
  X,Y    : Byte;
  Xmin   : Byte;
  Xmax   : Byte;
  i      : Byte;
  Ch     : Char;
  OldStr : String;
  oldcol : byte;
Label
  Start;
Begin
  If (MaxLen<1) Then Exit;
  OldStr:=DestStr;
  oldcol:=textattr;
  OverWrite:=False;
  Xmin:=WhereX;
  Xmax:=MaxLen+Xmin-1;
  X:=Xmin;
  Y:=WhereY;
  StrSize:=Length(DestStr);
  SPos:=StrSize+1;
  If (Xmax>80) Then Begin
    Xmax := 80;
    MaxLen := Xmax-(StrSize+Xmin-1);   { Must adjust if it will excede Xmax }
  End;
  if SPos-1 > maxlen then SPos:= maxlen;
  while length(deststr) > maxlen do  {if str>maxlen then delete ending chars}
    delete(deststr,length(deststr),1);
  strsize:=length(deststr); {get new len (incase the above was true)}
  if door.USEcolor then SetColor(FGCol,BGCol);  {Set the colors}
  if highlight then begin
    case secret of
      false : sioWrite(DestStr);
      true  : for i := 1 to length(deststr) do siowritec(secretchar);
    end;
    For i:=Xmin+length(deststr)-1 to Xmax-1 Do siowritec(' ');
  end;
  siogotoxy(Xmin+SPos-1,Y);
  X:=X+SPos-1;
  {Gotoxy(X,Y);}
  if inserton then begin
    setcursorsize(1,8);
    overwrite:=true;
  end
  else SetCursorSize(7,8);
 {----------------------------}
  Repeat
    Ch:=GetKeyPress;
start:
    If Extended Then
      Case Ch of
        Ins   : Begin
          OverWrite:= Not Overwrite;
          case overwrite of
            false : SetCursorSize(7,8); {this ofcourse, is only seen locally}
            true  : SetCursorSize(1,8);
          end;
        end;
        HomeK : Begin
          SPos:=1;
          X:=Xmin;
          While DestStr[StrSize] = #32 Do DelEndBlank;
          siogotoxy(X,Y);
        End;
        EndK  : Begin
          SPos:=StrSize+1;
          X:=StrSize+Xmin;
          If (StrSize=MaxLen) Then Begin Dec(X); Dec(SPos) End;
          siogotoxy(X,Y);
        End;
        Right : If (X<Xmax)and(SPos<StrSize+1) Then Begin
          Inc(SPos);
          Inc(X);
          siogotoxy(X,Y);
        End;
        Left  : If (X>Xmin)and(SPos>0) Then Begin
          Dec(SPos);
          Dec(X);
          siogotoxy(X,Y);
          DelEndBlank;
          If (StrSize=1)and(DestStr[SPos]=#32)and(SPos=1) Then DelEndBlank;
        End;
        Del   : If (StrSize>0)and(SPos<=StrSize) Then Begin
          Delete(DestStr,SPos,1);
          Dec(StrSize);
          For i := SPos to StrSize+1 Do siowrite(DestStr[i]);
          siowrite(' ');
        End;
      End {Of Case}

    Else If (Ch in CharSet)and not(Ch in Codes)and
              not(ch in normalexitkeys)and(X-1<Xmax) Then Begin
      Case OverWrite of
        False : If (StrSize<MaxLen) Then Begin    {Chars will be moved right}
          Insert(Ch,DestStr,SPos);
          case secret of
            false : siowritec(Ch);
            true  : siowritec(secretchar);
          end;
          Inc(StrSize);
          Inc(SPos);
          Inc(X);
          If SPos-1<StrSize Then
            For i := SPos to StrSize Do siowritec(DestStr[i]);
        End;
        True  : Begin                             {Chars will be overwritten}
          If SPos<=StrSize Then Delete(DestStr,SPos,1);
          Insert(Ch,DestStr,SPos);
          case secret of
            false : siowritec(Ch);
            true  : siowritec(secretchar);
          end;
          If (SPos-1=StrSize)and(StrSize<MaxLen) Then Inc(StrSize);
          If (X<Xmax) Then Begin Inc(SPos); Inc(X); siogotoxy(X,Y) End;
        End;
      End; {Of Case}
    End {Else..If}
    Else
      Case Ch of
        CtrlX : Begin
          X:=Xmin;
          StrSize:=0;
          SPos:=1;
          siogotoxy(X,Y);
          For i := Xmin to Xmin+Length(DestStr) Do
            siowritec(' ');
            {DVWrite(i,Y,' ',BGCol,FGCol,0);}
          DestStr:='';
          siogotoxy(X,Y);
        End;
        BS    : If (X>Xmin)and(Spos>0) Then Begin
          Delete(DestStr,SPos-1,1);
          Dec(SPos);
          Dec(StrSize);
          Dec(X);
          siowrite(#8' '#8);
        End;
      End; {Of Case}
  Until (Ch in normalexitkeys) or ((extended)and(ch in extendedexitkeys));
 {----------------------------}
  While DestStr[StrSize] = #32 Do DelEndBlank;
  If Ch = Esc Then DestStr := OldStr;
  KillExtraBlanks(DestStr);
{  Sgotoxy(Xmin,Y);
  PutStr(DestStr);
  for i := Xmin+Length(DestStr)-1 to XMax-1 do Swrite(' ');}
  getstr:=ch;
  SetCursorSize(7,8);
  if door.USEcolor then textattr:=oldcol;
End;
{}
procedure writer_nofx(s:string; var l:byte; f,b:byte);
begin
  siowritec(s[l]);
end;
{}
procedure writer_fadein(s:string; var l:byte; f,b:byte);
const
  fc : array[9..15] of record a,b,c : byte; end =
         ( (a:08;b:01;c:09),(a:08;b:02;c:10),(a:08;b:03;c:11),
           (a:08;b:04;c:12),(a:08;b:05;c:13),(a:08;b:06;c:14),
           (a:08;b:07;c:15) );

var
  j,x,y : byte;
  s2    : string;
begin
  j:=1; s2:='';
  while (s[l]<>#233)and(l<=length(s)) do begin
    insert(s[l],s2,j);
    inc(l); inc(j);
  end; if l>0 then dec(l);
  if f>8 then begin
    x:=wherex; y:=wherey;
    textcolor(fc[f].a); siowrite(s2);
    siogotoxy(x,y);
    delay(dlay[writer]);
    textcolor(fc[f].b); siowrite(s2); siogotoxy(x,y); delay(dlay[writer]);
    textcolor(fc[f].c); siowrite(s2);
    if door.USEcolor then textattr:=f+(b*16);
  end else siowrite(s2);
end;
{}
procedure writer_fadeout(s:string; var l:byte; f,b:byte);
const
  fc : array[9..15] of record a,b,c : byte; end =
         ( (a:09;b:01;c:08),(a:10;b:02;c:08),(a:11;b:03;c:08),
           (a:12;b:04;c:08),(a:13;b:05;c:08),(a:14;b:06;c:08),
           (a:15;b:07;c:08) );

var
  j,x,y : byte;
  s2    : string;
begin
  j:=1; s2:='';
  while (s[l]<>#233)and(l<=length(s)) do begin
    insert(s[l],s2,j);
    inc(l); inc(j);
  end; if l>0 then dec(l);
  if f>8 then begin
    x:=wherex; y:=wherey;
    textcolor(fc[f].a); siowrite(s2); siogotoxy(x,y); delay(dlay[writer]);
    textcolor(fc[f].b); siowrite(s2); siogotoxy(x,y); delay(dlay[writer]);
    textcolor(fc[f].c); siowrite(s2); siogotoxy(x,y); delay(dlay[writer]);
    textcolor(0);       siowrite(s2);
    if door.USEcolor then textattr:=f+(b*16);
  end else siowrite(s2);
end;
{}
procedure writer_wipe1(s:string; var l:byte; f,b:byte);
const
  wipech : array[1..2] of char = '';
var
  w:byte;
begin
  if door.USEcolor then setcolor(15,0);
  for w:=1 to 2 do siowrite(wipech[w]+#8);
  delay(dlay[writer]);
  if door.USEcolor then setcolor(F,B);
  siowritec(s[l]);
end;
{}
procedure writer_wipe2(s:string; var l:byte; f,b:byte); far;
const
  wipech : array[1..2] of char = '';
var
  w:byte;
begin
  {not finished}
{  if door.USEcolor then setcolor(15,0);
  for w:=1 to 2 do siowrite(wipech[w]+#8);
  delay(dlay[writer]);
  if door.USEcolor then setcolor(F,B);
  siowrite(s[l]);}
end;
{}
procedure PutStr(S:string);
label writeit;
const
  Fg : byte = 7;
  Bg : byte = 0;
  Blk: byte = 0;
  savedattr : byte = 7;
var
  I : byte;
  C : char;

begin
  for I := 1 to Length(S) do Begin
    if I>length(S) Then Exit;
    C:=S[I];
    if C=#233 then Begin
      Inc(I); C:=S[I];
      if (door.USEcolor)and(C in ['0'..'9','A'..'F','a'..'h','[',']']) then case C of
        '0' : textcolor(0);
        '1' : textcolor(1);
        '2' : textcolor(2);
        '3' : textcolor(3);
        '4' : textcolor(4);
        '5' : textcolor(5);
        '6' : textcolor(6);
        '7' : textcolor(7);
        '8' : textcolor(8);
        '9' : textcolor(9);
        'A' : textcolor(10);
        'B' : textcolor(11);
        'C' : textcolor(12);
        'D' : textcolor(13);
        'E' : textcolor(14);
        'F' : textcolor(15);
        'a' : textbackground(0);
        'b' : textbackground(1);
        'c' : textbackground(2);
        'd' : textbackground(3);
        'e' : textbackground(4);
        'f' : textbackground(5);
        'g' : textbackground(6);
        'h' : textbackground(7);
        '[' : textattr:=textattr or 128;
        ']' : textattr:=textattr and 127;
      end else case c of
{        '@' : Pause_Proc(pausestr);{}
        '.' : begin
          siowriteln('');
{          if morechk then begin
            inc(curlinenum);
            if curlinenum>=24 then begin
              Pause_Proc(pausestr);
              curlinenum:=1;
            end;
          end;}
        end;
        's' : savedattr:=textattr;   {save current color}
        'r' : textattr:=savedattr;   {restore saved color}
        '>' : siocursorright(1);
        '<' : siocursorleft(1);
        '!' : siowritec(#7);
        '*' : sioclrscr;
        '-' : sioclrEol;
        '' : goto writeit;   {so you can write an actual control code}
        '|' : begin
                inc(I);
                if ord(s[I])-48 in [ord(low(twriter))..ord(high(twriter))]
                  then writer:=twriter(ord(s[I])-48) else dec(I);
                case door.USEani of
                  true : case writer of
                    nofx    : Writer_Proc:=Writer_Nofx;
                    wipe1   : Writer_Proc:=Writer_Wipe1;
                    {wipe2   : ;}
                    fadein  : if door.USEcolor
                      then Writer_Proc:=Writer_fadein
                      else Writer_Proc:=Writer_Nofx;
                    fadeout : if door.USEcolor
                      then Writer_Proc:=Writer_fadeout
                      else Writer_Proc:=Writer_Nofx;
                  end;
                  false : Writer_Proc:=Writer_Nofx;
                end;
              end; {'|'}
      end; { CASE }
    end else begin
writeit: {label}
      fg:=textattr mod 16;
      bg:=textattr shr 4;
      Writer_Proc(S,i,fg,bg);
    end;
  end;
end;
{}
procedure PutStrxy(S:string; x1,y1:byte);
begin
  siogotoxy(x1,y1);
  putstr(S);
end;
{}
procedure LocalSetColor(f,b:byte);
begin
  LocalAttr:=f+(b*16);
end;
{}
procedure DVWRITE(x,y:word;attr:byte; s:string); assembler;
{x,y are 1 based; not 0 zero based}
asm
  push ds
  mov bx,[y]
  dec bx
  shl bx,1
  mov ax,bx
{$ifopt G+}
  shl bx,2
{$else}
  shl bx,1
  shl bx,1
{$endif}
  add ax,bx
  add ax,[DVseg]
  mov es,ax
  mov di,[x]
  dec di
  shl di,1
  add di,[DVofs]

  lds si,s
  mov cl,byte ptr [si]
  inc si
  mov ah,attr
@1:
  mov al,byte ptr [si]
  mov word ptr es:[di],ax
  inc si
  add di,2
  dec cl
  jnz @1
  pop ds
end;
{}
procedure WriteStr;
label writeit;
const
  Fg : byte = 7;
  Bg : byte = 0;
  Blk: byte = 0;
var
  I,plus : byte;
  C : char;

begin
  plus:=0;
  for I := 1 to Length(S) do Begin
    if I>length(S) Then Exit;
    C:=S[I];
    if C=#233 then Begin
      Inc(I); C:=S[I];
      if (C in ['0'..'9','A'..'F','a'..'h','[',']']) then case C of
        '0' : localattr:=0  or (localattr and $F0);
        '1' : localattr:=1  or (localattr and $F0);
        '2' : localattr:=2  or (localattr and $F0);
        '3' : localattr:=3  or (localattr and $F0);
        '4' : localattr:=4  or (localattr and $F0);
        '5' : localattr:=5  or (localattr and $F0);
        '6' : localattr:=6  or (localattr and $F0);
        '7' : localattr:=7  or (localattr and $F0);
        '8' : localattr:=8  or (localattr and $F0);
        '9' : localattr:=9  or (localattr and $F0);
        'A' : localattr:=10 or (localattr and $F0);
        'B' : localattr:=11 or (localattr and $F0);
        'C' : localattr:=12 or (localattr and $F0);
        'D' : localattr:=13 or (localattr and $F0);
        'E' : localattr:=14 or (localattr and $F0);
        'F' : localattr:=15 or (localattr and $F0);
        'a' : localattr:=(0 shl 4) or (localattr and $0F);
        'b' : localattr:=(1 shl 4) or (localattr and $0F);
        'c' : localattr:=(2 shl 4) or (localattr and $0F);
        'd' : localattr:=(3 shl 4) or (localattr and $0F);
        'e' : localattr:=(4 shl 4) or (localattr and $0F);
        'f' : localattr:=(5 shl 4) or (localattr and $0F);
        'g' : localattr:=(6 shl 4) or (localattr and $0F);
        'h' : localattr:=(7 shl 4) or (localattr and $0F);
        '[' : localattr:=localattr or 128;
        ']' : localattr:=localattr and 127;
      end else case c of
        '>' : inc(y);                  {crlf}
        '<' : if x>1 then dec(x);      {backspace}
        '!' : write(#7);               {bell}
{        '*' : clrscr;}
        '-' : ClrEol;
        '' : goto writeit;   {so you can write an actual control code}
      end; { CASE }
    end else begin
writeit: {label}
      DVwrite(x+plus,y,localattr,C);
      inc(plus);
    end;
  end;
end;
{}

end.