unit Flistu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus;

type
  TFileListForm = class(TForm)
    Bevel2: TBevel;
    BtnEdit: TSpeedButton;
    BtnBrowse: TSpeedButton;
    BtnClrList: TSpeedButton;
    BtnRemFile: TSpeedButton;
    BtnAddFiles: TSpeedButton;
    LstBxSelFiles: TListBox;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    List1: TMenuItem;
    AddFiles1: TMenuItem;
    RemoveFile1: TMenuItem;
    ClearList1: TMenuItem;
    BrowseFile1: TMenuItem;
    EditFile1: TMenuItem;
    N1: TMenuItem;
    procedure BtnAddFilesClick(Sender: TObject);
    procedure BtnRemFileClick(Sender: TObject);
    procedure BtnClrListClick(Sender: TObject);
    procedure BtnBrowseClick(Sender: TObject);
    procedure BtnEditClick(Sender: TObject);
    procedure LstBxSelFilesDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure List1Click(Sender: TObject);
  private
    { Private declarations }
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
  end;

var
  FileListForm: TFileListForm;

implementation
USES GenVuU, IniModU, GrpModU, IniFiles;
{$R *.DFM}

procedure TFileListForm.CreateParams(var Params: TCreateParams);
BEGIN
  Inherited  CreateParams(Params);
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      Params.X := ReadInteger('FileList', 'Left', 0);
      Params.Y := ReadInteger('FileList', 'Top', 0);
      Params.Width := ReadInteger('FileList', 'Width', 189);
      Params.Height := ReadInteger('FileList', 'Height', 162);
    finally
      Free;
    END;
END;

procedure TFileListForm.FormDestroy(Sender: TObject);
begin
  WindowState := wsNormal;
  WITH TIniFile.Create(ChangeFileExt(
    ExtractFileName(Application.ExeName),'.INI')) DO
    try
      WriteInteger('FileList', 'Left', Left);
      WriteInteger('FileList', 'Top', Top);
      WriteInteger('FileList', 'Width', Width);
      WriteInteger('FileList', 'Height', Height);
    finally
      Free;
    END;
end;

procedure TFileListForm.BtnAddFilesClick(Sender: TObject);
VAR
  N : Word;
  Ext : String[4];
begin
  WITH OpenDialog1 DO
    IF Execute THEN
      BEGIN
        FOR N := Files.Count-1 DOWNTO 0 DO
          BEGIN
            Ext := UpperCase(ExtractFileExt(Files[N]));
            IF (Ext <> '.GRP') AND (Ext <> '.INI') THEN
              Files.Delete(N);
          END;
        LstBxSelFiles.Items.AddStrings(Files);
        Filename := '';
        IF LstBxSelFiles.Items.Count > 0 THEN
          BEGIN
            LstBxSelFiles.ItemIndex := 0;
            BtnRemFile.Enabled := True;
            BtnBrowse.Enabled := True;
            BtnEdit.Enabled := True;
          END;
      END;
end;

procedure TFileListForm.BtnRemFileClick(Sender: TObject);
VAR N : Word;
begin
  WITH LstBxSelFiles DO
    BEGIN
      IF ItemIndex > -1 THEN
        Items.Delete(ItemIndex);
      IF Items.Count = 0 THEN
        BEGIN
          BtnRemFile.Enabled := False;
          BtnBrowse.Enabled := FALSE;
          BtnEdit.Enabled := False;
        END;
    END;
end;

procedure TFileListForm.BtnClrListClick(Sender: TObject);
begin
  LstBxSelFiles.Clear;
  BtnBrowse.Enabled := FALSE;
  BtnRemFile.Enabled := FALSE;
  BtnEdit.Enabled := False;
end;

procedure TFileListForm.BtnBrowseClick(Sender: TObject);
VAR
  Ext : String[4];
begin
  WITH LstBxSelFiles DO
    BEGIN
      Ext := UpperCase(ExtractFileExt(Items[ItemIndex]));
      IF Ext = '.INI' THEN
        WITH TGenViewer.Create(Application) DO
          LoadFromINIFile(Items[ItemIndex])
      ELSE IF Ext = '.GRP' THEN
        WITH TGenViewer.Create(Application) DO
          LoadFromGRPFile(Items[ItemIndex]);
    END;
end;

procedure TFileListForm.BtnEditClick(Sender: TObject);
VAR
  Ext : String[4];
begin
  WITH LstBxSelFiles DO
    BEGIN
      Ext := UpperCase(ExtractFileExt(Items[ItemIndex]));
      IF Ext = '.INI' THEN
        WITH TIniModForm.Create(Application) DO
          LoadFromFile(Items[ItemIndex])
      ELSE IF Ext = '.GRP' THEN
        WITH TGrpModForm.Create(Application) DO
          LoadFromFile(Items[ItemIndex]);
    END;
end;

procedure TFileListForm.LstBxSelFilesDblClick(Sender: TObject);
{double-click an item to browse, or shift-double-click
 to edit}
begin
  IF GetAsyncKeyState(VK_SHIFT) AND $8000 > 0 THEN
    BtnEditClick(Sender)
  ELSE BtnBrowseClick(Sender);
end;

procedure TFileListForm.FormCreate(Sender: TObject);
VAR WinDir : String;
begin
  GetWindowsDirectory(@WinDir[1], 144);
  WinDir[0] := Char(StrLen(@WinDir[1]));
  OpenDialog1.InitialDir := WinDir;
end;

procedure TFileListForm.List1Click(Sender: TObject);
begin
  RemoveFile1.Enabled := LstBxSelFiles.Items.Count > 0;
  BrowseFile1.Enabled := RemoveFile1.Enabled;
  EditFile1.Enabled := RemoveFile1.Enabled;
end;

end.
