//
//  Clustering Demo
//
//  Copyright Cygron ltd. 1997.
//
unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Cluster, ExtCtrls, StdCtrls, ComCtrls;

const
  MAXITEM = 1000;
  MAXDIM = 2;
  Colors: array[1..10] of TColor = (clRed,clWhite,clBlack,clLime,clyellow,clNavy,clTeal,clAqua,clGreen,clDkGray);

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    LabelPoints: TLabel;
    LabelClusters: TLabel;
    ButtonStep: TButton;
    ProgressBar1: TProgressBar;
    TrackBarPoints: TTrackBar;
    TrackBarClusters: TTrackBar;
    Panel1: TPanel;
    PaintBox1: TPaintBox;
    Clustering1: TClustering;
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TrackBarPointsChange(Sender: TObject);
    procedure TrackBarClustersChange(Sender: TObject);
    procedure ButtonStepClick(Sender: TObject);
    function Clustering1GetData(Sender: TObject; i, j: Longint): Double;
  public
    data: array[1..MAXITEM,1..MAXDIM] of Double;
    procedure ResetData;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

/////////////////////////////////////////////////////////////////////
// Make random data
procedure TForm1.ResetData;
var
  i,j: Integer;
begin
  Randomize;
  for i := 1 to MAXITEM do begin
    for j := 1 to MAXDIM do begin
      data[i,j] := Random;
    end;
  end;
end;

/////////////////////////////////////////////////////////////////////
// Paint graph
procedure TForm1.PaintBox1Paint(Sender: TObject);
var
  x,y,i: Integer;
  c: TCanvas;
  r,r2: TRect;
  co: TColor;
begin
  c := PaintBox1.Canvas;
  r := PaintBox1.ClientRect;
  // clusters
  for i := 1 to Clustering1.ClusterNum do begin
    c.Pen.Color := Colors[i];
    x := Round(r.Right * Clustering1.Clusters[i,1]);
    y := Round(r.Bottom * Clustering1.Clusters[i,2]);
    c.Ellipse(x-6,y-6,x+7,y+7);
  end;
  // items
  for i := 1 to Clustering1.ItemNum do begin
    co := Colors[Clustering1.ItemCluster(i)];
    c.Brush.Color := co;
    x := Round(r.Right * data[i,1]);
    y := Round(r.Bottom * data[i,2]);
    r2.Top := y-2;
    r2.Bottom := y+1;
    r2.Left := x-2;
    r2.Right := x+1;
    c.FillRect(r2);
  end;
end;

/////////////////////////////////////////////////////////////////////
// FormCreate
procedure TForm1.FormCreate(Sender: TObject);
begin
  TrackBarPoints.Max := MAXITEM;
  TrackBarPointsChange(self);
  TrackBarClustersChange(self);
end;

/////////////////////////////////////////////////////////////////////
// Step 100
procedure TForm1.ButtonStepClick(Sender: TObject);
var
  i: Integer;
begin
  for i := 1 to 100 do begin
    Clustering1.Step;
    if i mod 10 = 0 then PaintBox1.Repaint;
    ProgressBar1.Position := i;
  end;
  ProgressBar1.Position := 0;
end;

/////////////////////////////////////////////////////////////////////
// Get data
function TForm1.Clustering1GetData(Sender: TObject; i, j: Longint): Double;
begin
  Result := data[i,j];
end;

/////////////////////////////////////////////////////////////////////
// Create new items
procedure TForm1.TrackBarPointsChange(Sender: TObject);
begin
  Clustering1.ItemNum := TrackBarPoints.Position;
  ResetData;
  Clustering1.Reset;
  LabelPoints.Caption := 'Items = '+IntToStr(TrackBarPoints.Position);
  PaintBox1.Invalidate;
end;

/////////////////////////////////////////////////////////////////////
// Reset clusters
procedure TForm1.TrackBarClustersChange(Sender: TObject);
begin
  Clustering1.ClusterNum := TrackBarClusters.Position;
  LabelClusters.Caption := 'Clusters = '+IntToStr(TrackBarClusters.Position);
  PaintBox1.Invalidate;
end;

end.
