&& Author:  Brad Tharalson    72030,3045

function mxinit   && MXINIT

  && next few lines used by loadtags()
  public mxtagcnt
  #ifdef __dbasewin__
    public array mxtags[5],mxkeys[5]
  #else
    public mxtags[5],mxkeys[5]
  #endif
  && following used by devtopr(),devtoscr(),mxr(),mxprf()
  public mxrscrn
  public mxrcol
  public mxrrow
  public mxrhandle && file to send mxr() output to
  public mxrfile   && default printer redirection file
  public mxprtype  && type of printer, see mxprset()
  public mxrpwid   && report width, true if greater than 80
  public mxprwid   && default paper width, true if greater than 80
  mxrfile="mxrtemp.out"
  mxrscrn=.t.
  mxprtype=0  && output defaults to screen, see mxprset()
  mxrpwid=.t. && default: report is wider than 80 col
  mxprwid=.t. && default: paper is wider than 80 col
  return .t.


function clozall   && CLOZALL

  close databases
  savalias(2)  && clear alias() stack used by mxspecial()
  return .t.


function clozdbf   && CLOZDBF

  use   && close database in currently selected area
  return .t.


function savalias(seln)  && SAVALIAS

  if pcount()>0
    if seln=1
      && used by savalias() and restalias()
      #ifdef __dbasewin__
        public array mxalias[20]
      #else
        public mxalias[20]
      #endif
      public mxacnt
    endif
    afill(mxalias," ")
    mxacnt=0
    return 0
  endif
  if mxacnt<20
    mxacnt=mxacnt+1
    #ifdef __dbasewin__
      mxalias[mxacnt]=workarea()
    #else
      mxalias[mxacnt]=alias()
    #endif
  else
    #ifdef __dbasewin__
      swait("Savalias: Too Many savalias() Calls")
    #endif
  endif
  return 0


function restalias   && RESTALIAS

  if mxacnt>0
    select (mxalias[mxacnt])
    mxacnt=mxacnt-1
  endif
  return 0


function mxseek(aliasname,forpat)     && MXSEEK

  local ii

  #ifdef __dbasewin__
    if .not. empty(aliasname)
      ii=seek(forpat,aliasname)
    else
      ii=seek(forpat)
    endif
  #else
    if .not. empty(aliasname)
      ii=dbseek(forpat,aliasname)
    else
      ii=dbseek(forpat)
    endif
  #endif
  return ii


function mxsetorder     && MXSETORDER
parameter aliasname,seln

  local ii,jj,tt

  if .not. empty(aliasname)
    savalias()
    select (aliasname)
  endif
  loadtags()
  jj=0
  if mxtagcnt>0
    if type("seln")="C"  && select by tag
      for ii=1 to mxtagcnt
        if upper(seln)=upper(mxtags[ii])
          jj=ii
          exit
        endif
      next
    else          && select by order number
      if seln>=0 .and. seln<=mxtagcnt
        jj=seln
      endif
    endif
  endif
  if jj=0
    set order to
  else
    tt=mxtags[jj]
    set order to (tt)
  endif
  if .not. empty(aliasname)
    restalias()
  endif
  return .t.


function mxlock     && MXLOCK
parameter aliasname,canabort

  if pcount()=0
    aliasname=" "  && don't change selected area
    canabort=.f.   && default, try until succeeds
  endif
  if pcount()=1
    canabort=.f.   && default, try until succeeds
  endif
  return mxspecial(aliasname,1,canabort)


function mxunlock     && MXUNLOCK
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,2)


function mxappend     && MXAPPEND
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,3)


function mxclose     && MXCLOSE
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,4)


function mxskip     && MXSKIP
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,5)


function mxeof     && MXEOF
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,6)


function mxbottom     && MXBOTTOM
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,7)


function mxtop     && MXTOP
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,8)


function mxgoto     && MXGOTO
parameter aliasname,seln

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,9,seln)


function mxrecno     && MXRECNO
parameter aliasname

  if pcount()=0
    aliasname=" "  && don't change selected area
  endif
  return mxspecial(aliasname,10)


function mxspecial  &&  MXSPECIAL
parameters aname,opnum,selop

  local ret

  ret=.f.
  if .not. empty(aname)
    savalias()
    select (aname)
  endif
  do case
    case opnum=1   && lock record
      ret=lockit(selop)
    case opnum=2   && unlock record
      unlock
    case opnum=3   && add record
      append blank
      ret=.t.
    case opnum=4   && close workarea
      use
    case opnum=5
      skip
    case opnum=6
      ret=eof()
    case opnum=7
      go bottom
    case opnum=8
      go top
    case opnum=9
      ret=recno()
    case opnum=10
      #ifdef __dbasewin__
        go to (selop)
      #else
        go (selop)
      #endif
  endcase
  if .not. empty(aname)
    restalias()
  endif
  return ret


function loadtags    && LOADTAGS

  local ii

  mxtagcnt=0
  for ii=1 to 5
    #ifdef __dbasewin__
      mxtags[ii]=tag(ii)
      mxkeys[ii]=key(ii)
    #else
      mxtags[ii]=ordname(ii)
      mxkeys[ii]=ordkey(ii)
    #endif
    if .not. empty(mxtags[ii])
      mxtagcnt=mxtagcnt+1
    endif
  next
  return .t.


function mxuse   &&  MXUSE
parameters dbfname,talias,excl

  local ii

  if pcount()<3
    excl=.f.
  endif
  if pcount()<2
    talias=" "
  endif
  && track area it will be opened in
  #ifdef __dbasewin__
    ii=select()
    if excl
      if .not. empty(talias)
        use (dbfname) in (ii) exclusive alias &talias
      else
        use (dbfname) in (ii) exclusive
      endif
    else
      if .not. empty(talias)
        use (dbfname) in (ii) shared alias &talias
      else
        use (dbfname) in (ii) shared
      endif
    endif
    && select area as current work area
    select (ii)
  #else
    if excl
      if .not. empty(talias)
        use (dbfname) exclusive alias &talias
      else
        use (dbfname) exclusive
      endif
    else
      if .not. empty(talias)
        use (dbfname) shared alias &talias
      else
        use (dbfname) shared
      endif
    endif
  #endif
  && set to first order and go to beginning of file
  mxsetorder(" ",1)
  go top
  return .t.


function devtopr  &&  DEVTOPR

  private tt

  mxrscrn=.f.
  && page starts at 0,0
  mxrrow=0
  mxrcol=0
  if file(mxrfile)
    delete file (mxrfile)
  endif
  mxrhandle=fcreate(mxrfile,"W")
  && if report will be wider than printer select condensed mode
  if mxprtype>0 .and. mxrpwid .and. .not. mxprwid
    mxprset(.t.,1)
  endif
  return .t.


function mxprf(fname)

  #ifdef __dbasewin__
    EXTERN CHANDLE spoolfile(CSTRING,CSTRING,CSTRING,CSTRING) GDI.exe
  #endif

  if mxprtype=0   && screen
    onscreen(fname)
  else
    #ifdef __dbasewin__
      spoolfile("Generic / Text Only","LPT1:","My Printer File",mxrfile)
    #else
      copy file (mxrfile) to lpt1
    #endif
  endif
  return .t.

function devtoscr  && DEVTOSCR

  if mxprtype>0 .and. mxrpwid .and. .not. mxprwid
    mxprset(.f.,1)
  endif
  fclose(mxrhandle)
  mxrscrn=.t.    && set mxr() handler back to screen
  mxprf(mxrfile) && view file on screen or send to printer
  return .t.


function mxrsetprc(torow,tocol)   && MXRSETPRC

  mxrrow=torow
  mxrcol=tocol
  return .t.


function mxreject(islast)

  if pcount()=0
    islast=.f.
  endif
  if islast
    fwrite(mxrhandle,chr(13)+chr(12))   && send eject, control-L
  else
    fwrite(mxrhandle,chr(13)+chr(10)+chr(12))   && send eject, control-L
  endif
  mxrsetprc(0,0)
  return .t.


function mxr(atrow,atcol,astr)   && MXR

  local ii

  if mxrscrn   && if set to screen
    @ mxrrow,mxrcol say astr
  else         && when set to printer redirect
    if atrow>mxrrow
      for ii=mxrrow to atrow
        fwrite(mxrhandle,chr(13)+chr(10))   && carriage return, line feed
      next
      mxrcol=0
    endif
    if atrow<mxrrow
      mxreject()
    endif
    if atcol<mxrcol
      fwrite(mxrhandle,chr(13))   && carriage return
      if atcol>0
        fwrite(mxrhandle,space(atcol))   &&  overstrike
      endif
    else
      fwrite(mxrhandle,space(atcol-mxrcol))   && advance position
    endif
    mxrcol=atcol
    if .not. empty(astr)
      fwrite(mxrhandle,astr)   &&  print text
      mxrcol=mxrcol+len(astr)
    endif
  endif
  return .t.


function onscreen(fname)    && ONSCREEN

  run(.t.,"notepad.exe "+fname)
  return .t.


function mxprset(set_on,tomode)

  local p1,r1,tt

  if mxrscrn
    return .f.
  endif
  r1 = mxrrow
  p1 = mxrcol
  && Modes are: 1-compressed, 132 to 80 col mode
  &&            2-double wide
  &&            3-NLQ printing
  &&            4-bold
  &&            5-landscape (Lasers)
  &&            6- compressed,8-lines/in (Lasers)
  setprc(0,0)
  tt=" "
  do case
    case mxprtype=0
      && IBM compatible
      if set_on
        do case
          case tomode=1
            tt=chr(27)+chr(15)
          case tomode=2
            tt=chr(27)+"W1"
          case tomode=3
            tt=chr(27)+"G"
          case tomode=4
            tt=chr(27)+"E"
        endcase
      else
        do case
          case tomode=1
            tt=chr(27)+chr(18)
          case tomode=2
            tt=chr(27)+"W0"
          case tomode=3
            tt=chr(27)+"H"
          case tomode=4
            tt=chr(27)+"F"
        endcase
      endif
    case mxprtype=1
      && HP Laserjet 2
      if set_on
        do case
          case tomode=1
            tt=chr(27)+"(10U"+chr(27)+"(s0p16.67h8.5v0s0b0T"
          case tomode=6
            tt=chr(27)+"(10U"+chr(27)+"(s0b16.67H"+chr(27)+"&l8D"+chr(27)+ ;
              "0s0b0T"
        endcase
      else
        do case
          case tomode=1
            tt=chr(27)+"(10U"+chr(27)+"(s0b10h12V"
          case tomode=6
            tt=chr(27)+"(10U"+chr(27)+"(s0b10h12V"
        endcase
      endif
    case mxprtype=2
      if set_on
        do case
          case tomode=1
            tt=chr(27)+"(10U"+chr(27)+"(s0p16.67h8.5v0s0b0T"
          case tomode=6
            tt=chr(27)+"(10U"+chr(27)+"(s0b16.67H"+chr(27)+"&l8D"+chr(27)+ ;
              "0s0b0T"
        endcase
      else
        do case
          case tomode=1
            tt=chr(27)+"(10U"+chr(27)+"(s0b10h12V"
          case tomode=6
            tt=chr(27)+"(10U"+chr(27)+"(s0b10h12V"
        endcase
      endif
  endcase
  if .not. empty(tt)
    mxr(0,0,tt)
  endif
  mxrsetprc(r1,p1)
  return .t.


function clrscrn

  @0,0 clear
  return .t.


function lockit( oktoabort )   && LOCKIT

  local locktries,result

  if pcount()=0
    oktoabort=.f.
  endif
  result=.f.
  locktries=0
  do while .t.
    if rlock()
      result=.t.
      exit
    else
      inkey(2)
      locktries=locktries+1
      if locktries>=3
        @ 21,2 say "["+trim(alias())+"] Data In Use - "+ ;
          "Please Wait - "+ltrim(transform(locktries,"9999"))+" Tries"
        if oktoabort
          result=.f.
          exit
        endif
        @ 21,2
        locktries=0
      endif
    endif
  enddo
  return result


function unlockit   && UNLOCKIT

  unlock
  return .t.


