******************************************************************************
***** Module: WN_SEARC                                                   *****
***** Author: Jim Holley                                                 *****
***** Date  : 07/18/87                                                   *****
***** Comments:                                                          *****
***** This is an example program showing some features and uses of the   *****
***** Windows For Clipper Library. This routine performs a visual        *****
***** sequential search of the database. The search is performed once    *****
***** under program control and then under an operators control.         *****
***** The database used is the Customer.DBF file included with the       *****
***** Windows For Clipper package.                                       *****
******************************************************************************
srch_cust = "Fox & Geller, Inc.            "
CLEAR
***** create a window to display the search *****
search_wn = _SINIT_WN(20,19,40,4)
***** set window border character *****
_SST_WNBC(search_wn, 176)
***** we are not going to set the window colors *****
***** window is ready, open the data file *****
USE customer
***** tell operator what we are doing.
@ 01,18 SAY "ͻ"
@ 02,18 SAY "  This is a demonstration of the Windows     "
@ 03,18 SAY "  For Clipper routines. This module will     "
@ 04,18 SAY "  demonstrate the a visual sequential        "
@ 05,18 SAY "  search.                                    "
@ 06,18 SAY "                                             "
@ 07,18 SAY "                                             "
@ 08,18 SAY "                                             "
@ 09,18 SAY "                                             "
@ 10,18 SAY "                                             "
@ 11,18 SAY "                                             "
@ 12,18 SAY "ͼ"
***** request a key press *****
@ 10,25 SAY "Press any key to continue..."
SET CONSOLE OFF
WAIT
SET CONSOLE ON
@ 10,25 SAY "                             "
***** draw the window on the screen *****
_SDRW_WN(search_wn)
***** now tell the operator that we are searching *****
@ 11,35 SAY "Searching..."
***** set up the search algorythim *****
DO WHILE .NOT. EOF()
   ***** display the current customer name in search window *****
   _SWTE_RECS(search_wn, comp_name)
   ***** search conditions *****
   IF comp_name = srch_cust
      EXIT
   ENDIF
   ***** move to the next record *****
   SKIP
ENDDO
@ 11,35 SAY "            "
IF .NOT. EOF()
   @ 9,25 SAY "Found at record " + LTRIM(STR(recno()))
ELSE
   @ 9,28 SAY "Customer Not Found."
ENDIF
***** request a key press *****
@ 10,25 SAY "Press any key to continue..."
SET CONSOLE OFF
WAIT
SET CONSOLE ON
@ 09,25 SAY "                             "
@ 10,25 SAY "                             "
***** tell operator how to exit *****
@ 7,25 SAY "Press The Escape Key To Exit."
***** erase the window from the screen *****
_SWNERASE(search_wn)
***** Ok, set up for operator assisted search *****
***** set up infinite loop *****
DO WHILE .T.
   ***** reset record pointer. *****
   GO TOP
   ***** ask operator who to search for *****
   @ 08,21 SAY "Please Enter the Customers Name to"
   @ 09,21 SAY "search for :" GET srch_cust
   READ
   CLEAR GETS
   ***** clear prompt portion of text.
   @ 08,21 SAY "                                           "
   @ 09,21 SAY "                                           "
   ***** allow for a way to terminate the program *****
   IF TRIM(srch_cust) < ' ' .OR. LASTKEY() = 27
      EXIT
   ENDIF
   ***** draw the window on the screen *****
   _SDRW_WN(search_wn)
   @ 11,35 SAY "Searching..."
   ***** set up the search algorythim *****
   DO WHILE .NOT. EOF()
      ***** display the current customer name in search window *****
      _swte_recs(search_wn, comp_name)
      ***** search conditions *****
      IF comp_name = srch_cust
         EXIT
      ENDIF
      ***** move to the next record *****
      SKIP
   ENDDO
   @ 11,35 SAY "            "
   IF .NOT. EOF()
      @ 9,25 SAY "Found at record " + LTRIM(STR(recno()))
   ELSE
      @ 9,28 SAY "Customer Not Found."
   ENDIF
   ***** request a key press *****
   @ 10,25 SAY "Press any key to continue..."
   SET CONSOLE OFF
   WAIT
   SET CONSOLE ON
   @ 09,25 SAY "                             "
   @ 10,25 SAY "                             "
   ***** erase the window from the screen *****
   _SWNERASE(search_wn)
ENDDO   
RETURN
