@echo off
cls
echo ======== Introductory tutorial to Q calculator =========
echo.
echo This tutorial batch file will run Q with various examples.  
echo During the run of the tutor.bat,  files "A" and "C" are generated.
echo Also, the tutorial uses a data file "B".
echo Press any key when prompt to do so and the tutorial will guide you
echo through the basic steps.
echo.
echo Let's start with the simplest calculation. To calculate 2+3 use: q 2+3
echo Note that every line starts with q which is the program's name.
pause
echo q 2+3
q 2+3
echo To compute 2(3+4pi)5 where pi is the constant 3.14... type: q 2(3+4pi)5
pause
echo q 2(3+4pi)5
q 2(3+4pi)5
echo To obtain a table of x^3 with x from 0 to 100 write: q x^3 
echo Using "more" will show one page at a time.
pause
@echo on
q x^3 | more
@echo off
echo Substitution is simple. For example Jack=4; Jim=6; Jack+Jim; Jack-Jim
echo will result in ...
pause
echo q Jack=4; Jim=6;  Jack+Jim;  Jack-Jim
q Jack=4;  Jim=6;  Jack+Jim;  Jack-Jim
echo To solve an equation with x as unknown just write it. 
echo Sometimes you should use rng() to redefine the range of x in which to look 
echo for a solution. For example  rng(-10,10)2x+x^3=1/3
echo If there is more than one solution - the program will always display 
echo the smallest solution in the range. 
echo If you don't use rng, the range is 0 to 100.
pause
echo q rng(-10,10)2x+x^3=1/3
q rng(-10,10)2x+x^3=1/3
echo To write into a file use greater then sign. Let's examine the expression
echo q rng(0,360)sin(dr(x));cos(dr(x))
echo here sine and cosine functions are calculated. 
echo x is in degrees from 0 to 360 deg (defined by rng().
echo note that dr transfers x from degrees to radians. We have to use dr() 
echo because the sine and cosine accept only radians.
echo A semicolon ; is used to separate expressions. To write the resulting
echo table to a file "A" add the greater-then sign and A as in the following 
pause
@echo on
q dr(x);rng(0,360)sin(dr(x));cos(dr(x)) > a
@echo off
echo DONE!
echo You may use \DOS\EDIT to see the file "a". 
echo Don't forget to press ALT-f, x to exit when you are done.
echo The 1st column are the radians, in the 2nd the sine and in 
echo the 3rd cosine. 
pause
echo \dos\edit a.
\dos\edit a.
echo.
echo To see the sine column in file "a" as a function of the x column 
echo type: q g~a
echo This will display the second column as a function of the first.
echo Note: when done watching a graph press any key to continue.
pause
q g~a
echo To display the 3rd column as a function of the 2nd skip a column 
echo using one / and type q g~/a. A circle will result.
pause
q g~/a
echo to see just the cosine (column 3) in file "a" type y~//a, 
echo this will display the 3rd column as a function of the index.
pause
q y~//a
echo q 2x*y~/a will of course result in a table where y is obtained from 
echo column 2, x runs from 0 to 100.
pause
echo q 2x*y~/a
q 2x*y~/a
echo To display a function use grf(). For example, to see the 
echo log of x, x running from 0.00001 to 1 type q rng(0.0001,1)grf(log(x)):
pause
q rng(0.00001,1)grf(log(x))
echo To do statistics with data from a file use s~file-name. As an example
echo we prepared the file b. We shall use "type b" to see it's contents.
pause
type b
echo The first 2 lines are always ignored by the program and may be used
echo as headers. To do statistics on the 2nd column use: q s~/b
pause
echo s~/b
q s~/b
echo To see the high correlation between column 3 (gym) and column 4 (history)
echo we use q s~//b
pause
q s~//b
echo r is a random variable in the range 0 to 1. We can use r to simulate a
echo noisy sine wave. q grf(sin(x/10)+0.3(0.5-r)) will do. 
pause
q grf(sin(x/10)+0.3(0.5-r))
echo Q provides for change of base (2-36) and bitwise operations.
echo To read a number in a base n add [n] in from of that number.
echo To display a result in a specific base n, add [n] at the end of the 
echo expression. For example, [2]10001001000100100110101[16] will convert
echo from binary to hex bases.
pause 
echo q [2]10001001000100100110101[16]
q [2]10001001000100100110101[16]
echo to read data in a different base n from a file add [n] in front of the
echo file-name.
echo Let's prepare a binary file and read it later.
echo The following expression i;2x^3[2] will write the indexed table
echo into file C provided we use the greater than sign in front of "C".
pause 
@echo on
q i;2x^3[2] > c
@echo off
echo DONE!
echo Let's call \DOS\EDIT to see how it looks like.
pause
echo \dos\edit c
\dos\edit c
echo Now let's use it in a graph. grf(y)~/[2]c will read the data in the 2nd
echo column and plot. The program will read up to 32 bit numbers from a file.
pause
q grf(y)~/[2]c
echo Bitwise operators may be put into [] to prevent confusion.
echo For example [2]100100010001000 [_and] [2]100101010[2] will perform 
echo bitwise AND and display the result in binary format.
pause
echo q [2]100100010001000 [_and] [2]100101010[2]
q [2]100100010001000 [_and] [2]100101010[2]
echo You can test logical expressions. The convention is that 0 is FALSE
echo and anything else is TRUE.
echo For example: not( (2 GT 1) and ( 3 [EQ] 7 ) ) should result with 1. 
echo We used [] otherwise the E in EQ is confused with an exponent.
pause
echo not( (2 gt 1) and ( 3 [eq] 7 ) )
q not( (2 gt 1) and ( 3 [eq] 7 ) )
echo.
echo This concludes our little tour.
echo To find more about the Q calculator run it and read the help screens. 
echo Enjoy.

