/****************************************************************************
 *   FILE PCBDEMO.C                                                         *
 *   Created 01-MAY-1993            Rickie W. Belitz                        *
 *                                  820 Brentwood Drive                     *
 *                                  Maryville, Tennessee  37804             *
 *                                  BBS (615) 690-8231                      *
 *                                      (615) 690-7968                      *
 *                                      (615) 690-7913                      *
 *                                                                          *
 *        This small demo demostates obtaining conference information       *
 *   from the pcboard.sys file read by CKIT.  ck_pcbsysbuf is a pointer to  *
 *   the buffer used by CKIT to read the pcboard.sys file to.  This same    *
 *   buffer will be written to the pcboard.sys file when the door closes.   *
 *   Therefore, any changes made to the pcboard.sys buffer (ck_pcbsysbuf)   *
 *   will be recorded to pcboard.sys when the door closes.  This demo shows *
 *   how to obtain conference information from the pcboard.sys file.        *
 *   PCBoard conference information is stored in the pcboard.sys file       *
 *   in two different locations using bitmaps.  For conferences             *
 *   0-39 this offset is 66 for conferences the user has joined and offset  *
 *   71 for conferences the users has scanned.  (5 bytes each).             *
 *   For conferences 40 and greater this offset is 144 for conferences the  *
 *   users joined and following this is conferences the users has scanned.  *
 *                                                                          *
 *  The upper two conference fields are bit mapped just like the two fields *
 *  at offsets 66 and 71 respectively. One key difference with these,       *
 *  however, is that they apply only to conferences beyond conference #39   *
 *  and that they  are dynamically sized at the byte level depending on     *
 *  how many conferences the sysop is running on his PCBoard system.        *
 *  Examples:                                                               *
 *                                                                          *
 *    High Conf Number    Extended Conferences    Dynamic Size (bytes)      *
 *    ----------------    --------------------    ------------              *
 *         < 39                    0                   0                    *
 *          40                     1                   1                    *
 *          50                    11                   2                    *
 *         100                    61                   8                    *
 *                                                                          *
 *  The demo opens pcboard.dat and will expect an enviroment variable to    *
 *  find where the file is located and the name.                            *
 *  i.e. SET PCBDAT=C:\PCB\PCBOARD.DAT.  It then will open the pcboard.dat  *
 *  file to determine the max. number of conferences the sysop has allocted.*
 *  It will simply display each conference the user has joined and scanned  *
 *  for messages.                                                           *
 *                                                                          *
 *  Use freely and modify as needed for use in conjunction with the         *
 *  CKIT door programming libs.                                             *
 ****************************************************************************/
#include    "pcbdemo.h"

/******************************************************************************
 *                     Start of Main Program                                  *
 *****************************************************************************/
main(int argc, char **argv) {
short   result, i;
char    *ptr, *des;
    FORCEOFFHOOK = TRUE;             /* Default is FALSE                      */
    USERSFILE = FALSE;               /* Default is FALSE anyway...            */
    NO_FKEYS = FALSE;                /* Default is FALSE anyway...            */
    DOTS = FALSE;                    /* Default is FALSE anyway...            */
    ck_NO_STATUS = FALSE;            /* Enable Status line on local screen    */
    silent = FALSE;                  /* Turn on local beeps(default is FALSE) */
    logoff_color = (green);          /* Logoff msg to green (default=magenta) */
    ck_logoff_msgs = &logoffs[0];    /* Set message table to demo msgs        */
    ck_gen_msgs    = &ckit_msgs[0];  /* Set message table to demo msgs        */
    set_kybd_time(2,6);              /* Beep time 2, timeout 6 minutes        */
    OPENED = FALSE;
    if (argc > 1) {                  /* (default is 3, 5 minutes)             */
        result = open_door(argv[1], argv[2]);
        if(!PCB) {
            s_printf("Must use PCBOARD.SYS 14.5A or greater\n");
            exit(1);
        }
        ck_graphics |= ck_ansi_ng;
        if(!result) {
            OPENED = TRUE;      /* Door has been opened               */
            atexit(shut_down);  /* call shut_down at exit time        */
        } else {
            OPENED = FALSE;     /* Door open failed for some reason   */
            exit(1);
        }
    }
    if(read_pcbdat()) {     /* Read pcboard.dat file */
        exit(1);
    }
    display_conferences();
}

/******************************************************************************
 *           Display conference information from pcboard.sys                  *
 *****************************************************************************/
#define  CONFS  66          // Regular conferences 0-39   offset in pcboard.sys
#define  XCONFS 144         // Extended conferences 40-?? offset in pcboard.sys

void display_conferences(void) {
    BYTE    *joined, *scanned;
    short   HighConf, Bytes, i, XConfs;


/* Obtain high conference number read from pcboard.dat */
    HighConf = atoi(pcboard_dat.high_conference);
    s_printf("\n\rTotal conferences allocated = %d", HighConf);
    s_printf("\n\rLast conference joined = %d", ck_last_conf);

/* Print conferences user has joined for conferences 0-39 */
    s_printf("\r\n\r\nLower 0-39 Conferences joined - ");
    joined = ck_pcbsysbuf + CONFS;      /* Lower conferences buffer offsets */
    scanned = joined + 5;
    for(i = 0; i < 39; i++) {
        if(get_mapbit(i, joined)) {
            s_printf("%d ", i);
        }
    }
/* Print conferences user has scanned for conferences 0-39 */
   s_printf("\n\r\nLower 0-39 Conferences scanned - ");
   for(i = 0; i < 39; i++) {
        if(get_mapbit(i, scanned)) {
            s_printf("%d ", i);
        }
    }
/* Find out how many bytes used to store conference information  >= 40 */
    if(HighConf > 39) {
        XConfs = HighConf - 39;   /*  Find out how many Xtended conferences */
        Bytes  = XConfs;
        Bytes =  XConfs / 8;      /* Find number of bytes used */
        if(XConfs % 8) {
            Bytes += 1;
        }
        joined = ck_pcbsysbuf + XCONFS;  /* Xtnded conferences buffer offsets */
        scanned = joined + Bytes;
/* Print conferences user has joined for conferences 40 and greater */
        s_printf("\n\r\nXtended Conferences joined - ");
        for(i = 0; i < XConfs; i++) {
            if(get_mapbit(i, joined)) {
                s_printf("%d ", i+40);
            }
        }
/* Print conferences user has scanned for conferences 40 and greater */
        s_printf("\n\r\nXtended Conferences scanned - ");
        for(i = 0; i < XConfs; i++) {
            if(get_mapbit(i, scanned)) {
                s_printf("%d ", i+40);
            }
        }
    }
}

/******************************************************************************
 * Read a specific bit from a conference's bitmap                             *
 * Returns 0 if bit is OFF, 1 if bit is on.                                   *
 ******************************************************************************/
BYTE get_mapbit(unsigned confno, BYTE *Bitmaps) {
unsigned byteno, bitno;
    byteno  = (confno >> 3);
    bitno   = confno % 8;
    return((*(Bitmaps+byteno) >> bitno) & 1);
}
/******************************************************************************
 * Set  a specific bit in a conference's bitmap                               *
 ******************************************************************************/
void set_mapbit(unsigned confno, BYTE MapNo, BYTE flag, BYTE *Bitmaps) {
unsigned byteno;
unsigned bitno;
    byteno = (confno >> 3);
    bitno  = confno % 8;
    if(flag) {
        *(Bitmaps+byteno) |= (1 << bitno);
    } else {
        *(Bitmaps+byteno) &= 255 - (1 << bitno);
    }
}

/******************************************************************************
 *                     Read pcboard.dat file                                  *
 *****************************************************************************/
short    read_pcbdat(void) {
char    *buffer;
short   pcbdat_handle;
unsigned char i;
size_t  bytes_read;
short   lines_read;
    pathptr = getenv("PCBDAT");  /* For the newer pcboard 14.5 */
    if(pathptr) {
        buffer = create_buffer(BUFFER_SIZE);
        pcbdat_handle = open_file(pathptr);
        if(!pcbdat_handle) {
            s_printf("\aError opening %s!\n\r", pathptr);
            return(1);
        }
        bytes_read = read_record(pcbdat_handle, buffer, BUFFER_SIZE);
        if(!bytes_read) {
            s_printf("\aError reading %s!\n\r", pathptr);
            return(1);
        }
        _dos_close(pcbdat_handle);
        lines_read = parse_to_C(buffer, bytes_read);
        copy_buffer(buffer, dat_ptrs, pcb_maxbytes);
        free(buffer);
        return(0);
    }
    s_printf("\aNo PCBDAT found in enviroment!\n\r");
    return(1);
}

/*****************************************************************************
 *  Open a file for read only, share deny none                               *
 *****************************************************************************/
short  open_file(char *filename) {

    short filehandle;
                             /* RDONLY */
    if ((_dos_open(filename, O_RDONLY | SH_DENYNO, &filehandle)) != 0) {
        return(FALSE);
    }
    return(filehandle);
}
/*****************************************************************************
 *  Read buffersize bytes from file to buffer pointer                        *
 *****************************************************************************/
size_t read_record(short filehandle, BYTE *record, size_t readcount) {

    size_t    bytes_read;

    if ((_dos_read(filehandle, record, readcount, &bytes_read)) != 0) {
        return(FALSE);
    } else {
        return(bytes_read);
    }
}
/*****************************************************************************
 *  Allocate a buffer for file use                                           *
 *****************************************************************************/
char * create_buffer(size_t size) {

    char *buffer;

    if ((buffer = (char *)malloc(size)) == NULL) {
        s_printf("Unable to allocate memory\n");
        return(FALSE);
    }
    return(buffer);
}
/*****************************************************************************
 * Parse strings ending (with 0D/AH) to NULL terminated 'C' strings          *
 * Enter with buffer to parse and size of buffer.                            *
 * It will write the C strings back to the same buffer it is reading from    *
 * and return the number of line converted (strings)                         *
 *****************************************************************************/
short   parse_to_C(register char *buffer, size_t bytes_to_do) {
register char    *buffer1;
short   line_number = 0;

    buffer1 = buffer;
    while(bytes_to_do != 0) {
        if(*buffer != 0x0D && *buffer != 0x1A) {  /* Check if C/R or EOF  */
                *buffer1++ = *buffer++; /* copy byte                        */
                bytes_to_do -= 1;       /* Decrement number of bytes to do  */
        } else {
            if(*++buffer == 0x0A) {     /* Check for line feed              */
                *buffer = '\0';         /* Terminate string with NULL       */
                line_number += 1;       /* Increment line counter           */
            } else {
                *buffer1++ = *buffer;
            }
            bytes_to_do -= 1;           /* Decrement number of bytes to do  */
        }
    }
    return(line_number);                /* Return number of lines read      */
}

/*****************************************************************************
 * Copy a block of strings in memory to strings allocated for the strings.   *
 * Enter with buffer to read strings from, array of pointers to the strings, *
 * and an array containing the max. bytes allowed for the strings.           *
 *****************************************************************************/
void    copy_buffer(char *buffer, char **dat_ptr, char *pcb_maxbytes) {

unsigned char i;
char    *pcbdata_ptr;

    for (i=0; i <= ( (sizeof(dat_ptrs) / sizeof(char *) ) - 1); i++) {
        pcbdata_ptr = dat_ptr[i];
        buffer = str_move(pcbdata_ptr, pcb_maxbytes[i], buffer);
    }
}

/*****************************************************************************
 *  Copy a string from memory to a string location.  Enter with pointer to   *
 *  string destination, string source and max. number of bytes allowed for   *
 *  the string. (size of string).  If exceeded, it will terminate string     *
 *  with a NULL. Returns a pointer equal to next one plus string length.     *
 *****************************************************************************/
char *  str_move(register char *data_ptr, unsigned char max_bytes, register char *buffer) {
    if(max_bytes >= 1) {
        max_bytes -= 1;
        while(*buffer != '\0' && max_bytes != 0) {
            *data_ptr++ = *buffer++;
            max_bytes -= 1;
        }
    }
    *data_ptr = '\0';
    *buffer++;
    return(buffer);
}
/****************************************************************************
 *      Close door, reset vectors etc.                                      *
 *  Need in case of a run time error occurs in door                         *
 ****************************************************************************/
 void   shut_down(void) {
    if(OPENED && !CLOSED) {
        close_door();
        CLOSED = TRUE;
    }
}
/****************************************************************************
 *      s_printf() function for sending output to port                        *
 ****************************************************************************/
void s_printf(char *s_format,...) {
    va_list arg_pointer;
    char buffer[256];
    va_start(arg_pointer, s_format);
    vsprintf(buffer, s_format, arg_pointer);
    s_puts(buffer);
    va_end(arg_pointer);
}
/****************************************************************************/
/************************ E N D  O F   M O D U L E **************************/

