/***************************************************************************

Date: 12/11/91

Author: Jim Dailey 1:202/309

Name: MailQue.Cmd

Description:  This batch file is an example mail a processing front end
              for Binkley/Maximums systems, and allows background mail
              processing while Binkley is online.  This procedure removes
              the problem of Binkley loosing the com port because the 
              background mail process inherited the initiators handles.

              This procedure uses the REXX "rxqueue" function for 
              communications with the Binkley batch file therefore 
              eliminating a wait loop looking for a semaphore file.
              

              The assumed REXX que name is "MailProc".  To process your
              incoming mail in the background, place the following at 
              in your binkley batch file where you would normally start
              your mail processing:

                       "echo mailproc | rxqueue mailproc"

              If your Binkley batch file is written in REXX, the quotes
              are REQUIRED.


Dependencies: This batch file must be started prior to processing the
              first batch of mail.

***************************************************************************/
"@ECHO OFF"

MailBatchFile = "G:\Binkley\ProcMail"     /* The name of our background 
                                             mail processing batch file  */

NewQId = rxqueue("Create","MailProc")     /* create the queue             */  
OldQName = rxqueue("Set","MailProc")      /* use the new queue            */
Call on Halt Name Stopit                  /* allow ctrl-c to terminate me */ 

Say date('N') Time('N') "MailQue Waiting For Work"
ProcCount = 0

Do Forever
   data = Linein("QUEUE:")                /* wait for input on the queue  */

   data = Translate(data)                 /* convert to upper case        */

   If data <> "STOP"     Then             /* mail process request?        */
      Do
         Say ' '
         ProcCount = ProcCount + 1        /* count number of batches      */
         Say date('N') Time('N') "Processing Mail Batch" ProcCount 
         detach data

      End
   Else
      If data = "STOP" then               /* request to stop via the que  */
         Signal Stopit
      Else                                
          Say date('N') Time('N') data "Is an unknown command"
End

Stopit:
   Call rxqueue "Delete","MailProc"       /* delete the queue             */
   Say date('N') Time('N') "MailQue has terminated"
