    '   Program Name:    CICA2CQ.BAS
    '     Written by:    William C. Kotheimer Jr.
    '           Date:    10 September 1992
    '          Using:    MicroSoft QBasic
    '    Description:    Converts CICA index file into a comma-and-quotes
    '                    text file that can be converted into an X.dbf
    '                    format file by many PC-based DBMS'

    '***  Opening banner
    CLS
    PRINT "     CICA INDEX TO DATABASE COMMA AND QUOTES FILE"
    PRINT "             Written by Will Kotheimer"
    PRINT " "
   
    '***  Get Cica index file name and output file name
    PRINT " Using full path and file names,"
    INPUT " Enter CICA index file name:    ", CICA$
    INPUT "     Enter OUTPUT file name:    ", CICAOUT$
   
    '***  Open Output and input files
    OPEN CICAOUT$ FOR OUTPUT AS #1
    OPEN CICA$ FOR INPUT AS #2
    CLS
   
    ' *** Read lines from input file
    CLS
    PRINT "    BEGINNING PROCESSING"
    PRINT " "
    DIR$ = " "
    FIRST$ = " "
    DO WHILE NOT EOF(2)
        LINE INPUT #2, REC1$   'Read entries from file.
        FIRST$ = LEFT$(REC1$, 1)
        IF FIRST$ = "*" THEN  ' Test for breaks between directory listings
                FOR I = 1 TO 80
                        TEST$ = MID$(REC1$, I, 1)
                        IF TEST$ = "~" THEN ' Test for directory name start
                                B = I + 17
                                DIR$ = MID$(REC1$, B, 20)
                                FOR J = 1 TO 20 'Test for dir name end
                                        IF MID$(DIR$, J, 1) = " " THEN
                                                DIR$ = LEFT$(DIR$, J)
                                                J = 20
                                        END IF
                                NEXT J
                       PRINT "PROCESSING DIRECTORY "; DIR$
                       END IF
                NEXT I
        ELSEIF FIRST$ <> " " THEN ' Reading in name, date, description
                NAME$ = MID$(REC1$, 1, 12)
                DTG$ = MID$(REC1$, 17, 6)
                DESCRPT$ = MID$(REC1$, 25, 55)
                IF NAME$ <> "" THEN
                WRITE #1, NAME$, DIR$, DTG$, DESCRPT$
                END IF
        END IF
    LOOP

    ' *** Closing files
    CLOSE #1
    CLOSE #2
    PRINT "    PROCESSING COMPLETED"
    PRINT "    FILE "; CICAOUT$; " GENERATED"
    END

