Program ChkLocal;
Uses Dos;

{$I Struct.200}

Var Rec     : MsgHdrRecord;
    Inp     : File of MsgHdrRecord;
    Out     : Text;
    Chk     : Text;

    Conf    : ConfigRecord;
    Tmp     : File;
    RR      : Word;

    Subj    : String;
    SysPath : PathStr;

Procedure CompletePath(Var P : PathStr);
Begin
P:=FExpand(P);
If (Length(P)>2) And (P[Length(P)]<>'\')
   Then P:=P+'\';
End;

Begin
WriteLn('LiveSystems Check Local attach directory 1.0');
WriteLn('Public Domain');
WriteLn;

SysPath:=GetEnv('RA');
If SysPath=''
   Then Halt;
CompletePath(SysPath);

FileMode:=$40;
Assign(tmp,SysPath+'CONFIG.RA');
Reset(tmp,1);
BlockRead(Tmp,Conf,SizeOf(Conf),RR);
Close(Tmp);
If RR=0
   Then Halt;


CompletePath(Conf.MsgBasePath);
CompletePath(Conf.AttachPath);

Assign(Inp,Conf.MsgBasePath+'MSGHDR.BBS');
Reset(Inp);
If IoResult<>0
   Then Halt;

Assign(Out,Conf.AttachPath+'DESCRIPT.ION');
SetFAttr(Out,0);
Rewrite(Out);

Assign(Chk,Conf.AttachPath+'CHECK.SUB');
Rewrite(Chk);

While Not Eof(Inp) Do
 Begin
 Read(Inp,Rec);
 If Pos(Conf.AttachPath,Rec.Subject)=1
    Then Begin
         Subj:=Rec.Subject;
         Delete(Subj,1,Length(conf.AttachPath));
         WriteLn(Out,Subj,' ',Rec.WhoFrom,' (',Rec.PostDate,', ',Rec.MsgNum,')');
         End
    Else WriteLn(Chk,Rec.PostDate,' ',Rec.Board:3,' ',Rec.Subject);
 Write(#13,Rec.MsgNum);
 End;
Close(Inp);
Close(Out);
Close(Chk);
End.

