#include <stdio.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <dir.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <time.h>


short get_the_date(char *input,short *day,short *month,short *year)
{
char *ptr;
short i;

if (!input || !*input) return -1;

while (NULL!=(ptr=strchr(input,'/'))) *ptr='.';
while (NULL!=(ptr=strchr(input,'-'))) *ptr='.';

*day=*month=*year=-1;

for (i=0,ptr=strtok(input,".");ptr;i++,ptr=strtok(NULL,"."))
         switch (i) {
             case 0: sscanf(ptr,"%hd",day);break;
             case 1: sscanf(ptr,"%hd",month);break;
             case 2: sscanf(ptr,"%hd",year);
                    }

if (*year!=-1 && *year<1900) *year+=1900;

return 0;
}


int main(int num, char *args[])
{
struct dosdate_t dat;
int i;
short year,day,month;
char *flagname=NULL;

         fprintf(stderr,"\nCheckDate tool v.1.0 by Andy Elkin.\n");

if (num<2) {
         fprintf(stderr,"Syntax: chkdate.exe <date1> [<date2>..]] [-F<flag name>]\n"
                        "If current date is one from date1,date2... returns 0 and creates <flag name>\n"
                        "Otherwise returns 1.\n"
                        "  Examples:\n"
                        "   Chkdate  10                 - checks if date is 10th\n"
                        "   Chkdate  12.02              - checks if date is 12th of February\n"
                        "   Chkdate  18.05.97           - checks if date is 18th of May 1997\n"
                        "   Chkdate  18/05/97           - the same as above\n"
                        "   Chkdate  5 20 -Fsalary.t-m  - checks if date is 5th or 20th and creates flag.\n"
                );

        exit(2);
           }


for (i=1;i<num;i++)
if (!strnicmp(args[i],"-F",2) || !strnicmp(args[i],"/F",2))
                                   {
                                   flagname=strdup(&args[i][2]);
                                   *args[i]=0;
                                   }



_dos_getdate(&dat);
for (i=1;i<num;i++)
{
if (!*args[i]) continue;
if (get_the_date(args[i],&day,&month,&year)) return 1;
if (day==dat.day && (month==dat.month || month==-1) && (year==dat.year || year==-1))
              {
       fprintf(stderr,"Current date matched argument list\n");
       if (flagname && *flagname) close(creat(flagname,S_IREAD | S_IWRITE));
       return 0;
              }
}


return 1;
}

