
"
chapman.st - ChapMan installation script
This script installs the ChapMan system
Execute the script by filing it in or invoking doit.
"

| srcDir dllDir appDir file doit newApp newApp2 chappClass regVer 
chapManDLL path valid version |
version := '13'.
[srcDir := Prompter
	prompt: 'Enter directory of the installation files'
	default: Disk fullDirName.
srcDir isNil ifTrue: [^nil].
srcDir := Directory pathName: srcDir.
(valid := srcDir valid and: [srcDir validFile: 'chapmres.dll']) ifFalse: [
	MessageBox message: 'Invalid directory'].
valid]
	whileFalse: [].

[dllDir := Prompter
	prompt: 'Enter directory where to put the DLLs'
	default: Disk fullDirName.
dllDir isNil ifTrue: [^nil].
dllDir := Directory pathName: dllDir.
dllDir valid ifFalse: [MessageBox message: 'Invalid directory'].
dllDir valid]
	whileFalse: [].

[appDir := Prompter
	prompt: 'Enter directory of the application .CLS and .CHA files'
	default: Disk fullDirName.
appDir isNil ifTrue: [^nil].
appDir := Directory pathName: appDir.
(valid := appDir valid and: [appDir validFile: 'ChapMan.CHA']) ifFalse: [
	MessageBox message: 'Invalid directory'].
appDir valid]
	whileFalse: [].

(regVer := srcDir validFile: 'chapm', version, 'r.dll')
	ifTrue: [chapManDLL := 'chapm', version, 'r']
	ifFalse: [chapManDLL := 'chapm', version, 'u'].

Transcript cr.
doit := true.
(Smalltalk includesKey: #ChApplication) ifTrue: [
	doit := MessageBox confirm: 'ChapMan already installed. Installing a new version causes all applications and class comments to be lost. You must have saved all applications in order to recreate them. In addition you must allow the reinitialization of the window system, which closes all windows. Proceed?'.
	doit ifTrue: [
		Transcript cr; show: 'Unbinding old ChapMan DLL...'.
		#('chapmu' 'chapmr' 'chapm11u' 'chapm11r' 'chapm12u'
		'chapm12r' 'chapm13u' 'chapm13r') do: [:each |
			(ObjectLibraryBind isBound: each) ifTrue: [
				ObjectLibraryBind unBind: each]
			]
		]
	].

doit ifTrue: [
	dllDir fullDirName ~= srcDir fullDirName ifTrue: [
		path := dllDir fullDirName.
		dllDir pathName trimBlanks size > 1 
			ifTrue: [path := path copyFrom: 1 to: path size - 1].
		Transcript cr; show: 'Copying (new) DLL files...'.
		(Array with: 'chapmres.dll' with: chapManDLL, '.dll') do: [:each |
			File copy: srcDir fullDirName, each to: path]
		].

	file := appDir fileReadOnly: 'BugFix20.cls'.
	Transcript cr; show: 'Filing in ', file pathName, '...'.
	file fileIn; close.

	Transcript cr; show: 'Binding object library ', chapManDLL, '...'.
	ObjectLibraryBind bindTo: chapManDLL.

	(ObjectLibraryBind isBound: 'vpmolb20') ifFalse: [
		Transcript
			cr; show: 'Object Library Builder not installed.';
			cr; show: 'Binding object library vpmolb20.dll...'.
		ObjectLibraryBind bindTo: 'vpmolb20'].
		
	file := srcDir fileReadOnly: 'ChapMInt.cls'.
	Transcript cr; show: 'Filing in ', file pathName, '...'.
	file fileIn; close.

	Transcript cr; show: 'Filing in application data...'.
	chappClass := Smalltalk at: #ChUserApplication.
	chappClass configVariables at: 'DirectoryCHA' put: appDir.
	#('ChapMInt.cha') do: [:each |
		newApp := chappClass newFromFile: each
			subApplications: true installSource: false.
		newApp isNil ifTrue: [
			^MessageBox message: 'Error during installation of applications.']
		ifFalse: [
			chappClass subApplication: newApp of: nil]
		].
	
	Transcript cr; show: 'ChapMan installed.'; cr.
	MessageBox message: 'Reinitialization of the window system will be done.'.
	Notifier reinitialize]

ifFalse: [
	Transcript cr; show: 'Installation aborted'] !
