"Initialization code"
 !



!String methods !
  
fileExtension
		"Answer a character String that follows the receiver's 
		last period character."
		"@08.05.94 ch: don't require 3 character extensions (e.g. HPFS)"  
	self size to: 1 by: -1 do: [:i |
		(self at: i) = $. ifTrue: [^self copyFrom: i+1 to: self size]].
	^String new! !



!String class methods ! !



!SortedCollection methods !

collect: aBlock
        "For each element in the receiver, evaluate aBlock with
         that element as the argument.  Answer a new collection
         containing the results as its elements from the aBlock
         evaluations."
		"@25.02.94 ch: Creation"
    | answer |
    answer := OrderedCollection new.
    self do: [ :element |
        answer add: (aBlock value: element)].
    ^answer!

select: aBlock
        "For each element in the receiver, evaluate
         aBlock with that element as the argument.
         Answer a new collection containing those elements
         of the receiver for which aBlock evaluates to true."
    | answer |
    answer := self class sortBlock: sortBlock.
    self do: [ :element |
        (aBlock value: element)
            ifTrue: [answer add: element]].
    ^answer! !



!SortedCollection class methods ! !



!Dictionary methods !
 
addAll: aCollection
		"Answer aCollection. Add each element of aCollection to 
		the elements of the receiver. Check if aCollection is a 
		dictionary." 
		"@22.06.94 ch: Creation"
	(aCollection isKindOf: Dictionary) ifFalse: [
		^super addAll: aCollection].
    aCollection associationsDo: [ :element | self add: element].
    ^aCollection! !



!Dictionary class methods ! !



!SystemDictionary methods !
 
startUp
		"Private - Initialize a Smalltalk/V session
          and file in the 'go' file."
		"@11.09.94 ch: bug fix from Digitalk" 
	| f |
    MemoryBlockAddress startUp.
    DosLibrary := DosDLL open.
    PMWindowLibrary := PMWindowLibraryDLL open.
    PMGraphicsLibrary := PMGraphicsLibraryDLL open.
    PMShellLibrary := PMShellLibraryDLL open.
    VPMVM := VPMVMDLL open.
    NlsLibrary := NLSDLL open.
    NationalLanguage initialize.
    DosLibrary error: 0.
    PM getIt.
    TextEdit startUp.
    Disk := Directory current.
    FileHandle initHandles.
    Sources := Array new: 3.
    Smalltalk isRunTime ifFalse: [
        f := Disk file: 'go'.
        f size > 0
            ifTrue: [f fileIn; close]
            ifFalse: [f close. File remove: f pathName].
        (Sources at: 1) isNil ifTrue: [
            Sources at: 1 put:
                (File pathNameReadOnly: 'sources.sml')].
        (Sources at: 2) isNil ifTrue: [
            Sources at: 2 put: (File pathName: 'change.log')].
        (Sources at: 3) isNil ifTrue: [
            Sources at: 3 put: self openDllSource]].
    CurrentProcess isNil ifTrue: [
        CurrentProcess := Process basicNew.
        CurrentProcess priority:  Processor userPriority.
        CurrentProcess initialize; makeUserIF].
    Processor initialize.
    CurrentEvents := OrderedCollection new.
    Process enableInterrupts: true.
    PMWindowLibrary postMsg: PM hwndClient msg: 30000 mp1: 0 mp2: 0.
    Notifier run! !



!SystemDictionary class methods ! !



!HelpManager methods !

displayHelp: id
		"Display the help panel identified by id
        id can be either an Integer or a String."
		"@30.08.94 ch: issue an error if id has the wrong type" 
		"@31.07.94 ch: OS/2 bug workaround: uppercase the passed string"
		"@12.02.94 ch: helpmanager bug workaround"
	| debug helpLabel |
	debug := false.
	debug ifTrue: [
		helpLabel := id.
		helpLabel isInteger ifTrue: [helpLabel := helpLabel printString].
		Transcript cr; nextPutAll: 'HelpManager displayHelp: ', helpLabel printString].

	id isString
        ifTrue: [
            ^(PMWindowLibrary 
                sendMsg: helpInstance
                msg: HmDisplayHelp
                mp1Struct: id asUpperCase asParameter
				"The HelpManager uppercases the string passed in,
				so make a copy to prevent modification.
				In addition if the string is not in uppercase the help
				manager fails to recognize certain strings."
                mp2: HmPanelname) asPMLong asInteger].
    id isInteger
        ifTrue: [
            ^(PMWindowLibrary 
                sendMsg: helpInstance
                msg: HmDisplayHelp
                mp1: id
                mp2: HmpaneltypeNumber )asPMLong asInteger].
	self error: 'invalid id type'! !



!HelpManager class methods ! !



!PMWindowLibraryDLL methods !
  
peekMsg: hab pqmsg: aStruct hwndFilter: aWindowHandle msgFilterFirst: anInt msgFilterLast: anInt2 fs: anInt3

        | answer a |
        a := PMAddress copyToNonSmalltalkMemory: aStruct asParameter.
        answer := self peekMsgReal: hab pqmsg: a asParameter hwndFilter: aWindowHandle msgFilterFirst: anInt msgFilterLast: anInt2 fs: anInt3.
        a free.
        ^answer!
  
peekMsgReal: hab pqmsg: aStruct hwndFilter: aWindowHandle msgFilterFirst: anInt msgFilterLast: anInt2 fs: anInt3
    <api: '#918' handle ulong handle ulong ulong ulong boolean>
    ^self invalidArgument! !



!PMWindowLibraryDLL class methods ! !



!SelectorBrowser methods !
  
updateMethods: compileResult
		"Private - update the method list or the current
         method with the newly compiled method."
		"@06.07.94 ch: bug fix: check for methods isNil" 
	selectedSelector = compileResult key ifTrue: [
		method := compileResult value]
	ifFalse: [
		methods isNil ifFalse: [
			super updateMethods: compileResult ]
		]! !



!SelectorBrowser class methods ! !



!Window methods !
 
wmChar: mp1 with: mp2
		"Private event - Add a MessageExpression to CurrentEvents
         and return right away."
		"@13.09.94 ch: bug fix: first check for virtual keys" 
	| c byte trailByte |
    ((mp1 lowHalf bitAnd: KcKeyup) ~=0) ifTrue: [^true].
    ((mp1 lowHalf bitAnd: KcVirtualkey) ~=0) ifTrue: [
        ((mp1 lowHalf bitAnd: KcAlt) = 0) ifTrue: [
            self sendInputEvent: #virtualKeyInput: with: mp2 highHalf.
            ^nil]
		].
    ((mp1 lowHalf bitAnd: KcChar) ~= 0)
        ifTrue: [
            byte := mp2 byteAtOffset: 0.  " SBC or DBC lead byte "
            trailByte := mp2 byteAtOffset: 1.  "DBC trail byte"
            (trailByte = 0)
                ifTrue: [
                    c := byte asCharacter.
                    (byte between: 32 "Space" and: 253 "$")
                        ifTrue: [self sendInputEvent: #characterInput: with: c]
                        ifFalse: [self sendInputEvent: #controlKeyInput: with: c]]
                ifFalse: [
                    c := Character value: ((byte bitShift: 8) + trailByte).
                    self sendInputEvent: #characterInput: with: c].
        ^nil].
    ^nil! !



!Window class methods ! !



!ApplicationWindow methods !
   
closeView
		"Private - Close the receiver and all its children."
		"@29.08.94 ch: bug fix: HelpManager didn't get destroyed" 
	| inner |
    inner := OrderedCollection new.
    Notifier windows do: [:w|
        ((w == self) not and: [
        (w isApplicationWindow) and: [
            PMWindowLibrary isChild: w handle parent: handle]])
                ifTrue: [inner add: w]].
    inner do: [:w| w textModified ifTrue: [^nil] ifFalse: [w clearTextModified]].
    inner do: [:w| w close].
    self textModified ifTrue: [^nil].
    self deactivate.
    self icon notNil ifTrue: [ self icon release ].

	"bug fix: HelpManager must be destroyed here because
	super close will set properties to nil."
    self helpManager notNil
        ifTrue: [self helpManager destroyHelpInstance].

    super close.
    Notifier remove: self.
    menuWindow close.
    children do: [:subpane | subpane close].
    PMWindowLibrary destroyWindow: self frameWindow handle.
    self initialize.!
   
hmHelpsubitemNotFound: mp1 with: mp2
        "Private - Show the appropriate help panel."
		"@19.11.93 ch: Work around for OS/2 bug" 
    | helpLabel helpManager helpMode idTopic idSubTopic menu result |
    helpMode := mp1 shortAtOffset: 0.
    idTopic := mp2 lowHalf.			" menu "
    idSubTopic := mp2 highHalf.	" menu item "
    helpMode = HlpmMenu
        ifTrue: [ idSubTopic = 65535 "Only a submenu but no item is selected."
            ifTrue: [
                self menuWindow menus do: [:menu |
                    ( menu menuItem id = idTopic )
                        ifTrue: [ helpLabel := menu title ]]]
            ifFalse: [
                menu := self menuWindow menuOf: idSubTopic.
                menu == (self menuWindow menuOf: idTopic)
                    ifTrue: [ helpLabel := ( menu selectorOf: idSubTopic ) asString ]
                    ifFalse: [ helpLabel := menu title ] ] ]
        ifFalse: [
            ((helpMode = HlpmFrame or: [helpMode = HlpmWindow])
            and: [children size >= idSubTopic])
                ifTrue: [helpLabel := (self childAtId: idSubTopic) name asParameter]].

    (helpManager := self helpManager) isNil 
        ifTrue: [helpManager := self pmOwner helpManager].
    (helpLabel isNil or: [helpManager isNil])
		ifTrue: [^false].
	^(helpManager displayHelp: helpLabel) = 0!
 
labelWithoutPrefix: aString
		"Set the window label of the receiver to aString
        without prepending 'Smalltalk/V '."
		"@09.09.94 ch: bug fix: check for a nil parent window (needed by OSI)" 
		"@06.11.93 ch : the window list was not updated"
	label := aString. 
    label size > 500 ifTrue: [label := label copyFrom: 1 to: 500].
        "Experimentally determined that labels more than 500 bytes
         cause PM to mess up the title bar."
    handle isNil ifTrue: [^self].
    handle isValid ifTrue: [
		parent isNil ifTrue: [
			self handle
				setWindowText: label;
				changeSwitchEntry: label]
		ifFalse: [
	        parent handle 
				setWindowText: label;
	    	    changeSwitchEntry: label]
		].! !



!ApplicationWindow class methods ! !



!DialogTopPane methods !
 
buildItems
        "Private - Build the control items within
         the dialog box.  Answer a ByteArray
        containing all the items."
		"@18.12.93 ch: inset the rectangle for childs, so they do not override the 
		border"  
    | answer items subpaneStyle rect text pmDlgItem strings stringsOffset
    offText cchClassName offClassName|
    answer := ByteArray new.
    strings := ByteArray new.
    items := OrderedCollection new.
    stringsOffset := 14 + 30 + (30 * children size).
    children do: [ :subpane |
        subpane style isNil ifTrue: [subpane style: subpane defaultStyle].
        ( subpane propertyAt: #noTabStop ) isNil ifTrue: [
            subpane addStyle: WsTabstop ].
        (subpane isKindOf: SubPane) ifTrue: [
            ((rect := subpane framingBlock) isKindOf: Context)
                ifTrue: [rect := rect value: 
					((0@0 extent: rectangle extent) insetBy: 2 @ 0)].
            text := (subpane respondsTo: #contents) 
                ifTrue: [subpane contents] 
                ifFalse: [nil].
            text class = String ifFalse:[
                text := nil].
            pmDlgItem := SelfDefinedStructure named: 'DLGTITEM'.
            offText := stringsOffset + strings size.
            text isNil ifFalse: [strings := strings, text asAsciiZ].
            (subpane windowClass isKindOf: String) 
                ifTrue: [
                    offClassName := stringsOffset + strings size.
                    cchClassName := subpane windowClass asAsciiZ size.
                    strings := strings, subpane windowClass asAsciiZ]
                ifFalse: [cchClassName := 0.
                    offClassName := subpane windowClass].
            items add: (
                pmDlgItem
                    cChildren: 0;
                    cchClassName: cchClassName;
                    offClassName: ( offClassName bitAnd: 16rFFFF );
                    cchText: text size;
                    offText: offText;
                    flStyle: WsVisible |  subpane style;
                    x: rect left asInteger;
                    y: rect bottom asInteger;
                    cx: rect width asInteger;
                    cy: rect height asInteger;
                    windowId: subpane getId ).
            subpane pmControlData notNil ifTrue: [
                pmDlgItem offCtlData: stringsOffset + strings size.
                strings := strings, subpane pmControlData contents ] ] ].
    items do: [:pmDlgItem | 
        answer := answer , pmDlgItem contents].
    ^answer , strings!

cancel
		"Close the window by default. This method was missing."
		"@05.08.94 ch: Creation"
    ^self close!
 
cancel: aTopPane
		"Close the window."
		"@06.08.94 ch: Creation"
	^self cancel!
 
wmChar: mp1 with: mp2
		"Private - Close when the Esc key is pressed."
		"@05.08.94 ch: bug fix: send #cancel instead of #close" 
	((mp1 lowHalf bitAnd: KcKeyup) ~=0) ifTrue: [^true].
    ((mp1 lowHalf bitAnd: KcVirtualkey) ~=0) ifTrue: [
		mp2 highHalf = VkEsc
            ifTrue: [self sendInputEvent: #cancel]].
    ^super wmChar: mp1 with: mp2! !



!DialogTopPane class methods ! !



!DialogBox methods !
   
hmHelpsubitemNotFound: mp1Param with: mp2Param
		"Private - Show the appropriate help panel."
		"@31.07.94 ch: bug fix: use #displayHelp:" 
	| helpLabel id appWindow |
    id := mp2Param highHalf.
    helpLabel := self itemIds at: id ifAbsent: [nil].
    helpLabel isNil ifTrue: [
        helpLabel := self itemIds keyAtValue: id].
    appWindow := self owner.
    appWindow isApplicationWindow ifFalse: [
        appWindow := appWindow child].
    helpLabel isNil
        ifTrue: [^false]
        ifFalse: [^(appWindow helpManager displayHelp: helpLabel) = 0]!
  
queryButton: itemId
        "Answer a boolean indicating the 'checked' state of
         the button whose id is itemId."
		"@23.05.94 ch: Bug fix: didn't support threestate buttons" 
    | checked |
    checked := PMWindowLibrary sendDlgItemMsg: handle item: itemId msg: BmQuerycheck mp1: 0 mp2: 0.
	checked = 2 ifTrue: [^nil].
    ^checked = 1!

setButton: itemId value: aBoolean
        "Set the 'checked' state of a radio button or check box
         to aBoolean."
		"@23.05.94 ch: Bug fix: didn't support threestate buttons" 
	| aValue |
	aBoolean isNil 
		ifTrue: [aValue := 2]
		ifFalse: [aValue := aBoolean].
    PMWindowLibrary
        sendDlgItemMsg: handle
        item: itemId
        msg: BmSetcheck
        mp1: aValue asParameter
        mp2: 0.! !



!DialogBox class methods !
  
parseDotHFile: aFileName
        "Create a method in the receiver (class)
         which initializes the ItemIds
         class variable to contain a Dictionary of
         mappings from item ids to item names (symbols)
         and vice versa. aFileName is .h file
         created by the Dialog Box Editor."
		"24.4.94 Bug fix: use pathNameReadOnly."
    | file key id method |
    file := File pathNameReadOnly: aFileName.
    method := (String new: 50) asStream.
    method nextPutAll: 'initItemIds'.
    method cr; nextPutAll: '    ItemIds := Dictionary new.'; cr.
    [file atEnd] whileFalse: [
        (file next = $# and: [file next = $d])
            ifTrue: [
                file skipTo: Space.
                key := file upTo: Space.
                id := (file upTo: Cr) trimBlanks.
                method
                    nextPutAll: '    ItemIds at: '; nextPutAll: id;
                    nextPutAll: ' put: #'; nextPutAll: key;
                    nextPut: $.; cr;
                    nextPutAll: '    ItemIds at: '; nextPut: $';
                    nextPutAll: key; nextPut: $';
                    nextPutAll: ' put: '; nextPutAll: id;
                    nextPut: $.; cr.
                file skipTo: Lf]
            ifFalse: [file skipTo: Lf]].
    file close.
    (self classVarNames includes: 'ItemIds') ifFalse: [
        self addClassVarName: 'ItemIds'].
    method := method contents.
    (self class compile: method) isNil
        ifTrue: [^false]
        ifFalse: [
            Smalltalk
                logSource: method
                forSelector: #initItemIds
                inClass: self class].! !



!SubPane methods !

doPopupMenuAt: aPoint
		"Private - Popup the pane's menu at aPoint."
		"@19.08.94 ch: changed: ???" 
	| previous menuBarMenu miBar miPopup |
    previous := popup.
    popup := self popupMenu.
    popup notNil ifTrue: [
        menuBarMenu := self mainWindow menuTitled: (popup title).
        menuBarMenu notNil ifTrue: [
            popup copyAttributesFrom: menuBarMenu].
        popup popUpAt: aPoint in: self]!
   
menu
        "Private - Answer the menu for the pane."
		"@11.05.94 ch: giving the menu in the menu variable causes problems with 
		popups, so always get a new menu." 
		"@27.04.94 ch: bug fix: changed owner, prevent 
		multiple #getMenu raises" 

    (owner isNil or: [(self handlesEvent: #getMenu) not]) ifTrue: [^nil].
    self event: #getMenu.
	(menu notNil and: [menu owner isNil]) ifTrue: [
		"Transcript cr; nextPutAll: 'Warning, no owner in for menu ', menu title."
		menu owner: self owner].
	^menu

	"The next lines causes irratic behaviour if the
	application sets another owner than itsself.
	It will break no code in the system, as all Classes 
	set the owner in the #getMenu event. Unfortunately
	this line sets the owner back."
    "menu isNil ifTrue: [^nil].
    menu owner: owner.
    ^menu"!
 
popupMenu
		"Private - Answer the popup Menu for the pane."
		"@25.06.94 ch: fix: don't change the menu variable" 
	| aMenu |
    popup notNil ifTrue: [^popup].
    self event: #getPopupMenu.
    popup isNil ifTrue: [
		aMenu := menu.
		popup := self menu.
		menu := aMenu].
	^popup!
   
zoom
		"Expand the pane to take up the entire area
          of its main window, or back to normal if it is
         already zoomed."
		"@18.06.94 ch: comment out all the hideWindow/showWindow. 
		-> Performance improvement." 
	| rect pw |
    pw := self parent.
    pw isFrameWindow ifTrue: [ pw := pw parent ].
    rect := ( pw rectangle ).
    pw zoomed: pw zoomed not.
    self zoomed: self zoomed not.
    pw zoomed not
        ifTrue: [ "unzoom"
            "pw hideWindow."
            pw resize: rect.
            pw children do: [:c | 
                c == self ifFalse: [ c showWindow ]].
            "pw showWindow"]
        ifFalse: [ "zoom"
            rectangle origin: ( 0@0 ) extent: ( rect extent max: 0@0 ).
            "pw hideWindow."
            self resizeWindow;
                initGraphicsTool;
                setFocus.
            pw children do: [:c | 
                c == self ifFalse: [ c hideWindow ]].
            "pw showWindow" ].! !



!SubPane class methods ! !



!ControlPane methods !
 
removeStyle: styleInteger
		"Private - Turn off the style instance variable bits which 
        are on in styleInteger."
		"@09.09.94 ch: bug fix: if executed before defaultStyle, defaultStyle were 
		lost" 
	style isNil ifTrue: [style := self defaultStyle].
	^style := style bitAnd: (styleInteger bitXor: 16rFFFFFFFF).! !



!ControlPane class methods ! !



!StaticPane methods !
 
update
		"Refresh the receiver from the owner and display it." 
		"@17.06.94 ch: Creation"
    self event: #getContents.! !



!StaticPane class methods ! !



!StaticGraphic methods !
 
setHandle
        "Private - Set the icon or bitmap handle for the static control."
		"@16.12.93 ch: bug fix: the 'self resize:' statements causes wrong 
		positioning" 
        " Assumes 'handle = NullHandle' is false and value is either
          an icon or bitmap handle." 
    value notNil
    ifTrue: 
        [ PMWindowLibrary sendMsg: ( self handle )
            msg: SmSethandle mp1: value handle asParameter mp2: 0.
"		self invalidateRect: self rectangle. "
		
		"This MUST NOT be done. It causes a wrong position of the graphic."
        "self resize: self rectangle."		     	" force redraw..."
        ]! !



!StaticGraphic class methods ! !



!TextEdit methods !
  
update
		"Refresh the text from the
         owner and display it."
		"@22.06.94 ch: bug fix: selStart, selEnd must be set before #getContents to 
		allow the setting of a selection from the #getContents method" 
	selStart := 0.
    selEnd := 0.
    self event: #getContents.
    handle = NullHandle ifFalse: [ self setPMSelection ]! !



!TextEdit class methods ! !



!TextPane methods !
   
findReplace
        "Private - User selected the Find/Replace menu item."
		"@1.7.94 ch: bug fix: don't rely on the name '~Edit'"
    | dialog s aMenu |
    s := self selectedItem.
    s notNil ifTrue: [s := s asMixedString].
    (s includes: Lf)
        ifTrue: [s := SearchString := ''].
    (s isNil or: [s isEmpty]) ifTrue: [s := SearchString].
    dialog := FindReplaceDialog new open: s replace: NewString forward: Forward
        caseSensitive: CaseSensitive.
    dialog command isNil ifTrue: [^self].
    PriorCommand := dialog command.
	menu isNil
		ifTrue: [aMenu := (self mainWindow menuTitled: '~Edit')]
		ifFalse: [aMenu := menu].
    (PriorCommand == #searchOld or: [PriorCommand == #searchBackOld]) 
		ifTrue: [aMenu changeItem: #again label: 'Find A~gain	Ctrl+G']
        ifFalse: [aMenu changeItem: #again label: 'Replace A~gain	Ctrl+G'].
    SearchString := dialog toFind.
    SearchString notNil
        ifTrue: [SearchString := SearchString asMixedString].
    NewString := dialog replaceWith.
    NewString notNil
        ifTrue: [NewString := NewString asMixedString].
    CaseSensitive := dialog caseSensitive.
    Forward := dialog forward.
    ^self perform: PriorCommand!

popupMenu
        "Private - Answer the popup Menu for the receiver."
		"@30.05.94 : bug fix: crash if no 'File' menu" 
    | m aMenu |
    m := super popupMenu.
    m isNil ifTrue: [m := Menu new
        appendItem: '~Copy' selector: #copySelection;
        appendItem: 'Cu~t' selector: #cutSelection ;
        appendItem: '~Paste' selector: #pasteSelection ;
        appendSeparator ;
        appendItem: '~Do It' selector: #doIt  ;
        appendItem: '~Show It' selector: #printIt  ;
        appendSeparator ;
        appendItem: '~Save' selector: #accept ;
        appendItem: 'A~gain' selector: #again ;
        appendSubMenu: (self class editMenu allOwners: self) ;
        appendSubMenu: (self class smalltalkMenu allOwners: self) ;
        owner: self;
        title: '~TextPanePopup'].
    m getIndex: #accept ifAbsent: [^m]. "Check to be sure the item is there."
	(aMenu := self mainWindow menuTitled: '~File') isNil ifFalse: [
	    m copyItemAttributes: #accept from: aMenu].
    ^m!
   
toggleWrap
		"Private - Toggle the word-wrap mode."
		"@24.06.94 ch: fix: try to be invariant of edit menu name" 
	| editMenu |
	(editMenu := menu) isNil ifTrue: [
    	editMenu := self mainWindow menuTitled: 'Edit'].
    wrap
        ifTrue: [ 
            editMenu notNil ifTrue: [editMenu uncheckItem: #toggleWrap].
            self disableWordWrap]
        ifFalse: [
            editMenu notNil ifTrue: [editMenu checkItem: #toggleWrap].
            self enableWordWrap]! !



!TextPane class methods ! !
"Finalization code"
    !

 
Transcript cr; nextPutAll: 'Bug Fixes 2.0 installed.'!
