// FILE: CHAINSAW.HPP
// MODULE: ALL
// PROGRAM: CHAINSAW

// Public Domain, 5/24/93, Ted Davis

#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <dos.h>
#include <errno.h>
#include <fcntl.h>
#include <fstream.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <string.h>
#include <sys\stat.h>

#define VersionNumber " 5.3  "

#define PassWord "password"
// Note that the above password is case sensitive; use lower case; do not
// use the quote marks.
#define DefaultSwitchString "/BGNPRsw"

#define ANY_FILE FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC | FA_ARCH
#define make_writable chmod(FileOrDirName, S_IWRITE)
#define NoPrint 0
#define STDERR 1
#define STDOUT 2
#define KeyOffset 2139
#define password_len 16
#define switches_len 32
#define PwordOffset -48
#define ID_Offset -64
#define Marker_len 16
#define MarkerText "CHAINSAWTedDavis"

#define no 0
#define yes 1

extern int cbreak;
extern int DirList;
extern int ErrorLevel;
extern int FileList;
extern int IsRoot;
extern int KillBaseFilesOK;
extern int NetworkDriveOK;
extern int PasswordCheck;
extern int PrintEnable;
extern int ProtectedOK;
extern int RemoveStartDir;
extern int RootOK;
extern int SummaryFlag;

extern char Bad_DriveOrDir[];
extern char Bad_NewPassword[];
extern char Bad_Password[];
extern char Barf_Message[];
extern char Copyright_Message[];
extern char DummyMessage[];
extern char GoodNewPasswordMsg[];
extern char Help_Message[];
extern char InitialDirectory[];
extern char Memory_Error[];
extern char NewSwitchesMessage[];
extern char NullMessage[];
extern char OldSwitchesMessage[];
extern char Root_NotAllowed[];
extern char Wrong_Version[];


typedef struct
{
	int		Type;
    char	*Message;
}Message_;

extern Message_	BadDriveOrDir;
extern Message_	BadNewPassword;
extern Message_	BadNewSwitches;
extern Message_	BadPassword;
extern Message_	BarfMessage;
extern Message_	CopyrightMessage;
extern Message_	DirFailed;
extern Message_	DirOK;
extern Message_	FileFailed;
extern Message_	FileOK;
extern Message_ GoodNewPassword;
extern Message_	HelpMessage;
extern Message_	MemoryError;
extern Message_ NewSwitches;
extern Message_ OldSwitches;
extern Message_	RootNotAllowed;
extern Message_	Summary;
extern Message_	WrongVersion;

struct SumData
{
	int 	Files;
	int		Dirs;
};

extern SumData SummaryData;


class dirkiller
{
	private:
		int 		attributes;
		int 		TargetDrive;
		char 		CurrentDir[80];
		char 		FileOrDirName[80];
		char 		WorkingPath[80];
		ffblk 		DataBlock;
		dirkiller 	*NextLevel;

	public:
		dirkiller(char StartingPath[], int KillFilesFlag, int KillDirFlag);

};

extern void Output(Message_ M);
extern void Barf(void);
extern int ChangePassword(char * new_password, char *argv0, char * Switches);
extern int  CtrlBreakRoutine(void);
extern char *Emessage(void);
extern void Encrypt(char *key, char *string, int length);
extern void InsertVersion(char *Vlocation);
extern int  NetworkDriveQuery(int DriveLetter);
extern void PrintFileOkMessage(char *FileName);
extern void PrintFileFailedMessage(char *FileName);
extern void PrintFileProtected(char *Fileame);
extern void PrintDirOkMessage(char *DirName);
extern void PrintDirFailedMessage(char *DirName);
extern void PrintSummary(SumData SummaryData);
extern int UserPassword(char * password, char * argv0, char * Switches,\
 char * Pword);
