
// FILE: CHAIN4.CPP
// MODULE: OUTPUT
// PROGRAM: CHAINSAW 

// Public Domain, 5/24/93, Ted Davis

#include "chainsaw.hpp"


// The next six functions construct message strings and call Output to
// print them.
void PrintDirFailedMessage(char *DirName)
{
	strcpy(DummyMessage, "*** Removal of directory: ");
	strcat(DummyMessage, DirName);
	strcat(DummyMessage, " FAILED.\n");
	strcat(DummyMessage, Emessage());
	DirFailed.Message = DummyMessage;
	Output(DirFailed);
}

void PrintDirOkMessage(char *DirName)
{
	strcpy(DummyMessage, "... Removed directory: ");
	strcat(DummyMessage, DirName);
	strcat(DummyMessage, ".\n");
	DirOK.Message = DummyMessage;
	Output(DirOK);
	SummaryData.Dirs++;
}

void PrintFileFailedMessage(char *FileName)
{
	strcpy(DummyMessage, "*** Deletion of file: ");
	strcat(DummyMessage, FileName);
	strcat(DummyMessage, " FAILED.\n");
	strcat(DummyMessage, Emessage());
	FileFailed.Message = DummyMessage;
	Output(FileFailed);
}

void PrintFileOkMessage(char *FileName)
{
	strcpy(DummyMessage, "... Deleted file: ");
	strcat(DummyMessage, FileName);
	strcat(DummyMessage, ".\n");
	FileOK.Message = DummyMessage;
	Output(FileOK);
    SummaryData.Files++;
}
void PrintSummary(SumData SummaryData)
{
char Tstr[8];
	strcpy(DummyMessage, "CHAINSAW deleted ");
	if(SummaryData.Files)
	{
		sprintf(Tstr, "%i",SummaryData.Files);
		strcat(DummyMessage, Tstr);
	}
	else
	{
		strcat(DummyMessage, "no");
	}
	strcat(DummyMessage, " file");
	if(SummaryData.Files != 1)
	{
		strcat(DummyMessage, "s");
	}
	strcat(DummyMessage, " and removed ");
	if(SummaryData.Dirs)
	{
		sprintf(Tstr, "%i",SummaryData.Dirs);
		strcat(DummyMessage, Tstr);
	}
	else
	{
		strcat(DummyMessage, "no");
	}
	if(SummaryData.Dirs != 1)
	{
		strcat(DummyMessage, " directories.\n");
	}
	else
	{
		strcat(DummyMessage, " directory.\n");
	}
	Summary.Message = DummyMessage;
	Output(Summary);
}

void PrintFileProtected(char *FileName)
// Note that this uses the same message structure as the other file failed
// message;  only one of them can run per pass and this simply adds the
// explanation that would otherwise come from _strerror().
{
	strcpy(DummyMessage, "*** Deletion of file: ");
	strcat(DummyMessage, FileName);
	strcat(DummyMessage, " FAILED.\n");
	strcat(DummyMessage, "*** Error: read-only, hidden or system.\n");
	FileFailed.Message = DummyMessage;
	Output(FileFailed);
}

void Output(Message_ M)
// Selects the destination (STDERR or STDOUT) based on the message type which
// is 0 (no display), 1 (STDERR), or 2 (STDOUT).
{
	switch(M.Type)
	{
		case 0:
			break;
		case 1:
			cerr << M.Message;
			break;
		case 2:
			cout << M.Message;
			break;
		default:
			break;
	}
}
