// FILE: CHAIN3.CPP
// MODULE: FUNCTIONS
// PROGRAM: CHAINSAW 

// Public Domain, 5/24/93, Ted Davis

#include "chainsaw.hpp"


void Barf(void)
// The abort function.
{
	Output(BarfMessage);

	setcbrk(cbreak); exit(1);
}

int CtrlBreakRoutine(void)
// This is the code that runs when Ctrl + Break or Ctrl + C is pressed.
{
	// This message is not suppressable by command tail switches.
	cerr << "\n\n CHAINSAW ABORTED by user!\n";
	cerr << "Directory " << InitialDirectory;
	cerr << "\nand its subdirectories are probably damaged.\n\n";
	setcbrk(cbreak);	// Restores break setting to the original value.
	exit(3);
    return(0);
}

char *Emessage(void)
// Returns a pointer to an error message string built from the immediate
// text and the message string supplied by _strerror(), which explains the
// last error that set errno.  Originally it was longer than this.
{
	return(_strerror("*** Error"));
}

void Encrypt(char *key, char *string, int length)
// This is intentionally uncommented.
{
int i;
	for(i = 0; i < length; i++)
	{
    	string[i] = string[i] ^ key[i];
	}
}

void InsertVersion(char * Vlocation)
// Inserts the version number into a string at the given location.
{
	strncpy(Vlocation, VersionNumber, 5);
	// VersionNumber is 6 characters long, so copying 5 characters does not
    // terminate the string in work, but merely inserts the version number.
}

#define CarryFlagBit 0x0001
#define NetDriveBit 0x1000
int NetworkDriveQuery(int DriveLetter)
// Determines if the target drive is valid and local (returns 0), valid and
// remote (1), no network installed or invalid drive (-1).
// This function uses DOS interrupt 0x21, function 0x4409  Since the
// compiler has a tendency to trash flags on return from an interrupt, this
// is largely in assembly language.
{
	// Save the registers to be used (and flags).
	asm{
		push	bx
		push	cx
		push	dx
		push	bp
		pushf
	}
	// Set up the drive number in BX.
	_BX = DriveLetter - 'A' + 1;
	// Drive 0 is the default, 1 is A, etc.

	// Note: jc comes out jb in the compiled code - therefore the somewhat
	// unusual way of testing the carry flag.
	asm{
    	mov		ax,4409h
		int 	21h
		pushf
		pop		ax
		and		ax,CarryFlagBit
		cmp		ax,CarryFlagBit
		je		err
		and		dx,NetDriveBit
		cmp		dx,NetDriveBit
		jne		ok
		mov 	ax,1
		jmp 	done
	}
	// Return 0 if valid and local.
	ok:
	asm{
		xor		ax,ax
		jmp		done
	}
	// Return -1 if invalid drive.
	err:
	asm	mov		ax,-1
	done:
	// Restore the registers used, except AX, which is the return value.
	asm{
    	popf
		pop		bp
		pop		dx
		pop		cx
		pop		bx
    }
	return(_AX); // +1, 0, or -1 only.
}
#undef CarryFlagBit
#undef NetDriveBit
