
// FILE: CHAIN2.CPP
// MODULE: OBJECT
// PROGRAM: CHAINSAW 

// Public Domain, 5/24/93, Ted Davis


#include "chainsaw.hpp"


dirkiller::dirkiller(char StartingPath[], int KillFilesFlag, int KillDirFlag)
// The constructor for dirkiller.  It is also the method of the object.
// It searches the given directory for files, which it deletes, and for 
// directories, which it recurses by creating and destroying a new instance
// of itself which is passed the full path of the subdirectory.  It starts 
// at the top of the given directory and cleans out the first item before 
// repeating for the new first item.
{
int PassCount = 0;
int flag = no;
char * strptr;
char TempString[80];
	strcpy(WorkingPath, StartingPath);    
	strcat(WorkingPath, "*.*");
	while(!flag)
	{
		// If this is the first pass it is necessary to use findfirst(), 
		// otherwise findnext().
		if(PassCount++)
		{
			flag = findnext(&DataBlock);

			// If the directory is empty and the flags say remove it (which
			// occurs only in the first instance of the object, the others 
			// are removed by their parent object), set "flag" so that the
			// following code will treat it as a special case.
			if((flag == -1) && ((errno == EMFILE) || (errno == ENOFILE))\
			 && KillDirFlag && !IsRoot)
			{flag = yes;}
		}
		else
		{
			flag = findfirst(WorkingPath, &DataBlock, ANY_FILE);

			// See comment for the identical line above.
			if((flag == -1) && ((errno == EMFILE) || (errno == ENOFILE))\
			 && KillDirFlag && !IsRoot)
			{flag = yes;}
		}
		// The return (flag) is 0 for success or +1 for
		// remove this dir, or -1 for failure.

		if(flag > -1)	// If something was found in the directory (or forced).
		{
			strcpy(FileOrDirName, StartingPath);
			// The following !flag's enable code for other than remove the
			// given directory by testing for 0 (flag > -1 tested for 0 or +1).
			if(!flag) {strcat(FileOrDirName, DataBlock.ff_name);}

			// Is it a directory, other than "." or ".." (which MUST not 
			// be processed)?
			if(((DataBlock.ff_attrib & FA_DIREC) && \
			(DataBlock.ff_name[0] != '.') && \
			(strncmp(DataBlock.ff_name, "..", 2))) || (flag == yes))
			{
				// Add a trailing backslash.
				if(!flag) {strcat(FileOrDirName, "\\");}

				// If it is a valid directory, spawn a new instance of
				// the dirkiller object to process it.
				if((NextLevel = new dirkiller(FileOrDirName, yes, no)) == no)
				{
					// This code executes if the next instance of dirkiller
					// cannot be created for any reason.
					Output(MemoryError);
					setcbrk(cbreak); exit(1);
				}
				else
				{
					// This frees the memory allocated by the "new" in the 
					// "if" condition.  Creation of the object causes the
					// constructor to execute, which does everything the
					// object can do; no special call is required.
					delete NextLevel;

					// Remove the now empty subdirectory.
					// If the default directory is the one to be deleted, it is
					// necessary to change away from it.

					// Make a pointer to the directory part of the string.
					strptr = FileOrDirName + 3;

					// Save the default directory on the target drive.
					TargetDrive = StartingPath[0] - 'A' + 1;
					getcurdir(TargetDrive, CurrentDir);

					// add a trailing '\' to match FileOrDirName.
					strcat(CurrentDir, "\\");

					// Compare the default directory on the target drive with
					// the one in work.  If they are the same, move toward 
					// the root.
					if(!strcmp(strptr, CurrentDir))
					{
						strncpy(TempString, StartingPath, 2);
						TempString[2] = '\0';
						strcat(TempString, "..");
						// That makes a string of the form "C:.." which
						// lets chdir() back out by one level.
						chdir(TempString);
					}

					// Now it is ok to attempt to remove the directory
					// in work.
					// rmdir() requires the absense of a trailing "\".
					FileOrDirName[(strlen(FileOrDirName) - 1)] = '\0';					
					if(!rmdir(FileOrDirName))
					{
						// If the removal succeeded.
						PrintDirOkMessage(FileOrDirName);
					}
					else
					{
						// If it failed.
						PrintDirFailedMessage(FileOrDirName);
						ErrorLevel = 2;
					}
				}
			}
			else
			{
				// Delete the files, one per pass of the "while" loop.
				if(KillFilesFlag && (!(DataBlock.ff_attrib & FA_DIREC)))
				{
					if(DataBlock.ff_attrib & FA_RDONLY) 
					{
						if(ProtectedOK) {make_writable;}
					}
					if((DataBlock.ff_attrib & FA_HIDDEN) || \
					(DataBlock.ff_attrib & FA_SYSTEM) || \
					(DataBlock.ff_attrib & FA_RDONLY))
					{
						if(!ProtectedOK) 
						{
							// Do not erase read-only, system, or hidden
							// files without special permission.  Instead,
							// display an explanatory error message.
							PrintFileProtected(FileOrDirName);
						}
						else
						{
							// Make file writable so it can be erased.
							make_writable;
							// If permitted, try to delete the protected file.
							if(!unlink(FileOrDirName))	
							{
								PrintFileOkMessage(FileOrDirName);
							}
							else
							{
								PrintFileFailedMessage(FileOrDirName);
								ErrorLevel = 2;
							}
						}
					}
					else
					{
						if(!unlink(FileOrDirName))	
						{
							PrintFileOkMessage(FileOrDirName);
						}
						else
						{
							PrintFileFailedMessage(FileOrDirName);
							ErrorLevel = 2;
						}
					}
				}
			}
		}
	}
}

