/*
 * This part was hacked by Harald Kipp.
 *
 * Parts are
 *
 *       Copyright (c) 1989-1994 by Kendra Electronic Wonderworks.
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * You may freely copy or redistribute this software. However,
 * this may not apply to any part of it, if otherwise noted.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <arbmath.h>
#include <chanlib.h>

#define MAX_HOSTNAME  8
#define MAX_DIGITS    20

/************************************************************************/
/* uupc_path                                                            */
/*                                                                      */
/* Converts a name of a work, data or execution file from standard      */
/* convention to a UUPC compatible pathname.                            */
/*                                                                      */
/* Parameter    Description                                             */
/* ------------ ------------------------------------------------------- */
/* lhost        Points to a string that specifies the local host name.  */
/*                                                                      */
/* localpath    Points to the buffer that receives the converted path-  */
/*              name.                                                   */
/*                                                                      */
/* canon        Points to a string that specifies canonical name to be  */
/*              converted.                                              */
/*                                                                      */
/* lhost        Points to a string that specifies the remote host name. */
/* ------------ ------------------------------------------------------- */
/* Return value Character pointer to the converted pathname (localpath) */
/*                                                                      */
/************************************************************************/
char *uupc_path(char *lhost, char *localpath, char *canon, char *rhost)
{
    static char set[] = "!#$%&'()-0123456789@^_`abcdefghijklmnopqrstuvwxyz{}~";
    size_t rhost_len = min(MAX_HOSTNAME, strlen(rhost));
    size_t lhost_len = min(MAX_HOSTNAME, strlen(lhost));
    char tempname[13];
    unsigned char arbnum[MAX_DIGITS];
    unsigned remain;
    char *cp = canon;
    char *cp1 = localpath + rhost_len;

    /*
     * Use first 8 characters of remote host as a subdirectory name
     */
    strncpy(localpath, rhost, rhost_len);
    *cp1++ = '/';

    /*
     * If name starts with any uppercase character followed by
     * a dot then use that character as a second level subdirectory.
     */
    if((*cp >= 'A') && (*cp <= 'Z') && (*(cp + 1) == '.')) {
        *cp1++ = *cp;
        *cp1++ = '/';
        cp += 2;
    }

    while(rhost_len > 0) {
        if (strncmp(rhost, cp, rhost_len) == 0)
            break;
        rhost_len--;
    }
    while(lhost_len > 0) {
        if(strncmp(lhost, cp, lhost_len) == 0)
            break;
        lhost_len--;
    }
    if(lhost_len > rhost_len) {
        rhost_len = 0;
        cp += lhost_len;
    }
    else {
        lhost_len = 0;
        cp += rhost_len;
    }

    memset(arbnum, 0, MAX_DIGITS);
    add(arbnum, lhost_len + rhost_len * MAX_HOSTNAME, MAX_DIGITS);

    while((*cp != '\0') && (*arbnum == '\0')) {
        mult(arbnum, 'z' - '#' + 1, MAX_DIGITS);
        add(arbnum, *cp++  - '#', MAX_DIGITS);
    }

    cp = &tempname[sizeof(tempname)];
    *--cp = '\0';
    while(adiv(arbnum, sizeof(set) - 1, &remain, MAX_DIGITS))
        *--cp = set[remain];

    strcpy(cp1, cp);

    return(localpath);
}
