/*
 * This part was hacked by Harald Kipp
 *
 * Bug reports should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * This module contains the tcp socket interface.
 *
 */

#define OS2
#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netdb.h>

#undef min
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#include <lprintf.h>
#include <tcpconn.h>

static int flog = 0;

/************************************************************************/
/*                                                                      */
/************************************************************************/
void so_setlog(int f)
{
    flog = f;
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
static char *errmsg(int code)
{
    static char ebuf[6 + 5 + 1];

    if (code > sys_nerr || code < 0) {
	sprintf(ebuf, "Error %d", code);
	return ebuf;
    }
    else
	return sys_errlist[code];
}

/************************************************************************/
/* given a host name (either name or internet address) and service name */
/* (or port number) (both in ASCII), give us a TCP connection to the    */
/* requested service at the requested host (or give us FAIL).           */
/************************************************************************/
int get_tcp_conn(char *host, char *serv)
{
    int sock;
    struct sockaddr_in sadr;
    struct hostent *hostnm;

    if ((hostnm = gethostbyname(host)) == NULL)
	return (-1);

    sadr.sin_family = AF_INET;
    sadr.sin_port = htons(119);
    sadr.sin_addr.s_addr = *((unsigned long *)(hostnm -> h_addr));

    if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
	return (-1);

    if (connect(sock, (struct sockaddr *) & sadr, sizeof(sadr)) < 0) {
	int e_save = errno;

	fprintf(stderr, "%s [%s]: %s\n", host,
		inet_ntoa(sadr.sin_addr), errmsg(errno));
	soclose(sock);			/* dump descriptor */
	errno = e_save;
	return (-1);
    }
    if(serv);
    return (sock);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
int so_puts(int s, char *line)
{
    int rc;

    rc = send(s, line, strlen(line), 0);
    if(rc == -1)
        lprintf("send(): Error %d", errno);
    else if(flog) {
        char *cp = strchr(line, '\r');
        if(cp)
            *cp = '\0';
        if(*line)
            lprintf("<'%s'", line);
        if(cp)
            *cp = '\r';
    }


    return (rc);
}


/************************************************************************/
/*                                                                      */
/************************************************************************/
int _cdecl so_printf(int s, char *format,...)
{
    int rc;
    char achBuf[BUFSIZ];
    va_list marker;

    va_start(marker, format);
    vsprintf(achBuf, format, marker);
    rc = so_puts(s, achBuf);
    va_end(marker);

    return (rc);
}


/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
int recv_line(int s, char *pline)
{
    register int rc;
    register char *cp = pline;
    char cl = '\0';
    int cc = 0;

    while ((rc = recv(s, cp, 1, 0)) > 0) {
        if (*cp == '\n') {
            if(cl == '\r')
                cp--;
            else
                cc++;
            *cp = '\0';
            break;
        }
        cl = *cp++;
        if(++cc >= BUFSIZ) {
            *cp = '\0';
            break;
        }
    }
    if(rc < 0) {
        if(errno != 54)
            lprintf("recv(): Error %d", errno);
        else if(flog)
            lprintf("connection lost");
    }
    else if(rc && flog)
        lprintf(">'%s'", pline);
    else if(!rc)
        lprintf("connection lost");

    return((rc > 0) ? cc : rc);
}
