/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define INCL_DOSPROCESS
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <tcpconn.h>

#include "globals.h"
#include "nntp.h"
#include "changi.h"

/*
 * spawn -- create a child process with the input from the client
 * as stdin.
 *
 *	Parameters:	"path" is the path of the program to invoke.
 *			"name" is the name to call the program.
 *			"flag" is a single flag to be passed to the program.
 *			"cont_code" is the response code to transmit
 *			on successful startup.
 *			"err_code" is the response code to transmit when
 *			something goes wrong.
 *
 *	Returns:	-1 on non-zero return from child,
 *			0 on error before fork/exec,
 *			1 otherwise.
 *
 *	Side effects:	Creates and removes temporary file;
 *			accepts input from client; forks and execs.
 *			Can time out if XFER_TIMEOUT is defined.
 */

int spawn(int s, char *cmnd, int cont_code, int err_code)
{
    char line[BUFSIZ];
    char *cp;
    int exit_status = 1;
    FILE *fp;

    if ((fp = _popen(cmnd, "wb")) == NULL) {
	so_printf(s, "%d Cannot execute %s.\r\n", err_code, cmnd);
	return (0);
    }
    so_printf(s, "%d Ok\r\n", cont_code);

    for (;;) {
        if (recv_line(s, line) <= 0)
	    break;
	if ((cp = strchr(line, '\r')) != NULL)
	    *cp = '\0';
	else if ((cp = strchr(line, '\n')) != NULL)
	    *cp = '\0';

	if (line[0] == '.' && line[1] == '\0')
	    break;

	if (line[0] == '.') {
	    fprintf(fp, "%s\n", line + 1);
	    fflush(fp);
	}
	else {
	    fprintf(fp, "%s\n", line);
	    fflush(fp);
	}
    }
    DosSleep(5000L);
    exit_status = _pclose(fp);

    return (exit_status ? -1 : 1);
}
