/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define OS2
#include <os2.h>

#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netlib.h>

#undef min
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <process.h>

#include <lprintf.h>
#include <tcpconn.h>


#include "config.h"
#include "globals.h"
#include "nntp.h"
#include "changi.h"

static struct cmdent {
    char *cmd_name;
    int authreq;			/* 0=none,1=userpass */
    void (*cmd_fctn) (PNEWSCLIENT, int, char **);
} cmdtbl[]= {

#ifdef AUTH
    "authcap", 0, doauth,
    "authinfo", 0, doauth,
    "authsys", 0, doauth,
#endif

    "article", 0, ahbs,
    "body", 0, ahbs,
    "date", 0, dodate,
    "group", 0, group,
    "head", 0, ahbs,
    "help", 0, help,
    "ihave", 1, ihave,
    "last", 0, nextlast,
    "list", 0, list,
    "listgroup", 0, listgroup,
    "mode", 0, ignore,
    "newgroups", 0, newgroups,
    "newnews", 0, newnews,
    "next", 0, nextlast,
    "post", 1, post,
    "slave", 0, slave,
    "stat", 0, ahbs,
    "xhdr", 0, xhdr,
#if 0
    "xover", 0, doxover,    /*  moved in and removed again (harald) */
#endif
#ifdef XINDEX
    "xindex", 0, xindex,
#endif

#ifdef XTHREAD
    "xthread", 0, xthread,
#endif
};

#define NUMCMDS (sizeof(cmdtbl) / sizeof(struct cmdent))
#if 0
/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
int recv_line(int s, char *pline)
{
    register int rc;
    register char *cp = pline;

    while ((rc = recv(s, cp, 1, 0)) > 0) {
        if (*cp == '\r') {
            cp++;
            if ((rc = recv(s, cp, 1, 0)) <= 0)
		break;
            if (*cp == '\n') {
                *(cp - 1) = '\0';
		break;
	    }
	}
        cp++;
    }
    if(rc < 0) {
        if(errno != 54)
            lprintf("recv(): Error %d", errno);
        else if(dolog(LOG_RECV))
            lprintf("connection lost");
    }
    else if(rc && dolog(LOG_RECV))
        lprintf(">'%s'", pline);

    return (rc);
}
#endif

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
VOID _cdecl ClientThread(int *ps)
{
    PNEWSCLIENT pnc;
    char buf[BUFSIZ];                   /* buffer for sending and receiving
					 * data */
    struct sockaddr_in client;		/* client address information            */
    int ns;				/* socket connected to client            */
    int namelen;			/* length of client name                 */
    char **argp = NULL;
    int argnum, i;

    namelen = sizeof(client);
    if ((ns = accept(*ps, (struct sockaddr *) & client, &namelen)) == -1) {
        lprintf("accept(): Error %d", errno);
	return;
    }
    lprintf("Client at %s connected", inet_ntoa(client.sin_addr));

    _beginthread(ClientThread, NULL, 8192, ps);

    pnc = memset(malloc(sizeof(NEWSCLIENT)), 0, sizeof(NEWSCLIENT));
    pnc -> s = ns;
    pnc -> canpost = 1;
    pnc -> canread = 1;
    pnc -> canxfer = 1;
    if (so_printf(ns, "%d Changi OS/2 NNTP server ready(%s).\r\n",
		  pnc -> canpost ? OK_CANPOST : OK_NOPOST,
                  pnc -> canpost ? "posting ok" : "no posting") != -1) {
	for (;;) {
            if (recv_line(ns, buf) <= 0)
		break;

	    if ((argnum = parsit(buf, &argp)) == 0)
		continue;

	    if (!stricmp(argp[0], "quit"))
		break;

	    for (i = 0; i < NUMCMDS; ++i)
		if (!stricmp(cmdtbl[i].cmd_name, argp[0]))
		    break;

	    if (i < NUMCMDS)
		(*cmdtbl[i].cmd_fctn) (pnc, argnum, argp);
            else if (so_printf(ns, "%d Command unrecognized.\r\n", ERR_COMMAND) == -1)
		break;
	}
    }
    lprintf("Client at %s disconnected", inet_ntoa(client.sin_addr));
    soclose(ns);
    free(pnc);
}


void ignore(PNEWSCLIENT pnc, int argc, char *argv[])
{
    so_puts(pnc -> s, "500 command recognized by not applicable.\r\n");
    if (argc && argv) ;
}
