PROJ = rnews
PROJFILE = rnews.mak
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
CC  = cl
CFLAGS_G  = /AC /W4 /G2 /Zp /BATCH /B2 C2L
CFLAGS_D  = /qc /Gi$(PROJ).mdt /Zr /Zi /Od
CFLAGS_R  = /Ot /Ol /Og /Oe /Oi /Gs
MAPFILE_D  = NUL
MAPFILE_R  = $(PROJ).map
LFLAGS_G  =  /NOI /STACK:24576  /BATCH
LFLAGS_D  = /CO /INC /FAR /PACKC /PACKD /PMTYPE:VIO
LFLAGS_R  =  /M /EXE /FAR /PACKC /PACKD  /PMTYPE:VIO
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
LLIBS_R  =  /NOD:CLIBCE CLIBCEP
LLIBS_D  =  /NOD:CLIBCE CLIBCEP

DEF_FILE  = rnews.def
OBJS  = rnews.obj ..\lib\body.obj ..\lib\jobid.obj ..\lib\header.obj\
        ..\lib\history.obj ..\lib\dbm.obj ..\lib\idx.obj ..\lib\lprintf.obj\
        rheader.obj config.obj ..\lib\getopt.obj ..\lib\groups.obj\
        ..\lib\active.obj ..\lib\mkpath.obj ..\lib\xopen.obj article.obj\
        ..\lib\radixpck.obj ..\lib\finedir.obj ..\lib\readcfg.obj exit.obj
SBRS  = rnews.sbr ..\lib\body.sbr ..\lib\jobid.sbr ..\lib\header.sbr\
        ..\lib\history.sbr ..\lib\dbm.sbr ..\lib\idx.sbr ..\lib\lprintf.sbr\
        rheader.sbr config.sbr ..\lib\getopt.sbr ..\lib\groups.sbr\
        ..\lib\active.sbr ..\lib\mkpath.sbr ..\lib\xopen.sbr article.sbr\
        ..\lib\radixpck.sbr ..\lib\finedir.sbr ..\lib\readcfg.sbr exit.sbr

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .obj .sbr .c

rnews.obj : rnews.c config.h rnews.h

rnews.sbr : rnews.c config.h rnews.h

..\lib\body.obj : ..\lib\body.c

..\lib\body.sbr : ..\lib\body.c

..\lib\jobid.obj : ..\lib\jobid.c

..\lib\jobid.sbr : ..\lib\jobid.c

..\lib\header.obj : ..\lib\header.c

..\lib\header.sbr : ..\lib\header.c

..\lib\history.obj : ..\lib\history.c

..\lib\history.sbr : ..\lib\history.c

..\lib\dbm.obj : ..\lib\dbm.c

..\lib\dbm.sbr : ..\lib\dbm.c

..\lib\idx.obj : ..\lib\idx.c

..\lib\idx.sbr : ..\lib\idx.c

..\lib\lprintf.obj : ..\lib\lprintf.c

..\lib\lprintf.sbr : ..\lib\lprintf.c

rheader.obj : rheader.c config.h rnews.h

rheader.sbr : rheader.c config.h rnews.h

config.obj : config.c config.h

config.sbr : config.c config.h

..\lib\getopt.obj : ..\lib\getopt.c

..\lib\getopt.sbr : ..\lib\getopt.c

..\lib\groups.obj : ..\lib\groups.c

..\lib\groups.sbr : ..\lib\groups.c

..\lib\active.obj : ..\lib\active.c

..\lib\active.sbr : ..\lib\active.c

..\lib\mkpath.obj : ..\lib\mkpath.c

..\lib\mkpath.sbr : ..\lib\mkpath.c

..\lib\xopen.obj : ..\lib\xopen.c

..\lib\xopen.sbr : ..\lib\xopen.c

article.obj : article.c config.h rnews.h

article.sbr : article.c config.h rnews.h

..\lib\radixpck.obj : ..\lib\radixpck.c

..\lib\radixpck.sbr : ..\lib\radixpck.c

..\lib\finedir.obj : ..\lib\finedir.c

..\lib\finedir.sbr : ..\lib\finedir.c

..\lib\readcfg.obj : ..\lib\readcfg.c

..\lib\readcfg.sbr : ..\lib\readcfg.c

exit.obj : exit.c config.h

exit.sbr : exit.c config.h


$(PROJ).bsc : $(SBRS)
        $(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(DEF_FILE) $(OBJS)
!IF $(DEBUG)
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
        $(ILINK) -a -e "$(LINKER) @$(PROJ).lrf" $@
!ELSE
        $(LINKER) @$(PROJ).lrf
!ENDIF


.c.obj :
!IF $(DEBUG)
        $(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
        $(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.c.sbr :
!IF $(DEBUG)
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF


run: $(PROJ).exe
        $(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
        CVP $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
