#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <lprintf.h>
#include <header.h>
#include <jobid.h>
#include <history.h>
#include <active.h>
#include <chanlib.h>

#include "config.h"
#include "rnews.h"

/************************************************************************/
/*  validate_header                                                     */
/*                                                                      */
/*  Returns a pointer to a string array if header is valid or NULL      */
/*  otherwise.                                                          */
/*                                                                      */
/************************************************************************/
char **validate_header(char *buf, int bufsiz)
{
    char **ngarray = NULL;
    char *item = malloc(MAX_ITEMSIZE);
    int i;
    int isdupe = 0; /* true if duplicate id found */
    size_t len;
    long himsg;

    /*
     * First of all check for dupes
     */
    if(header[ID_Message_ID].info) {
        if(DOLOG(LOG_HISTORY))
            lprintf("Dupe check '%s'", header[ID_Message_ID].info);
        if(gethistart(cfg.historyfile, header[ID_Message_ID].info, NULL)) {
            header[ID_X_Newsgroups].info = header[ID_Newsgroups].info;
            if(find_active(NULL, cfg.dupegroup, NULL, &himsg))
                header[ID_Newsgroups].info = cfg.dupegroup;
            else if(find_active(NULL, cfg.junkgroup, NULL, &himsg))
                header[ID_Newsgroups].info = cfg.junkgroup;
            else {
                free(item);
                return(NULL);
            }
            lprintf("Duplicate article: %s", header[ID_Message_ID].info);
            sprintf(item, "<%lu.dupe$%s@%s>", himsg, job_id(0), cfg.mydomain);
            if((len = strlen(item) + 1) > (size_t)bufsiz) {
                lprintf("Buffer overflow while updating header");
                free(item);
                return(NULL);
            }
            else {
                strcpy(buf, item);
                header[ID_Message_ID].info = buf;
                buf += len;
                bufsiz -= len;
            }
            isdupe = 1;
        }
    }

    /*
     * Now check each required header entry
     */
    *item = '\0';
    for(i = 0; i < ID_LASTENTRY; i++) {
        switch(i) {
        case ID_Approved:
            if(cfg.approved[0])
                header[i].info = cfg.approved;
            break;

        case ID_Distribution:
            if(cfg.distribution[0])
                header[i].info = cfg.distribution;
            break;

        case ID_Expires:
            if(cfg.expires[0])
                header[i].info = cfg.expires;
            break;

        case ID_Followup_To:
            if(cfg.followupto[0])
                header[i].info = cfg.followupto;
            break;

        case ID_Organization:
            if(cfg.organization[0])
                header[i].info = cfg.organization;
            break;

        case ID_Reply_To:
            if(cfg.replyto[0])
                header[i].info = cfg.replyto;
            break;

        /*
         * In any case we need the newsgroups line
         */
        case ID_Newsgroups:
            if(!isdupe && cfg.newsgroups[0])
                header[i].info = cfg.newsgroups;
            if(header[i].info == NULL)
                lprintf("Newsgroups line missing, junked");
            else {
                if((ngarray = build_ngarray(header[i].info, NULL)) != NULL) {
                    if(ngarray[0] == NULL) {
                        lprintf("No valid newsgroups, junked: %s", header[i].info);
                        free_ngarray(ngarray);
                        ngarray = NULL;
                    }
                }
                else
                    lprintf("Newsgroups line problem, junked");
            }
            if(ngarray == NULL) {
                ngarray = malloc(2 * sizeof(char *));
                ngarray[0] = strdup(cfg.junkgroup);
                ngarray[1] = NULL;
                header[ID_X_Newsgroups].info = header[i].info;
                header[i].info = cfg.junkgroup;
            }
            break;

        /*
         * If the article contains a path line then we
         * put our machine name in front of it.
         */
        case ID_Path:
            if(header[i].info) {
                char c;
                char *cp = header[i].info;
                while(*cp && strchr(" !:@^%", *cp) == NULL)
                    cp++;
                c = *cp;
                *cp = '\0';
                if(stricmp(header[i].info, cfg.mynode)) {
                    strcpy(item, cfg.mynode);
                    strcat(item, "!");
                }
                *cp = c;
                strcat(item, header[i].info);
            }
            else {
                strcpy(item, cfg.mynode);
                lprintf("Created missing path line");
            }
            break;

        /*
         * If one of the following lines is missing we'll add one
         */
        case ID_From:
            if(header[i].info == NULL) {
                strcpy(item, "unknown@");
                strcat(item, cfg.mydomain);
                strcat(item, " (Unknown User)");
                lprintf("Created missing from line");
            }
            break;

        case ID_Subject:
            if(cfg.subject[0])
                header[i].info = cfg.subject;
            else if(header[i].info == NULL) {
                strcpy(item, "<none>");
                lprintf("Created missing subject line");
            }
            break;

        case ID_Date:
            if(header[i].info == NULL) {
                rfc_date(item, MAX_ITEMSIZE);
                lprintf("Created missing date line");
            }
            break;

        case ID_Message_ID:
            if(header[i].info == NULL) {
                char pck[MAX_PCKSTRING];
                sprintf(item, "<%s$%s@%s>", radixpack(time(NULL), pck),
                        job_id(0), cfg.mydomain);
                lprintf("Created missing message id: %s", item);
            }
            break;

        /*
         * Remove any xref leftovers
         */
        case ID_Xref:
            header[i].info = NULL;
            break;
        }

        if(*item) {
            if((len = strlen(item) + 1) > (size_t)bufsiz) {
                if(ngarray) {
                    free_ngarray(ngarray);
                    ngarray = NULL;
                }
                lprintf("Buffer overflow while updating header");
                break;
            }
            else {
                strcpy(buf, item);
                header[i].info = buf;
                buf += len;
                bufsiz -= len;
                *item = '\0';
            }
        }
    }

    free(item);
    return(ngarray);
}
