#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <lprintf.h>
#include <chanlib.h>
#include <readcfg.h>

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
static int parseargline(char *line, char ***argvp)
{
    char *item;
    char **argv = *argvp;
    char *cp = line;
    int  nargs;

    /*
     * Free previously allocated arg table
     */
    if (argv != NULL) {
        for (nargs = 0; argv[nargs] != NULL; nargs++)
            free(argv[nargs]);
        free(argv);
    }

    /*
     * In this first loop we count the number of arguments.
     */
    for(nargs = 0, cp = line; *cp;) {
        /*
         * Skip leading spaces
         */
        while(*cp == ' ' || *cp == '\t')
            cp++;
        if (*cp == '\0')
	    break;

        /*
         * Walk to end of item
         */
        if(*cp == '"') {
            while(*++cp && *cp != '"');
            cp++;
        }
        else {
            while(*cp && *cp != ' ' && *cp != '\t')
                cp++;
        }
        ++nargs;
    }

    argv = malloc((nargs + 1) * sizeof(char *));

    for(nargs = 0; *line;) {
        /*
         * Skip leading spaces
         */
        while(*line == ' ' || *line == '\t')
            line++;
	if (*line == '\0')
	    break;

        item = line;
        if(*item == '"') {
            item++;
            while(*++line && *line != '"');
        }
        else {
            while(*line && *line != ' ' && *line != '\t')
                line++;
        }
        *line++ = '\0';
        argv[nargs++] = strdup(item);
    }
    argv[nargs] = NULL;
    *argvp = argv;
    return (nargs);
}

int cmpcfgitm(char *key, CFGITEM *ip)
{
    return(stricmp(key, ip->key));
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
int ReadCfg(char *name, CFGITEM cfgitm[], int items)
{
    char line[255];
    char *cp;
    char **argp = NULL;
    int  argn;
    FILE *fp = xopen(name, "rt");

    if (fp == NULL)
	return (-1);
    while (fgets(line, sizeof(line), fp)) {
        cp = line;
        while(*cp) {
            if(*cp == '#') {
                *cp = '\0';
                break;
            }
            if(*cp++ == '"')
                while(*cp)
                    if(*cp++ == '"')
                        break;
        }
	if ((cp = strchr(line, '\n')) != NULL)
	    *cp = '\0';
        if((argn = parseargline(line, &argp)) > 0) {
            CFGITEM *ip;

            ip = bsearch(argp[0], cfgitm, items, sizeof(CFGITEM), cmpcfgitm);
            if(ip == NULL)
                lprintf("Unknown item %s in %s\n", argp[0], name);
            else {
                if(ip->val) {
                    switch(ip->typ) {
                    case 1:
                        if(argn > 1)
                            *((char *)(ip->val)) = argp[1][0];
                        break;
                    case 2:
                        if(argn > 1)
                            *((int *)(ip->val)) = atoi(argp[1]);
                        break;
                    case 3:
                        if(argn > 1)
                            *((long *)(ip->val)) = atol(argp[1]);
                        break;
                    case 4:
                        if(ip->ovrwrt || *((char *)ip->val) == '\0') {
                            int i;
                            for(i = 1; i < argn; i++) {
                                if(i > 1)
                                    strcat(ip->val, " ");
                                strcat(ip->val, argp[i]);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }
    fclose(fp);
}
