#include <stdlib.h>
#include <string.h>

char radixtbl[] ="0123456789BCDFGHJKLMNPQRSTVWXYZbcdfghjklmnpqrstvwxyz";

#define RADIX (sizeof(radixtbl)-1)

/************************************************************************/
/* radixpack                                                            */
/*                                                                      */
/* Packs a long value using alphanumeric characters.                    */
/*                                                                      */
/************************************************************************/
char *radixpack(unsigned long val, char *pck)
{
    char buf[8];
    char *cp = &buf[sizeof(buf) - 1];

    *cp = '\0';
    do {
        *--cp = radixtbl[val % RADIX];
        val /= RADIX;
    } while(val);

    return(strcpy(pck, cp));
}

/************************************************************************/
/* radixunpack                                                          */
/*                                                                      */
/* Unpacks a long value from a string created by radixpack.             */
/*                                                                      */
/************************************************************************/
unsigned long radixunpack(char *pck)
{
    int i;
    char *cp;
    unsigned long val = 0;

    while(*pck) {
        val *= RADIX;
        for(i = 0, cp = radixtbl; *cp; cp++) {
            if(*cp == *pck)
                break;
            val++;
        }
        pck++;
    }

    return(val);
}
