/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      nntpxfer
 *
 *      Brian Kantor, UCSD 1986
 *      Stan Barber, November 7, 1989
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <lprintf.h>
#include <history.h>
#include <tcpconn.h>

#include "config.h"
#include "chanx.h"

/************************************************************************/
/*                                                                      */
/************************************************************************/
int query_ids(int s, char *ngs, long ldate, long ltime, char *dstrb)
{
    int nart = 0;
    int skipped = 0;
    int dupes = 0;

    if (*dstrb)
        sprintf(buf, "NEWNEWS %s %06lu %06lu GMT <%s>", ngs, ldate, ltime, dstrb);
    else
        sprintf(buf, "NEWNEWS %s %06lu %06lu GMT", ngs, ldate, ltime);
    if(so_printf(s, "%s\r\n", buf) < 0)
        return(-1);
    lprintf("%s", buf);

    if(recv_line(s, buf) <= 0)
        return(-1);
    if (buf[0] != '2') {
        lprintf("Server error: %s", buf);
        return(-1);
    }

    for (;;) {
        if(recv_line(s, buf) <= 0)
            return(-1);
	if (!strcmp(buf, "."))
            break;
        if(skipped) {
            skipped++;
            continue;
        }
        if (gethistart(cfg.historyfile, buf, NULL))
            dupes++;
        else if (nart >= MAX_ARTICLES)
            skipped++;
        else {
            artlist[nart++] = strdup(buf);
            printf("\r%d", nart);
        }
    }
    printf(" new article(s)");
    if(dupes) {
        printf(" and %d dupe(s) found", dupes);
        lprintf("%d duplicate article(s)", dupes);
    }
    if(skipped) {
        printf(", %d article(s) skipped", skipped);
        lprintf("%d article(s) skipped", skipped);
    }
    printf("\n");

    return(nart);
}


/************************************************************************/
/*                                                                      */
/************************************************************************/
int query_arts(int s, char *filename, int newart)
{
    int nart = 0;
    int miss = 0;
    int i;
    int rc;
    FILE *fp;

    if ((fp = fopen(filename, "ab")) == NULL) {
        lperror(filename);
        return(-1);
    }

    for (i = 0; i < newart; i++) {
        if((rc = artfetch(s, fp, artlist[i])) == 1) {
            nart++;
            printf("\r%d", nart);
        }
        else if(rc == 0) {
            miss++;
            lprintf("Article not found: %s", artlist[i]);
        }
        else
            break;
    }
    fclose(fp);

    printf(" of %d article(s) retrieved", newart);
    if(miss) {
        printf(" and %d missing", miss);
        lprintf("%d article(s) missing", miss);
    }
    printf("\n");

    return(nart);
}
