/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define OS2
#include <os2.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <tcpconn.h>

#include "date.h"
#include "globals.h"
#include "nntp.h"
#include "changi.h"

char ngdatefile[]= "active.times";


/*
 * NEWGROUPS date time ["GMT"] [<distributions>]
 *
 * Display new newsgroups since a given date and time, but only
 * for those in <distributions>.
 */

void newgroups(PNEWSCLIENT pnc, int argc, char *argv[])
{
    char line[NNTP_STRLEN];
    register char *cp, *temp;
    static char **dist_list = (char **)NULL;
    int distcount = 0;
    int i;
    long date;
    register FILE *date_fp;
    char *reqlist[2];

    if (argc < 3) {
	so_printf(pnc -> s, "%d Usage: NEWGROUPS yymmdd hhmmss [\"GMT\"] "
		  "[<distributions>].\r\n",
		  ERR_CMDSYN);
	return;
    }

    date_fp = fopen(ngdatefile, "r");
    if (date_fp == NULL) {
	so_printf(pnc -> s, "%d Cannot open active.times file.\r\n", ERR_FAULT);
	return;
    }

    /* YYMMDD                  HHMMSS      */
    if (strlen(argv[1]) != 6 || strlen(argv[2]) != 6) {
	so_printf(pnc -> s, "%d Date/time must be in form YYMMDD HHMMSS.\r\n",
		  ERR_CMDSYN);
	fclose(date_fp);
	return;
    }

    strcpy(line, argv[1]);		/* yymmdd */
    strcat(line, argv[2]);		/* hhmmss */

    date = dtol(line);
    if (date < 0) {
	so_printf(pnc -> s, "%d Invalid date specification.\r\n", ERR_CMDSYN);
	fclose(date_fp);
	return;
    }

    argc -= 3;
    argv += 3;

    if (argc > 0 && !stricmp(*argv, "GMT")) {	/* We store stuff in GMT */
	++argv;				/* anyway, so this is */
	--argc;				/* a "noop" */
    }
    else				/* But that means not GMT */
	date = local_to_gmt(date);	/* is a definite "op" */

    if (argc > 0) {
	distcount = get_distlist(&dist_list, *argv);
	if (distcount < 0) {
	    so_printf(pnc -> s, "%d Bad distribution list: %s\r\n",
		      ERR_CMDSYN, *argv);
	    fclose(date_fp);
	    return;
	}
    }

    so_printf(pnc -> s, "%d New newsgroups since %s follow.\r\n", OK_NEWGROUPS, line);

    while (fgets(line, sizeof(line), date_fp) != NULL) {
	if ((cp = strchr(line, '\n')) != NULL)
	    *cp = '\0';
	if ((cp = strchr(line, ' ')) != NULL)
	    *cp = '\0';
	if (atol(cp + 1) < date)
	    continue;

	if (distcount == 0) {
	    reqlist[0] = line;
	    reqlist[1] = NULL;

	    if (ngpermcount) {
		if (ngmatch(s1strneql, 1,
			    ngpermlist, ngpermcount, reqlist, 1) == 0) {
		    continue;
		}
	    }

            if(so_puts(pnc -> s, line) == -1)
                break;
            if(so_puts(pnc -> s, "\r\n") == -1)
                break;
	}
        else {
            int fbreak = 0;
	    temp = line;
	    cp = strchr(temp, '.');
	    if (cp == NULL)
		continue;
	    *cp = '\0';
	    for (i = 0; i < distcount; ++i)
		if (strcmp(temp, dist_list[i]) == 0) {
		    *cp = '.';
                    if(so_puts(pnc -> s, temp) == -1) {
                        fbreak = 1;
                        break;
                    }
                    if(so_puts(pnc -> s, "\r\n") == -1)
                        fbreak = 1;
		    break;
                }
            if(fbreak)
                break;
	}
    }
    so_puts(pnc -> s, ".\r\n");
    fclose(date_fp);
}
