/************************************************************************/
/*                                                                      */
/*  Create pathname of a temporary file                                 */
/*                                                                      */
/*  Bug reports should be sent to                                       */
/*                                                                      */
/*  harald@os2point.ping.de                                             */
/*  harald@haport.sesam.com                                             */
/*  Fido: 2:2448/434                                                    */
/*                                                                      */
/************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

#include <chanlib.h>

char *maketemp(char *pathname, const char *template)
{
    register char *cp1;
    register char *cp = pathname;

    if((cp1 = getenv("TMP")) != NULL) {
        while(*cp1) {
            if(*cp1 == '\\') {
                *cp++ = '/';
                cp1++;
            }
            else
                *cp++ = *cp1++;
        }
        if(*(cp - 1) != '/')
            *cp++ = '/';
    }
    mktemp(strcpy(cp, template));

    return(pathname);
}
