/*
 * Logging
 *
 *
 * Bug reports should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>

#include <lprintf.h>

static long lsem = 0L;
static FILE *fp = NULL;

/************************************************************************/
/*                                                                      */
/************************************************************************/
int lopen(char *filename)
{
    return((fp = fopen(filename, "at")) != NULL);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void lclose(void)
{
    if(fp)
        fclose(fp);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void _cdecl lprintf(char *format,...)
{
    va_list marker;
    FILE *stream = stderr;
    char *cp = format;

    while((cp = strchr(cp, '\n')) != NULL)
        *cp = ' ';

    if(fp) {
        time_t now = time(NULL);
        struct tm *snow = localtime(&now);

        fprintf(fp, "%02u/%02u-%02u:%02u ", snow->tm_mon + 1,
                                            snow->tm_mday,
                                            snow->tm_hour,
                                            snow->tm_min);
        stream = fp;
    }

    va_start(marker, format);
    vfprintf(stream, format, marker);
    va_end(marker);
    fputc('\n', stream);
    fflush(stream);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void lperror(const char *string)
{
    lprintf("%s", _strerror(string));
}
