#include <stdlib.h>
#include <stdio.h>
#include <process.h>

#include <lprintf.h>
#include <chanlib.h>

char *job_id(int update)
{
    static char job[4];
    static char set[] = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    static long base = sizeof(set) - 1;
    long seq;
    size_t c;
    FILE *fp = xopen("SEQF", "rt");

    /*
     * Read last sequence number
     */
    if(fp) {
        if(fscanf(fp, "%ld", &seq) != 1)
            seq = getpid();
        fclose(fp);
    }
    else
        seq = getpid();

    if(update) {
        /*
         * Update next sequence number
         */
        fp = xopen("SEQF", "wt");
        if(fp) {
            fprintf(fp, "%ld\n", seq + 1);
            fclose(fp);
        }
        else
            lperror("SEQF");
    }

    /*
     * Convert sequence to 3-char job id
     */
    seq %= base * base * base;
    job[c = sizeof(job) - 1] = '\0';
    while(c-- > 0) {
        job[c] = set[seq % base];
        seq /= base;
    }
    return(job);
}
