/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define OS2
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <process.h>

#include "globals.h"
#include "nntp.h"
#include "changi.h"

/* #ifdef MSGID             harald */
/* #include "msgid.h"       harald */
/* #endif                   harald */

#ifdef LOG
int ih_accepted;
int ih_rejected;
int ih_failed;

#endif

#ifdef OS2PATCH
/*
 * IHAVE <messageid>
 *
 * Accept an article for transferral if we haven't seen it before.
 */

void ihave(int argc, char *argv[])
{
    char art_path[255];
    char errbuf[2 * NNTP_STRLEN];
    int retcode;
    register char *cp;

#ifdef MSGID
    int dup = 0;

#endif

    if (!canxfer) {

#ifdef LOG
	syslog(LOG_INFO, "%s ihave attempted without permission",
	       hostname);
#endif

	so_printf(pnc -> s, "%d You do not have transfer permission\r\n",
		  ERR_GOODBYE);
	return;
    }

    if (argc != 2) {
	so_printf(pnc -> s, "%d Usage: IHAVE <message-id>.\r\n", ERR_CMDSYN);
	return;
    }

#ifdef MSGID
    if (msgid(argv[1], MADD))
	dup++;

    if (!dup) {
	cp = gethistent(argv[1], art_path);
	if (cp != NULL) {
	    dup++;
	    msgid(argv[1], MOLD);
	}
    }
    if (dup) {
#else
    cp = gethistent(argv[1], art_path);
    if (cp != NULL) {
#endif				/* MSGID */

	so_printf(pnc -> s, "%d Got it.\r\n", ERR_GOTIT);

#ifdef LOG
	ih_rejected++;

#ifdef IHAVE_DEBUG
	syslog(LOG_DEBUG, "%s ihave %s rejected", hostname, argv[1]);
#endif

#endif

	return;
    }

    if (!space(MINFREE)) {
	/* force error reporting code into sending */
	/* an out-of-space error message	       */
	if (gethostname(errbuf, MAXHOSTNAMELEN) < 0)
	    strcpy(errbuf, "Amnesiac");

	strcat(errbuf, " NNTP server out of space. Try later.");

	retcode = 0;			/* indicates that an error occurred */
    }
    else

#ifdef BATCHED_INPUT
	/* C news input hook */
	retcode = batch_input_article(CONT_XFER, ERR_XFERFAIL,
				      errbuf, argv[1]);
#else
	retcode = spawn(rnews, "rnews", (char *)0, CONT_XFER,
			ERR_XFERFAIL, errbuf, argv[1]);
#endif

    if (retcode <= 0) {
	/* Reject if "*:<optional_whitespace>inbound*", else fail */
	register int i;

#ifdef MSGID
	msgid(argv[1], MCANCEL);
#endif

	i = ERR_XFERFAIL;
	if (cp = index(errbuf, ':')) {
	    for (++cp; isspace(*cp); ++cp) ;
	    if (strncasecmp(cp, "inbound", 7) == 0)
		i = ERR_XFERRJCT;
	}
	so_printf(pnc -> s, "%d %s\r\n", i, errbuf);
    }
    else
	so_printf(pnc -> s, "%d Thanks.\r\n", OK_XFERED);

#ifdef LOG
    if (retcode == 1)
	ih_accepted++;
    else
	ih_failed++;

#ifdef IHAVE_DEBUG
    syslog(LOG_DEBUG, "%s ihave %s accepted %s",
	   hostname, argv[1], retcode == 1 ? "succeeded" : "failed");
#endif

#endif				/* LOG */

}

#else

void ihave(PNEWSCLIENT pnc, int argc, char *argv[])
{
    if (pnc && argc && argv) ;
}

#endif
