#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <active.h>
#include <lprintf.h>

#include <chanlib.h>

/************************************************************************/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
char **build_ngarray(char *newsgroups, char *activefile)
{
    char *cp, *cp1;
    int  cnt = 0;
    char **grparray = NULL;

    for (cp = newsgroups; cp != NULL; cp = cp1) {
        if ((cp1 = strchr(cp, ',')) != NULL)
            *cp1 = '\0';
        if (strlen(cp) > GRPNAMESIZE - 1)
            lprintf("Newsgroup name too long: %s", cp);
        else {
            if(search_group(activefile, cp) != -1)
                cnt++;
        }
        if(cp1)
            *cp1++ = ',';
    }
    grparray = malloc((cnt + 1) * sizeof(char *));
    cnt = 0;
    for (cp = newsgroups; cp != NULL; cp = cp1) {
        if((cp1 = strchr(cp, ',')) != NULL)
            *cp1 = '\0';
        if(strlen(cp) <= GRPNAMESIZE - 1 &&
           search_group(activefile, cp) != -1)
            grparray[cnt++] = strdup(cp);
        if(cp1)
            *cp1++ = ',';
    }
    grparray[cnt] = NULL;

    return(grparray);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
void free_ngarray(char **grparray)
{
    int i;

    if(grparray) {
        for(i = 0; grparray[i] != NULL; i++)
            free(grparray[i]);
        free(grparray);
    }
}
