/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>

#include <active.h>

#include <tcpconn.h>

#include "config.h"
#include "globals.h"
#include "nntp.h"
#include "changi.h"


#ifdef XTHREAD
extern char *thread_name();

#endif

#ifdef XOVER
extern void over_close();

#endif

/*
 * GROUP newsgroup
 *
 * Change the current group to the specified newsgroup.
 * We also change our current directory to that newsgroup if
 * a spool directory for it exists.
 * If the newsgroup specified is invalid, the old newsgroup
 * remains selected.
 */

void group(PNEWSCLIENT pnc, int argc, char *argv[])
{
    char temp_dir[256];
    long high_msg, low_msg;
    char *cp;
    char *reqlist[2];

    if (argc != 2) {
	so_printf(pnc -> s, "%d Usage: GROUP newsgroup.\r\n", ERR_CMDSYN);
	return;
    }

    if (!pnc -> canread) {
	so_printf(pnc -> s, "%d You only have permission to transfer, sorry.\r\n",
		  ERR_ACCESS);
	return;
    }

    if (strchr(argv[1], '/') != (char *)NULL) {
	so_printf(pnc -> s, "%d Invalid group name (bad format).\r\n",
		  ERR_NOGROUP);
	return;
    }

    if (find_active(cfg.activefile, argv[1], &low_msg, &high_msg) < 0) {
	so_printf(pnc -> s, "%d Invalid group name (not in active).\r\n",
		  ERR_NOGROUP);
	return;
    }

    reqlist[0] = argv[1];
    reqlist[1] = NULL;

    if (ngpermcount) {
	if (ngmatch(s1strneql, 1, ngpermlist, ngpermcount, reqlist, 1) == 0) {
	    so_printf(pnc -> s, "%d You're not allowed to read %s, sorry.\r\n",
		      ERR_ACCESS, argv[1]);
	    return;
	}
    }

    if (pnc -> art_fp) {
	fclose(pnc -> art_fp);
	pnc -> art_fp = NULL;
    }
    if (pnc -> group_name)
	free(pnc -> group_name);
    chdir(cfg.newsdir);
    if ((pnc -> group_name = malloc(strlen(argv[1]) + 1)) != NULL)
	strcpy(pnc -> group_name, argv[1]);

    while ((cp = strchr(argv[1], '.')) != (char *)NULL)
	*cp = '/';

    strcpy(temp_dir, cfg.newsdir);
    strcat(temp_dir, "/");
    strcat(temp_dir, argv[1]);

    /*
     * (void) because a group can be in the active file but not have a spool directory.  Just leave
     * us chdired to base spool directory if this fails.
     */
    chdir(temp_dir);

    pnc -> num_arts = scan_dir(low_msg, high_msg, pnc -> art_array);
    pnc -> art_ptr = 0;

    pnc -> ingroup = 1;

    while ((cp = strchr(argv[1], '/')) != (char *)NULL)
	*cp = '.';

    so_printf(pnc -> s, "%d %d %ld %ld %s\r\n",
	      OK_GROUP,
	      pnc -> num_arts,
              (pnc -> num_arts > 0 ? pnc -> art_array[0] : 0L),
          (pnc -> num_arts > 0 ? pnc -> art_array[pnc -> num_arts - 1] : 0L),
	      argv[1]);
}

/*
 * LISTGROUP [group]
 *
 * Lists all article numbers (filenames) in the given group. Used by
 * newsreaders such as nn and trn for fast validation of a database.
 * If a group name is given it becomes the current group.
 *
 * This command is an extension, and not included in RFC 977.
 */

void listgroup(PNEWSCLIENT pnc, int argc, char *argv[])
{
    register int i;

    if (argc == 2) {
	pnc -> ingroup = 0;
	/* This will output a success or failure message */
	group(pnc, argc, argv);
	if (!pnc -> ingroup) {
	    return;
	}
    }
    else if (argc > 2) {
	so_printf(pnc -> s, "%d Usage: LISTGROUP [newsgroup].\r\n", ERR_CMDSYN);
	return;
    }
    else if (!pnc -> ingroup) {
	so_printf(pnc -> s, "%d You are not currently in a newsgroup.\r\n",
		  ERR_NCING);
	return;
    }
    else if (!pnc -> canread) {
	so_printf(pnc -> s, "%d You only have permission to transfer, sorry.\r\n",
		  ERR_ACCESS);
	return;
    }
    else {
	/* output a success message when no group name is given */
        so_printf(pnc -> s, "%d %d %ld %ld %s\r\n",
		  OK_GROUP,
		  pnc -> num_arts,
                  (pnc -> num_arts > 0 ? pnc -> art_array[0] : 0L),
          (pnc -> num_arts > 0 ? pnc -> art_array[pnc -> num_arts - 1] : 0L),
		  pnc -> group_name ? pnc -> group_name : "(current group)");
    }

    for (i = 0; i < pnc -> num_arts; i++)
        if(so_printf(pnc -> s, "%ld\r\n", pnc -> art_array[i]) == -1)
            return;
    so_puts(pnc -> s, ".\r\n");
}
