#ifndef CONFIG_H
#define CONFIG_H

#define MAX_NGNAME      255     /* max length of a ng name */
#define MAX_ITEMSIZE    2048    /* max length of a header line */
#define MAX_CFGLINE     255     /* max length of a cfg line */
#define MAX_NODENAME    32      /* max length of a node name */
#define MAX_DOMAINNAME  128     /* max length of a domain name */
#define MAX_LONGSTRING  12      /* max length of ltoa result */
#define MAX_PCKSTRING   8       /* max length of radixpack result */
#define MAX_CLPSIZE     255     /* max length of cmd line parameter */

#define PROCBUFSIZE     16384   /* size of article processing buffer */
#define COPYBUFSIZE     2048    /* size of file copy buffer */

/*----------------------------------------------------------------------*/
/*  Configuration                                                       */
/*                                                                      */
/*----------------------------------------------------------------------*/
typedef struct {
    char workdir[_MAX_PATH];
    char logfile[_MAX_PATH];
    char pidfile[_MAX_PATH];
    char configfile[_MAX_PATH];     /* configuration file pathname */
    char mynode[MAX_NODENAME];      /* local node name without domain */
    char mydomain[MAX_DOMAINNAME];  /* local node name including domain */
    char activefile[_MAX_PATH];     /* active file pathname */
    long logflg;                    /* debugging flags */
    char newsfile[_MAX_PATH];       /* article file if not stdin */
    char newsdir[_MAX_PATH];        /* news home directory */
    char historyfile[_MAX_PATH];    /* history file pathname */
    char uncompresscall[_MAX_PATH]; /* call to uncompress */
    char gunzipcall[_MAX_PATH];     /* call to gunzip */
    char junkgroup[MAX_NGNAME];     /* name of newsgroup 'junk' */
    char dupegroup[MAX_NGNAME];     /* name of newsgroup 'duplicates' */
    char approved[MAX_CLPSIZE];     /* overwrite approved line */
    char distribution[MAX_CLPSIZE]; /* overwrite distribution line */
    char expires[MAX_CLPSIZE];      /* overwrite expire line */
    char followupto[MAX_CLPSIZE];   /* overwrite followup-to line */
    char newsgroups[MAX_CLPSIZE];   /* overwrite newsgroups line */
    char organization[MAX_CLPSIZE]; /* overwrite organization line */
    char replyto[MAX_CLPSIZE];      /* overwrite replyto line */
    char signfile[MAX_CLPSIZE];     /* append signature file */
    char subject[MAX_CLPSIZE];      /* overwrite subject line */
} CONFIG;

extern CONFIG cfg;

extern void init_cfg(void);
extern int validate_cfg(void);

/*----------------------------------------------------------------------*/
/*  Logging flags                                                       */
/*----------------------------------------------------------------------*/
#define LOG_FLUSH   0x00000001L
#define LOG_READ    0x00000002L
#define LOG_WRITE   0x00000004L
#define LOG_HISTORY 0x00000008L
#define LOG_ACTIVE  0x00000010L

#define DOLOG(x)    ((cfg.logflg & (x)) != 0)

#endif
