/*
 * This part was written by Harald Kipp
 *
 * Bug reports should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * This module contains routines to read the configuration file.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>

#include <lprintf.h>
#include <chanlib.h>
#include <readcfg.h>

#include "config.h"


CONFIG cfg;

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
void init_cfg(void)
{
    char *cp;

    memset(&cfg, 0, sizeof(cfg));
    if((cp = getenv("CHANGIWORKDIR")) != NULL)
        fine_dir(strcpy(cfg.workdir, cp), NULL);
    else
        fine_dir(getcwd(cfg.workdir, sizeof(cfg.workdir)), NULL);
    fine_dir(strcpy(cfg.logfile, "rnews.log"), cfg.workdir);
    fine_dir(strcpy(cfg.configfile, "changi.cfg"), cfg.workdir);
    fine_dir(strcpy(cfg.pidfile, "rnews.pid"), cfg.workdir);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
int validate_cfg(void)
{
    int result = 0;
    char *cp;

    if(!cfg.mydomain[0]) {
        if((cp = getenv("HOSTNAME")) != NULL)
            strcpy(cfg.mydomain, cp);
    }
    if(!cfg.mynode[0]) {
        if((cp = strchr(cfg.mydomain, '.')) != NULL)
            *cp = '\0';
        strcpy(cfg.mynode, cfg.mydomain);
        if(cp)
            *cp = '.';
    }
    if(!cfg.mynode[0])
        lprintf("Missing my node name");
    else if(!cfg.mydomain[0])
        lprintf("Missing my domain name");
    else {
        if(fine_dir(cfg.activefile, cfg.workdir) == NULL)
            fine_dir(strcpy(cfg.activefile, "active"), cfg.workdir);
        if(fine_dir(cfg.historyfile, cfg.workdir) == NULL)
            fine_dir(strcpy(cfg.historyfile, "history"), cfg.workdir);
        if(fine_dir(cfg.newsdir, cfg.workdir) == NULL)
            fine_dir(strcpy(cfg.newsdir, "news"), cfg.workdir);
        if(fine_dir(cfg.uncompresscall, NULL) == NULL)
            strcpy(cfg.uncompresscall, "uncompre");
        if(fine_dir(cfg.gunzipcall, NULL) == NULL)
            strcpy(cfg.gunzipcall, "gzip -d");
        if(cfg.junkgroup[0] == '\0')
            strcpy(cfg.junkgroup, "junk");
        if(cfg.dupegroup[0] == '\0')
            strcpy(cfg.dupegroup, "duplicates");
        result = 1;
    }
    return(result);
}
