PROJ = chanx
PROJFILE = chanx.mak
DEBUG = 0

PWBRMAKE  = pwbrmake
NMAKEBSC1  = set
NMAKEBSC2  = nmake
CC  = cl
CFLAGS_G  = /AL /W4 /G2 /Zp /BATCH
CFLAGS_D  = /qc /Gi$(PROJ).mdt /Zr /Zi /Od
CFLAGS_R  = /Ot /Ol /Og /Oe /Oi /Gs
MAPFILE_D  = NUL
MAPFILE_R  = $(PROJ).map
LFLAGS_G  =  /NOI /STACK:12288  /BATCH
LFLAGS_D  = /CO /INC /FAR /PACKC /PACKD /PMTYPE:VIO
LFLAGS_R  =  /M /EXE /FAR /PACKC /PACKD  /PMTYPE:VIO
LINKER  = link
ILINK  = ilink
LRF  = echo > NUL
LLIBS_R  =  /NOD:LLIBCE LLIBCEP
LLIBS_D  =  /NOD:LLIBCE LLIBCEP
LLIBS_G  = tcpip

DEF_FILE  = chanx.def
OBJS  = chanx.obj artfetch.obj config.obj ..\lib\tcpconn.obj\
        ..\lib\lprintf.obj ..\lib\history.obj ..\lib\active.obj ..\lib\dbm.obj\
        ..\lib\idx.obj ..\lib\xopen.obj ..\lib\finedir.obj query.obj\
        ..\lib\readcfg.obj scandir.obj post.obj exit.obj
SBRS  = chanx.sbr artfetch.sbr config.sbr ..\lib\tcpconn.sbr\
        ..\lib\lprintf.sbr ..\lib\history.sbr ..\lib\active.sbr ..\lib\dbm.sbr\
        ..\lib\idx.sbr ..\lib\xopen.sbr ..\lib\finedir.sbr query.sbr\
        ..\lib\readcfg.sbr scandir.sbr post.sbr exit.sbr

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .obj .sbr .c

chanx.obj : chanx.c config.h chanx.h

chanx.sbr : chanx.c config.h chanx.h

artfetch.obj : artfetch.c chanx.h

artfetch.sbr : artfetch.c chanx.h

config.obj : config.c config.h

config.sbr : config.c config.h

..\lib\tcpconn.obj : ..\lib\tcpconn.c

..\lib\tcpconn.sbr : ..\lib\tcpconn.c

..\lib\lprintf.obj : ..\lib\lprintf.c

..\lib\lprintf.sbr : ..\lib\lprintf.c

..\lib\history.obj : ..\lib\history.c

..\lib\history.sbr : ..\lib\history.c

..\lib\active.obj : ..\lib\active.c

..\lib\active.sbr : ..\lib\active.c

..\lib\dbm.obj : ..\lib\dbm.c

..\lib\dbm.sbr : ..\lib\dbm.c

..\lib\idx.obj : ..\lib\idx.c

..\lib\idx.sbr : ..\lib\idx.c

..\lib\xopen.obj : ..\lib\xopen.c

..\lib\xopen.sbr : ..\lib\xopen.c

..\lib\finedir.obj : ..\lib\finedir.c

..\lib\finedir.sbr : ..\lib\finedir.c

query.obj : query.c config.h chanx.h

query.sbr : query.c config.h chanx.h

..\lib\readcfg.obj : ..\lib\readcfg.c

..\lib\readcfg.sbr : ..\lib\readcfg.c

scandir.obj : scandir.c config.h chanx.h

scandir.sbr : scandir.c config.h chanx.h

post.obj : post.c config.h chanx.h

post.sbr : post.c config.h chanx.h

exit.obj : exit.c config.h

exit.sbr : exit.c config.h


$(PROJ).bsc : $(SBRS)
        $(PWBRMAKE) @<<
$(BRFLAGS) $(SBRS)
<<

$(PROJ).exe : $(DEF_FILE) $(OBJS)
!IF $(DEBUG)
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_D)
$(LLIBS_G: = +^
) +
$(LLIBS_D: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_D);
<<
!ELSE
        $(LRF) @<<$(PROJ).lrf
$(RT_OBJS: = +^
) $(OBJS: = +^
)
$@
$(MAPFILE_R)
$(LLIBS_G: = +^
) +
$(LLIBS_R: = +^
) +
$(LIBS: = +^
)
$(DEF_FILE) $(LFLAGS_G) $(LFLAGS_R);
<<
!ENDIF
!IF $(DEBUG)
        $(ILINK) -a -e "$(LINKER) @$(PROJ).lrf" $@
!ELSE
        $(LINKER) @$(PROJ).lrf
!ENDIF


.c.obj :
!IF $(DEBUG)
        $(CC) /c $(CFLAGS_G) $(CFLAGS_D) /Fo$@ $<
!ELSE
        $(CC) /c $(CFLAGS_G) $(CFLAGS_R) /Fo$@ $<
!ENDIF

.c.sbr :
!IF $(DEBUG)
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_D) /FR$@ $<
!ELSE
        $(CC) /Zs $(CFLAGS_G) $(CFLAGS_R) /FR$@ $<
!ENDIF


run: $(PROJ).exe
        $(PROJ).exe $(RUNFLAGS)

debug: $(PROJ).exe
        CVP $(CVFLAGS) $(PROJ).exe $(RUNFLAGS)
