/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 * You may freely copy or redistribute this software. However,
 * this may not apply to any part of changi.
 */

char *version = "0.5";

#define OS2
#define INCL_DOSPROCESS
#include <os2.h>

#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netlib.h>

#undef min
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <process.h>

#include <chanlib.h>
#include <lprintf.h>
#include <readcfg.h>
#include <getopt.h>

#include "config.h"
#include "globals.h"
#include "changi.h"

/*
 * Globals
 */
char **ngpermlist;
int ngpermcount;

int num_groups;
char historyfile[255];

/*
 * Locals
 */
static CFGITEM cfgitm[] = {
    { "active"    , 0, 4, cfg.activefile     },
    { "batchfile" , 0, 4, NULL               },
    { "dupegroup" , 0, 4, NULL               },
    { "gunzip"    , 0, 4, NULL               },
    { "history"   , 0, 4, cfg.historyfile    },
    { "inews"     , 0, 4, cfg.inewscall      },
    { "junkgroup" , 0, 4, NULL               },
    { "mydomain"  , 0, 4, NULL               },
    { "mynode"    , 0, 4, NULL               },
    { "newsdir"   , 0, 4, cfg.newsdir        },
    { "newsserver", 0, 4, NULL               },
    { "rnews"     , 0, 4, NULL               },
    { "spooldir"  , 0, 4, NULL               },
    { "uncompress", 0, 4, NULL               }
};

static void usage(void);

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
int main(int argc, char **argv)
{
    unsigned short port = 119;		/* port server binds to                  */
    struct sockaddr_in server;		/* server address information            */
    int s;				/* socket for accepting connections      */
    int option;

    printf("\n        Changi NNTP Server version %s\n", version);
    printf("                       OS/2 nntpd port\n");
    printf("    written %s by Harald Kipp\n", __DATE__);
    printf("report bugs to harald@os2point.ping.de\n");
    printf("               harald@haport.sesam.com\n");
    printf("                       fido 2:2448/434\n\n");

    init_cfg();

    initexit();

    lopen(cfg.logfile);
    lprintf("Changi (%s)", __TIMESTAMP__);

    while((option = getopt(argc,argv,"a:c:d:i:n:y:?")) != EOF) {
        char *cp;
        switch(option) {
        case 'a':
            strcpy(cfg.activefile, optarg);
            break;
        case 'c':
            strcpy(cfg.configfile, optarg);
            break;
        case 'd':
            cp = optarg;
            while(*cp) {
                switch(*cp) {
                case 'a':
                    cfg.logflg |= LOG_ACTIVE;
                    break;
                case 'd':
                    cfg.logflg |= LOG_DBM;
                    break;
                case 'f':
                    cfg.logflg |= LOG_FLUSH;
                    break;
                case 'r':
                    cfg.logflg |= LOG_RECV;
                    break;
                case 's':
                    cfg.logflg |= LOG_SEND;
                    break;
                default:
                    lprintf("Unknown option -d%c ignored", *cp);
                    break;
                }
                cp++;
            }
            break;
        case 'i':
            strcpy(cfg.inewscall, optarg);
            break;
        case 'n':
            strcpy(cfg.newsdir, optarg);
            break;
        case 'y':
            strcpy(cfg.historyfile, optarg);
            break;
        default:
            usage();
            return(1);
        }
    }

    ReadCfg(cfg.configfile, cfgitm, sizeof(cfgitm) / sizeof(CFGITEM));
    if(!validate_cfg())
	return (3);

    strcpy(historyfile, cfg.historyfile);

    sock_init();

    if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
        lprintf("socket(): Error %d", errno);
	return (3);
    }

    server.sin_family = AF_INET;
    server.sin_port = htons(port);
    server.sin_addr.s_addr = INADDR_ANY;
    if (bind(s, (struct sockaddr *) & server, sizeof(server)) < 0) {
        lprintf("bind(): Error %d", errno);
	return (3);
    }

    if (listen(s, 1) != 0) {
        lprintf("listen(): Error %d", errno);
	return (3);
    }

    ClientThread(&s);
    for (;;)
	if (DosSleep(5000L))
	    break;

    soclose(s);
    lclose();

    return (0);
}

/************************************************************************/
/*                                                                      */
/*                                                                      */
/************************************************************************/
static void usage(void)
{
    puts("usage: changi [options]\n\n"
         "options:\n"
         "  -a<activefile>        active file (active)\n"
         "  -c<configfile>        configuration file (changi.cfg)\n"
         "  -d<log-flags>         logfile flags\n\n"
         "  -i<inewsprogram>      inews program call (inews)\n"
         "  -n<newsdir>           news home directory (news)\n"
         "  -y<historyfile>       history file (history)\n\n"
         "logfile flags:\n"
         "  a  log active file processing\n"
         "  d  history file processing\n"
         "  f  flush logfile after each line\n"
         "  r  telegrams received\n"
         "  s  telegrams sent\n");
}
