/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      nntpxfer
 *
 *      Brian Kantor, UCSD 1986
 *      Stan Barber, November 7, 1989
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */

#define OS2
#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netdb.h>

#undef min
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <io.h>

#include <tcpconn.h>
#include <lprintf.h>

#include "chanx.h"

/*
 * Returns 1 on success, 0 if failed to fetch, -1 on error
 */
int artfetch(int s, FILE * bfp, char *articleid)
{
    char *tmpfile;
    FILE *tfp;
    long art_size = 0L;

    /*
     * Ask for the article
     */
    if(so_printf(s, "ARTICLE %s\r\n", articleid) < 0)
        return(-1);
    if(recv_line(s, buf) <= 0)
        return(-1);
    if (buf[0] == '4') /* missing article, skip it */
	return (0);
    if (buf[0] != '2') {
        lprintf("Server error: %s", buf);
        soclose(s);
	exit(1);
    }

    tmpfile = tempnam(NULL, "CNX");
    if ((tfp = fopen(tmpfile, "w+t")) == NULL) {
        lperror(tmpfile);
	exit(1);
    }
    for (;;) {
	char *realline;

        if(recv_line(s, buf) <= 0)
            break;
	if (buf[0] == '.' && buf[1] == '\0')
	    break;
	realline = (buf[0] == '.') ? buf + 1 : buf;
	fputs(realline, tfp);
	fputc('\n', tfp);
	art_size += strlen(realline) + 1;
    }

    fprintf(bfp, "#! rnews %ld \n", art_size);
    rewind(tfp);
    while (fgets(buf, sizeof(buf), tfp))
	fputs(buf, bfp);

    fclose(tfp);
    unlink(tmpfile);
    free(tmpfile);

    return (1);
}
