/************************************************************************/
/*                                                                      */
/*  Arbitary length math routines for Changi                            */
/*                                                                      */
/*  Parts are Copyright (c) 1989-1994 by Kendra Electronic Wonderworks. */
/*                                                                      */
/*  Bug reports related to THIS modified version should be sent to      */
/*                                                                      */
/*  harald@os2point.ping.de                                             */
/*  harald@haport.sesam.com                                             */
/*  Fido: 2:2448/434                                                    */
/*                                                                      */
/************************************************************************/

#include <arbmath.h>

/************************************************************************/
/*                                                                      */
/************************************************************************/
int add(unsigned char *number,
        const unsigned range,
        const unsigned digits)
{
    unsigned subscript = digits;
    unsigned carry = range;

    while ((carry > 0) && (subscript-- > 0)) {
	unsigned digit = number[subscript] + carry;

	number[subscript] = (unsigned char)(digit % 0x100);
	carry = digit / 0x100;
    }

    return(carry == 0);
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
int adiv(unsigned char *number,
	 const unsigned divisor,
	 unsigned *remain,
	 const unsigned digits)
{
    unsigned subscript;
    int nonzero = 0;

    *remain = 0;

    for (subscript = 0; subscript < digits; subscript++) {
	unsigned digit = *remain * 0x100 + number[subscript];

	nonzero = nonzero || number[subscript];
	*remain = digit % divisor;
	number[subscript] = (unsigned char)(digit / divisor);
    }
    return nonzero;
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
int mult(unsigned char *number,
         const unsigned range,
         const unsigned digits)
{
    unsigned subscript = digits;
    unsigned carry = 0;

    while (subscript-- > 0) {
	unsigned digit = number[subscript] * range + carry;

	number[subscript] = (unsigned char)(digit % 0x100);
	carry = digit / 0x100;
    }

    return(carry == 0);
}
